# Generated by Django 4.1.4 on 2023-02-04 07:28

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("cast", "0032_remove_timestampedmodel_because_wagtail"),
    ]

    operations = [
        migrations.CreateModel(
            name="Podcast",
            fields=[
                (
                    "blog_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cast.blog",
                    ),
                ),
                (
                    "new_itunes_categories",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A json dict of itunes categories pointing to lists of subcategories. Taken from this list https://validator.w3.org/feed/docs/error/InvalidItunesCategory.html",
                        max_length=512,
                        verbose_name="itunes_categories",
                    ),
                ),
                (
                    "new_keywords",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A comma-delimitedlist of up to 12 words for iTunes\n            searches. Perhaps include misspellings of the title.",
                        max_length=255,
                        verbose_name="keywords",
                    ),
                ),
                (
                    "new_explicit",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "yes"), (2, "no"), (3, "clean")],
                        default=1,
                        help_text="``Clean`` will put the clean iTunes graphic by it.",
                        verbose_name="explicit",
                    ),
                ),
                (
                    "new_itunes_artwork",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="cast.itunesartwork"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("cast.blog",),
        ),
    ]
