# Generated by Django 4.1.5 on 2023-01-21 05:30

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("cast", "0026_delete_request_alter_post_body"),
    ]

    operations = [
        migrations.CreateModel(
            name="Episode",
            fields=[
                (
                    "post_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="cast.post",
                    ),
                ),
                (
                    "new_keywords",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A comma-demlimitedlist of up to 12 words for iTunes\n            searches. Perhaps include misspellings of the title.",
                        max_length=255,
                        verbose_name="keywords",
                    ),
                ),
                (
                    "new_explicit",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "yes"), (2, "no"), (3, "clean")],
                        default=1,
                        help_text="``Clean`` will put the clean iTunes graphic by it.",
                        verbose_name="explicit",
                    ),
                ),
                (
                    "new_block",
                    models.BooleanField(
                        default=False,
                        help_text="Check to block this episode from iTunes because <br />its content might cause the entire show to be <br />removed from iTunes.",
                        verbose_name="block",
                    ),
                ),
                (
                    "new_podcast_audio",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="episodes",
                        to="cast.audio",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("cast.post",),
        ),
    ]
