##########################################################################
# z3c.sqlalchemy - A SQLAlchemy wrapper for Python/Zope
#
# (C) Zope Corporation and Contributor
# Written by Andreas Jung for Haufe Mediengruppe, Freiburg, Germany
# and ZOPYX Ltd. & Co. KG, Tuebingen, Germany
##########################################################################


from zope.interface import Interface
from zope.schema import Bool
from zope.schema import Int
from zope.schema import TextLine


class ISQLAlchemyWrapper(Interface):
    """ A SQLAlchemyWrapper wraps sqlalchemy and deals with
        connection and transaction handling.
    """

    dsn = TextLine(title=u'A RFC-1738 style connection string',
                   required=True)

    dbname = TextLine(title=u'Database name',
                      required=True)

    host = TextLine(title=u'Hostname of database',
                    required=True)

    port = Int(title=u'Port of database',
               required=True)

    username = TextLine(title=u'Database user',
                        required=True)

    password = TextLine(title=u'Password of database user',
                        required=True)

    echo = Bool(title=u'Echo all SQL statements to the console',
                required=True)

    def registerMapper(mapper, name):
        """ register your own mapper under a custom name """

    def getMapper(tablename, schema='public'):
        """ return a mapper class for a table given by its
            'tablename' and an optional 'schema' name
        """

    def getMappers(*tablenames):
        """ return a sequence of mapper classes for a given list
            of table names.
            ATT: Schema support?
        """


class IModelProvider(Interface):
    """ A model providers provides information about the tables to be used
        and the mapper classes.
    """

    def getModel(metadata=None):
        """ The model is described as an ordered dictionary.  The entries are
            (tablename, some_dict) where 'some_dict' is a dictionary containing
            a key 'table' referencing a Table() instance and an optional key
            'relationships' referencing a sequence of related table names. An
            optional mapper class can be specified through the 'class' key
            (otherwise a default mapper class will be autogenerated).
        """


class IModel(Interface):
    """ A model represents a configuration hint for SQLAlchemy wrapper
        instances in order to deliver mappers for a given name.
    """

    def add(name, table=None, mapper_class=None, relations=None,
            autodetect_relations=False, table_name=None):
        """ 'name'  -- name of table (no schema support so far!)

            'table' -- a sqlalchemy.Table instance (None, for autoloading)

            'mapper_class' -- an optional class to be used as mapper class for
            'table'

            'relations' -- an optional list of table names referencing 'table'.
            This is used for auto-constructing the relation properties of the
            mapper class.

            'autodetect_relations' -- try to autodetect the relationships
            between tables and auto-construct the relation properties of the
            mapper if 'relations' is omitted (set to None)

            'table_name' -- optional full name of a table (e.g.
            'someschema.sometable') if you want to use 'name' as alias for
            the table.
        """

    def items():
        """ return items in insertion order """
