"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ProfileJsonBody:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "gender": "str",
        "birthday": "date",
        "height": "str",
        "about_me": "str",
        "fullname": "str",
        "country": "str",
        "state": "str",
        "city": "str",
        "stride_length_walking": "str",
        "stride_length_running": "str",
        "weight_unit": "str",
        "height_unit": "str",
        "water_unit": "str",
        "glucose_unit": "str",
        "timezone": "str",
        "foods_locale": "str",
        "locale": "str",
        "locale_lang": "str",
        "locale_country": "str",
        "start_day_of_week": "str",
    }

    attribute_map = {
        "gender": "gender",
        "birthday": "birthday",
        "height": "height",
        "about_me": "aboutMe",
        "fullname": "fullname",
        "country": "country",
        "state": "state",
        "city": "city",
        "stride_length_walking": "strideLengthWalking",
        "stride_length_running": "strideLengthRunning",
        "weight_unit": "weightUnit",
        "height_unit": "heightUnit",
        "water_unit": "waterUnit",
        "glucose_unit": "glucoseUnit",
        "timezone": "timezone",
        "foods_locale": "foodsLocale",
        "locale": "locale",
        "locale_lang": "localeLang",
        "locale_country": "localeCountry",
        "start_day_of_week": "startDayOfWeek",
    }

    def __init__(
        self,
        gender=None,
        birthday=None,
        height=None,
        about_me=None,
        fullname=None,
        country=None,
        state=None,
        city=None,
        stride_length_walking=None,
        stride_length_running=None,
        weight_unit=None,
        height_unit=None,
        water_unit=None,
        glucose_unit=None,
        timezone=None,
        foods_locale=None,
        locale=None,
        locale_lang=None,
        locale_country=None,
        start_day_of_week=None,
    ):  # noqa: E501
        """ProfileJsonBody - a model defined in Swagger"""  # noqa: E501
        self._gender = None
        self._birthday = None
        self._height = None
        self._about_me = None
        self._fullname = None
        self._country = None
        self._state = None
        self._city = None
        self._stride_length_walking = None
        self._stride_length_running = None
        self._weight_unit = None
        self._height_unit = None
        self._water_unit = None
        self._glucose_unit = None
        self._timezone = None
        self._foods_locale = None
        self._locale = None
        self._locale_lang = None
        self._locale_country = None
        self._start_day_of_week = None
        self.discriminator = None
        if gender is not None:
            self.gender = gender
        if birthday is not None:
            self.birthday = birthday
        if height is not None:
            self.height = height
        if about_me is not None:
            self.about_me = about_me
        if fullname is not None:
            self.fullname = fullname
        if country is not None:
            self.country = country
        if state is not None:
            self.state = state
        if city is not None:
            self.city = city
        if stride_length_walking is not None:
            self.stride_length_walking = stride_length_walking
        if stride_length_running is not None:
            self.stride_length_running = stride_length_running
        if weight_unit is not None:
            self.weight_unit = weight_unit
        if height_unit is not None:
            self.height_unit = height_unit
        if water_unit is not None:
            self.water_unit = water_unit
        if glucose_unit is not None:
            self.glucose_unit = glucose_unit
        if timezone is not None:
            self.timezone = timezone
        if foods_locale is not None:
            self.foods_locale = foods_locale
        if locale is not None:
            self.locale = locale
        if locale_lang is not None:
            self.locale_lang = locale_lang
        if locale_country is not None:
            self.locale_country = locale_country
        if start_day_of_week is not None:
            self.start_day_of_week = start_day_of_week

    @property
    def gender(self):
        """Gets the gender of this ProfileJsonBody.  # noqa: E501

        The sex of the user; (MALE/FEMALE/NA).  # noqa: E501

        :return: The gender of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._gender

    @gender.setter
    def gender(self, gender):
        """Sets the gender of this ProfileJsonBody.

        The sex of the user; (MALE/FEMALE/NA).  # noqa: E501

        :param gender: The gender of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._gender = gender

    @property
    def birthday(self):
        """Gets the birthday of this ProfileJsonBody.  # noqa: E501

        The date of birth in the format of yyyy-MM-dd.  # noqa: E501

        :return: The birthday of this ProfileJsonBody.  # noqa: E501
        :rtype: date
        """
        return self._birthday

    @birthday.setter
    def birthday(self, birthday):
        """Sets the birthday of this ProfileJsonBody.

        The date of birth in the format of yyyy-MM-dd.  # noqa: E501

        :param birthday: The birthday of this ProfileJsonBody.  # noqa: E501
        :type: date
        """

        self._birthday = birthday

    @property
    def height(self):
        """Gets the height of this ProfileJsonBody.  # noqa: E501

        The height in the format X.XX in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501

        :return: The height of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this ProfileJsonBody.

        The height in the format X.XX in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501

        :param height: The height of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._height = height

    @property
    def about_me(self):
        """Gets the about_me of this ProfileJsonBody.  # noqa: E501

        This is a short description of user.  # noqa: E501

        :return: The about_me of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._about_me

    @about_me.setter
    def about_me(self, about_me):
        """Sets the about_me of this ProfileJsonBody.

        This is a short description of user.  # noqa: E501

        :param about_me: The about_me of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._about_me = about_me

    @property
    def fullname(self):
        """Gets the fullname of this ProfileJsonBody.  # noqa: E501

        The fullname of the user.  # noqa: E501

        :return: The fullname of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._fullname

    @fullname.setter
    def fullname(self, fullname):
        """Sets the fullname of this ProfileJsonBody.

        The fullname of the user.  # noqa: E501

        :param fullname: The fullname of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._fullname = fullname

    @property
    def country(self):
        """Gets the country of this ProfileJsonBody.  # noqa: E501

        The country of the user's residence. This is a two-character code.  # noqa: E501

        :return: The country of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this ProfileJsonBody.

        The country of the user's residence. This is a two-character code.  # noqa: E501

        :param country: The country of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def state(self):
        """Gets the state of this ProfileJsonBody.  # noqa: E501

        The US state of the user's residence. This is a two-character code if the country was or is set to US.  # noqa: E501

        :return: The state of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ProfileJsonBody.

        The US state of the user's residence. This is a two-character code if the country was or is set to US.  # noqa: E501

        :param state: The state of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def city(self):
        """Gets the city of this ProfileJsonBody.  # noqa: E501

        The US city of the user's residence.  # noqa: E501

        :return: The city of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this ProfileJsonBody.

        The US city of the user's residence.  # noqa: E501

        :param city: The city of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def stride_length_walking(self):
        """Gets the stride_length_walking of this ProfileJsonBody.  # noqa: E501

        Walking stride length in the format X.XX, where it is in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501

        :return: The stride_length_walking of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._stride_length_walking

    @stride_length_walking.setter
    def stride_length_walking(self, stride_length_walking):
        """Sets the stride_length_walking of this ProfileJsonBody.

        Walking stride length in the format X.XX, where it is in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501

        :param stride_length_walking: The stride_length_walking of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._stride_length_walking = stride_length_walking

    @property
    def stride_length_running(self):
        """Gets the stride_length_running of this ProfileJsonBody.  # noqa: E501

        Running stride length in the format X.XX, where it is in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501

        :return: The stride_length_running of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._stride_length_running

    @stride_length_running.setter
    def stride_length_running(self, stride_length_running):
        """Sets the stride_length_running of this ProfileJsonBody.

        Running stride length in the format X.XX, where it is in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501

        :param stride_length_running: The stride_length_running of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._stride_length_running = stride_length_running

    @property
    def weight_unit(self):
        """Gets the weight_unit of this ProfileJsonBody.  # noqa: E501

        Default weight unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :return: The weight_unit of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._weight_unit

    @weight_unit.setter
    def weight_unit(self, weight_unit):
        """Sets the weight_unit of this ProfileJsonBody.

        Default weight unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :param weight_unit: The weight_unit of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._weight_unit = weight_unit

    @property
    def height_unit(self):
        """Gets the height_unit of this ProfileJsonBody.  # noqa: E501

        Default height/distance unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :return: The height_unit of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._height_unit

    @height_unit.setter
    def height_unit(self, height_unit):
        """Sets the height_unit of this ProfileJsonBody.

        Default height/distance unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :param height_unit: The height_unit of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._height_unit = height_unit

    @property
    def water_unit(self):
        """Gets the water_unit of this ProfileJsonBody.  # noqa: E501

        Default water unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :return: The water_unit of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._water_unit

    @water_unit.setter
    def water_unit(self, water_unit):
        """Sets the water_unit of this ProfileJsonBody.

        Default water unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :param water_unit: The water_unit of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._water_unit = water_unit

    @property
    def glucose_unit(self):
        """Gets the glucose_unit of this ProfileJsonBody.  # noqa: E501

        Default glucose unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :return: The glucose_unit of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._glucose_unit

    @glucose_unit.setter
    def glucose_unit(self, glucose_unit):
        """Sets the glucose_unit of this ProfileJsonBody.

        Default glucose unit on website (which doesn't affect API); one of (en_US, en_GB, 'any' for METRIC).  # noqa: E501

        :param glucose_unit: The glucose_unit of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._glucose_unit = glucose_unit

    @property
    def timezone(self):
        """Gets the timezone of this ProfileJsonBody.  # noqa: E501

        The timezone in the format 'America/Los_Angeles'.  # noqa: E501

        :return: The timezone of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """Sets the timezone of this ProfileJsonBody.

        The timezone in the format 'America/Los_Angeles'.  # noqa: E501

        :param timezone: The timezone of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._timezone = timezone

    @property
    def foods_locale(self):
        """Gets the foods_locale of this ProfileJsonBody.  # noqa: E501

        The food database locale in the format of xx.XX.  # noqa: E501

        :return: The foods_locale of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._foods_locale

    @foods_locale.setter
    def foods_locale(self, foods_locale):
        """Sets the foods_locale of this ProfileJsonBody.

        The food database locale in the format of xx.XX.  # noqa: E501

        :param foods_locale: The foods_locale of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._foods_locale = foods_locale

    @property
    def locale(self):
        """Gets the locale of this ProfileJsonBody.  # noqa: E501

        The locale of the website (country/language); one of the locales, currently – (en_US, fr_FR, de_DE, es_ES, en_GB, en_AU, en_NZ, ja_JP).  # noqa: E501

        :return: The locale of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """Sets the locale of this ProfileJsonBody.

        The locale of the website (country/language); one of the locales, currently – (en_US, fr_FR, de_DE, es_ES, en_GB, en_AU, en_NZ, ja_JP).  # noqa: E501

        :param locale: The locale of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._locale = locale

    @property
    def locale_lang(self):
        """Gets the locale_lang of this ProfileJsonBody.  # noqa: E501

        The Language in the format 'xx'. You should specify either locale or both - localeLang and localeCountry (locale is higher priority).  # noqa: E501

        :return: The locale_lang of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._locale_lang

    @locale_lang.setter
    def locale_lang(self, locale_lang):
        """Sets the locale_lang of this ProfileJsonBody.

        The Language in the format 'xx'. You should specify either locale or both - localeLang and localeCountry (locale is higher priority).  # noqa: E501

        :param locale_lang: The locale_lang of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._locale_lang = locale_lang

    @property
    def locale_country(self):
        """Gets the locale_country of this ProfileJsonBody.  # noqa: E501

        The Country in the format 'xx'. You should specify either locale or both - localeLang and localeCountry (locale is higher priority).  # noqa: E501

        :return: The locale_country of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._locale_country

    @locale_country.setter
    def locale_country(self, locale_country):
        """Sets the locale_country of this ProfileJsonBody.

        The Country in the format 'xx'. You should specify either locale or both - localeLang and localeCountry (locale is higher priority).  # noqa: E501

        :param locale_country: The locale_country of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._locale_country = locale_country

    @property
    def start_day_of_week(self):
        """Gets the start_day_of_week of this ProfileJsonBody.  # noqa: E501

        The Start day of the week, meaning what day the week should start on. Either Sunday or Monday.  # noqa: E501

        :return: The start_day_of_week of this ProfileJsonBody.  # noqa: E501
        :rtype: str
        """
        return self._start_day_of_week

    @start_day_of_week.setter
    def start_day_of_week(self, start_day_of_week):
        """Sets the start_day_of_week of this ProfileJsonBody.

        The Start day of the week, meaning what day the week should start on. Either Sunday or Monday.  # noqa: E501

        :param start_day_of_week: The start_day_of_week of this ProfileJsonBody.  # noqa: E501
        :type: str
        """

        self._start_day_of_week = start_day_of_week

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(ProfileJsonBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProfileJsonBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
