"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class UserApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_badges(self, **kwargs):  # noqa: E501
        """Get Badges  # noqa: E501

        Retrieves the user's badges in the format requested. Response includes all badges for the user as seen on the Fitbit website badge locker (both activity and weight related.) The endpoint returns weight and distance badges based on the user's unit profile preference as on the website.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_badges(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_badges_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_badges_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_badges_with_http_info(self, **kwargs):  # noqa: E501
        """Get Badges  # noqa: E501

        Retrieves the user's badges in the format requested. Response includes all badges for the user as seen on the Fitbit website badge locker (both activity and weight related.) The endpoint returns weight and distance badges based on the user's unit profile preference as on the website.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_badges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_badges" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/badges.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_profile(self, **kwargs):  # noqa: E501
        """Get Profile  # noqa: E501

        Returns a user's profile. The authenticated owner receives all values. However, the authenticated user's access to other users' data is subject to those users' privacy settings. Numerical values are returned in the unit system specified in the Accept-Language header.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_profile(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_profile_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_profile_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_profile_with_http_info(self, **kwargs):  # noqa: E501
        """Get Profile  # noqa: E501

        Returns a user's profile. The authenticated owner receives all values. However, the authenticated user's access to other users' data is subject to those users' privacy settings. Numerical values are returned in the unit system specified in the Accept-Language header.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_profile_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_profile" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/profile.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_profile(self, **kwargs):  # noqa: E501
        """Update Profile  # noqa: E501

        Updates a user's profile using a form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_profile(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gender:
        :param date birthday:
        :param str height:
        :param str about_me:
        :param str fullname:
        :param str country:
        :param str state:
        :param str city:
        :param str stride_length_walking:
        :param str stride_length_running:
        :param str weight_unit:
        :param str height_unit:
        :param str water_unit:
        :param str glucose_unit:
        :param str timezone:
        :param str foods_locale:
        :param str locale:
        :param str locale_lang:
        :param str locale_country:
        :param str start_day_of_week:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_profile_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.update_profile_with_http_info(**kwargs)  # noqa: E501
            return data

    def update_profile_with_http_info(self, **kwargs):  # noqa: E501
        """Update Profile  # noqa: E501

        Updates a user's profile using a form.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_profile_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gender:
        :param date birthday:
        :param str height:
        :param str about_me:
        :param str fullname:
        :param str country:
        :param str state:
        :param str city:
        :param str stride_length_walking:
        :param str stride_length_running:
        :param str weight_unit:
        :param str height_unit:
        :param str water_unit:
        :param str glucose_unit:
        :param str timezone:
        :param str foods_locale:
        :param str locale:
        :param str locale_lang:
        :param str locale_country:
        :param str start_day_of_week:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "gender",
            "birthday",
            "height",
            "about_me",
            "fullname",
            "country",
            "state",
            "city",
            "stride_length_walking",
            "stride_length_running",
            "weight_unit",
            "height_unit",
            "water_unit",
            "glucose_unit",
            "timezone",
            "foods_locale",
            "locale",
            "locale_lang",
            "locale_country",
            "start_day_of_week",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_profile" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "gender" in params:
            form_params.append(("gender", params["gender"]))  # noqa: E501
        if "birthday" in params:
            form_params.append(("birthday", params["birthday"]))  # noqa: E501
        if "height" in params:
            form_params.append(("height", params["height"]))  # noqa: E501
        if "about_me" in params:
            form_params.append(("aboutMe", params["about_me"]))  # noqa: E501
        if "fullname" in params:
            form_params.append(("fullname", params["fullname"]))  # noqa: E501
        if "country" in params:
            form_params.append(("country", params["country"]))  # noqa: E501
        if "state" in params:
            form_params.append(("state", params["state"]))  # noqa: E501
        if "city" in params:
            form_params.append(("city", params["city"]))  # noqa: E501
        if "stride_length_walking" in params:
            form_params.append(
                ("strideLengthWalking", params["stride_length_walking"])
            )  # noqa: E501
        if "stride_length_running" in params:
            form_params.append(
                ("strideLengthRunning", params["stride_length_running"])
            )  # noqa: E501
        if "weight_unit" in params:
            form_params.append(("weightUnit", params["weight_unit"]))  # noqa: E501
        if "height_unit" in params:
            form_params.append(("heightUnit", params["height_unit"]))  # noqa: E501
        if "water_unit" in params:
            form_params.append(("waterUnit", params["water_unit"]))  # noqa: E501
        if "glucose_unit" in params:
            form_params.append(("glucoseUnit", params["glucose_unit"]))  # noqa: E501
        if "timezone" in params:
            form_params.append(("timezone", params["timezone"]))  # noqa: E501
        if "foods_locale" in params:
            form_params.append(("foodsLocale", params["foods_locale"]))  # noqa: E501
        if "locale" in params:
            form_params.append(("locale", params["locale"]))  # noqa: E501
        if "locale_lang" in params:
            form_params.append(("localeLang", params["locale_lang"]))  # noqa: E501
        if "locale_country" in params:
            form_params.append(
                ("localeCountry", params["locale_country"])
            )  # noqa: E501
        if "start_day_of_week" in params:
            form_params.append(
                ("startDayOfWeek", params["start_day_of_week"])
            )  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/profile.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
