"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class SubscriptionsApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_subscriptions(
        self, collection_path, subscription_id, **kwargs
    ):  # noqa: E501
        """Add a Subscription  # noqa: E501

        Adds a subscription in your application so that users can get notifications and return a response in the format requested. The subscription-id value provides a way to associate an update with a particular user stream in your application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_subscriptions(collection_path, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_path: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :param str subscription_id: This is the unique ID of the subscription created by the API client application. Each ID must be unique across the entire set of subscribers and collections. The Fitbit servers will pass this ID back along with any notifications about the user indicated by the user parameter in the URL path. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_subscriptions_with_http_info(
                collection_path, subscription_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_subscriptions_with_http_info(
                collection_path, subscription_id, **kwargs
            )  # noqa: E501
            return data

    def add_subscriptions_with_http_info(
        self, collection_path, subscription_id, **kwargs
    ):  # noqa: E501
        """Add a Subscription  # noqa: E501

        Adds a subscription in your application so that users can get notifications and return a response in the format requested. The subscription-id value provides a way to associate an update with a particular user stream in your application.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_subscriptions_with_http_info(collection_path, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_path: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :param str subscription_id: This is the unique ID of the subscription created by the API client application. Each ID must be unique across the entire set of subscribers and collections. The Fitbit servers will pass this ID back along with any notifications about the user indicated by the user parameter in the URL path. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["collection_path", "subscription_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_subscriptions" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'collection_path' is set
        if "collection_path" not in params or params["collection_path"] is None:
            raise ValueError(
                "Missing the required parameter `collection_path` when calling `add_subscriptions`"
            )  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if "subscription_id" not in params or params["subscription_id"] is None:
            raise ValueError(
                "Missing the required parameter `subscription_id` when calling `add_subscriptions`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "collection_path" in params:
            path_params["collection-path"] = params["collection_path"]  # noqa: E501
        if "subscription_id" in params:
            path_params["subscription-id"] = params["subscription_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/{collection-path}/apiSubscriptions/{subscription-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_subscriptions(
        self, collection_path, subscription_id, **kwargs
    ):  # noqa: E501
        """Delete a Subscription  # noqa: E501

        Deletes a subscription for a user..  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subscriptions(collection_path, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_path: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :param str subscription_id: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_subscriptions_with_http_info(
                collection_path, subscription_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_subscriptions_with_http_info(
                collection_path, subscription_id, **kwargs
            )  # noqa: E501
            return data

    def delete_subscriptions_with_http_info(
        self, collection_path, subscription_id, **kwargs
    ):  # noqa: E501
        """Delete a Subscription  # noqa: E501

        Deletes a subscription for a user..  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subscriptions_with_http_info(collection_path, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_path: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :param str subscription_id: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["collection_path", "subscription_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subscriptions" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'collection_path' is set
        if "collection_path" not in params or params["collection_path"] is None:
            raise ValueError(
                "Missing the required parameter `collection_path` when calling `delete_subscriptions`"
            )  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if "subscription_id" not in params or params["subscription_id"] is None:
            raise ValueError(
                "Missing the required parameter `subscription_id` when calling `delete_subscriptions`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "collection_path" in params:
            path_params["collection-path"] = params["collection_path"]  # noqa: E501
        if "subscription_id" in params:
            path_params["subscription-id"] = params["subscription_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/{collection-path}/apiSubscriptions/{subscription-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_subscriptions_list(self, collection_path, **kwargs):  # noqa: E501
        """Get a List of Subscriptions  # noqa: E501

        Retreives a list of a user's subscriptions for your application in the format requested. You can either fetch subscriptions for a specific collection or the entire list of subscriptions for the user. For best practice, make sure that your application maintains this list on your side and use this endpoint only to periodically ensure data consistency.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscriptions_list(collection_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_path: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_subscriptions_list_with_http_info(
                collection_path, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_subscriptions_list_with_http_info(
                collection_path, **kwargs
            )  # noqa: E501
            return data

    def get_subscriptions_list_with_http_info(
        self, collection_path, **kwargs
    ):  # noqa: E501
        """Get a List of Subscriptions  # noqa: E501

        Retreives a list of a user's subscriptions for your application in the format requested. You can either fetch subscriptions for a specific collection or the entire list of subscriptions for the user. For best practice, make sure that your application maintains this list on your side and use this endpoint only to periodically ensure data consistency.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subscriptions_list_with_http_info(collection_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_path: This is the resource of the collection to receive notifications from (foods, activities, sleep, or body). If not present, subscription will be created for all collections. If you have both all and specific collection subscriptions, you will get duplicate notifications on that collections' updates. Each subscriber can have only one subscription for a specific user's collection. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["collection_path"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subscriptions_list" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'collection_path' is set
        if "collection_path" not in params or params["collection_path"] is None:
            raise ValueError(
                "Missing the required parameter `collection_path` when calling `get_subscriptions_list`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "collection_path" in params:
            path_params["collection-path"] = params["collection_path"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/{collection-path}/apiSubscriptions.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
