"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class HeartRateIntradayTimeSeriesApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_heart_by_date_intraday(self, _date, detail_level, **kwargs):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_intraday(_date, detail_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_heart_by_date_intraday_with_http_info(
                _date, detail_level, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_heart_by_date_intraday_with_http_info(
                _date, detail_level, **kwargs
            )  # noqa: E501
            return data

    def get_heart_by_date_intraday_with_http_info(
        self, _date, detail_level, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_intraday_with_http_info(_date, detail_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date", "detail_level"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_heart_by_date_intraday" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_heart_by_date_intraday`"
            )  # noqa: E501
        # verify the required parameter 'detail_level' is set
        if "detail_level" not in params or params["detail_level"] is None:
            raise ValueError(
                "Missing the required parameter `detail_level` when calling `get_heart_by_date_intraday`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501
        if "detail_level" in params:
            path_params["detail-level"] = params["detail_level"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/heart/date/{date}/1d/{detail-level}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_heart_by_date_range_intraday(
        self, _date, end_date, detail_level, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_range_intraday(_date, end_date, detail_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param date end_date: The end date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_heart_by_date_range_intraday_with_http_info(
                _date, end_date, detail_level, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_heart_by_date_range_intraday_with_http_info(
                _date, end_date, detail_level, **kwargs
            )  # noqa: E501
            return data

    def get_heart_by_date_range_intraday_with_http_info(
        self, _date, end_date, detail_level, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_range_intraday_with_http_info(_date, end_date, detail_level, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param date end_date: The end date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date", "end_date", "detail_level"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_heart_by_date_range_intraday" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_heart_by_date_range_intraday`"
            )  # noqa: E501
        # verify the required parameter 'end_date' is set
        if "end_date" not in params or params["end_date"] is None:
            raise ValueError(
                "Missing the required parameter `end_date` when calling `get_heart_by_date_range_intraday`"
            )  # noqa: E501
        # verify the required parameter 'detail_level' is set
        if "detail_level" not in params or params["detail_level"] is None:
            raise ValueError(
                "Missing the required parameter `detail_level` when calling `get_heart_by_date_range_intraday`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501
        if "end_date" in params:
            path_params["end-date"] = params["end_date"]  # noqa: E501
        if "detail_level" in params:
            path_params["detail-level"] = params["detail_level"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/heart/date/{date}/{end-date}/{detail-level}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_heart_by_date_range_timestamp_intraday(
        self, _date, end_date, detail_level, start_time, end_time, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_range_timestamp_intraday(_date, end_date, detail_level, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param date end_date: The end date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :param str start_time: The start of the period in the format of HH:mm. (required)
        :param str end_time: The end time of the period in the format of HH:mm. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_heart_by_date_range_timestamp_intraday_with_http_info(
                _date, end_date, detail_level, start_time, end_time, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_heart_by_date_range_timestamp_intraday_with_http_info(
                _date, end_date, detail_level, start_time, end_time, **kwargs
            )  # noqa: E501
            return data

    def get_heart_by_date_range_timestamp_intraday_with_http_info(
        self, _date, end_date, detail_level, start_time, end_time, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_range_timestamp_intraday_with_http_info(_date, end_date, detail_level, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param date end_date: The end date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :param str start_time: The start of the period in the format of HH:mm. (required)
        :param str end_time: The end time of the period in the format of HH:mm. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "_date",
            "end_date",
            "detail_level",
            "start_time",
            "end_time",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_heart_by_date_range_timestamp_intraday" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_heart_by_date_range_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'end_date' is set
        if "end_date" not in params or params["end_date"] is None:
            raise ValueError(
                "Missing the required parameter `end_date` when calling `get_heart_by_date_range_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'detail_level' is set
        if "detail_level" not in params or params["detail_level"] is None:
            raise ValueError(
                "Missing the required parameter `detail_level` when calling `get_heart_by_date_range_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'start_time' is set
        if "start_time" not in params or params["start_time"] is None:
            raise ValueError(
                "Missing the required parameter `start_time` when calling `get_heart_by_date_range_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'end_time' is set
        if "end_time" not in params or params["end_time"] is None:
            raise ValueError(
                "Missing the required parameter `end_time` when calling `get_heart_by_date_range_timestamp_intraday`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501
        if "end_date" in params:
            path_params["end-date"] = params["end_date"]  # noqa: E501
        if "detail_level" in params:
            path_params["detail-level"] = params["detail_level"]  # noqa: E501
        if "start_time" in params:
            path_params["start-time"] = params["start_time"]  # noqa: E501
        if "end_time" in params:
            path_params["end-time"] = params["end_time"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/heart/date/{date}/{end-date}/{detail-level}/time/{start-time}/{end-time}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_heart_by_date_timestamp_intraday(
        self, _date, detail_level, start_time, end_time, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_timestamp_intraday(_date, detail_level, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :param str start_time: The start of the period in the format of HH:mm. (required)
        :param str end_time: The end time of the period in the format of HH:mm. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_heart_by_date_timestamp_intraday_with_http_info(
                _date, detail_level, start_time, end_time, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_heart_by_date_timestamp_intraday_with_http_info(
                _date, detail_level, start_time, end_time, **kwargs
            )  # noqa: E501
            return data

    def get_heart_by_date_timestamp_intraday_with_http_info(
        self, _date, detail_level, start_time, end_time, **kwargs
    ):  # noqa: E501
        """Get Heart Rate Intraday Time Series  # noqa: E501

        Returns the intraday time series for a given resource in the format requested. If your application has the appropriate access, your calls to a time series endpoint for a specific day (by using start and end dates on the same day or a period of 1d), the response will include extended intraday values with a one-minute detail level for that day. Unlike other time series calls that allow fetching data of other users, intraday data is available only for and to the authorized user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heart_by_date_timestamp_intraday_with_http_info(_date, detail_level, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format of yyyy-MM-dd or today. (required)
        :param str detail_level: The number of data points to include either 1sec or 1min. (required)
        :param str start_time: The start of the period in the format of HH:mm. (required)
        :param str end_time: The end time of the period in the format of HH:mm. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date", "detail_level", "start_time", "end_time"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_heart_by_date_timestamp_intraday" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_heart_by_date_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'detail_level' is set
        if "detail_level" not in params or params["detail_level"] is None:
            raise ValueError(
                "Missing the required parameter `detail_level` when calling `get_heart_by_date_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'start_time' is set
        if "start_time" not in params or params["start_time"] is None:
            raise ValueError(
                "Missing the required parameter `start_time` when calling `get_heart_by_date_timestamp_intraday`"
            )  # noqa: E501
        # verify the required parameter 'end_time' is set
        if "end_time" not in params or params["end_time"] is None:
            raise ValueError(
                "Missing the required parameter `end_time` when calling `get_heart_by_date_timestamp_intraday`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501
        if "detail_level" in params:
            path_params["detail-level"] = params["detail_level"]  # noqa: E501
        if "start_time" in params:
            path_params["start-time"] = params["start_time"]  # noqa: E501
        if "end_time" in params:
            path_params["end-time"] = params["end_time"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/heart/date/{date}/1d/{detail-level}/time/{start-time}/{end-time}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
