"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class FoodAndWaterApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_favorite_food(self, food_id, **kwargs):  # noqa: E501
        """Add Favorite Food  # noqa: E501

        Updates a user's daily activity goals and returns a response using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_favorite_food(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be added to user's favorites. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_favorite_food_with_http_info(
                food_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_favorite_food_with_http_info(
                food_id, **kwargs
            )  # noqa: E501
            return data

    def add_favorite_food_with_http_info(self, food_id, **kwargs):  # noqa: E501
        """Add Favorite Food  # noqa: E501

        Updates a user's daily activity goals and returns a response using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_favorite_food_with_http_info(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be added to user's favorites. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["food_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_favorite_food" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `add_favorite_food`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "food_id" in params:
            path_params["food-id"] = params["food_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/favorite/{food-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_foods(
        self,
        name,
        default_food_measurement_unit_id,
        default_serving_size,
        calories,
        **kwargs
    ):  # noqa: E501
        """Create Food  # noqa: E501

        Creates a new private food for a user and returns a response in the format requested. The created food is found via the Search Foods call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_foods(name, default_food_measurement_unit_id, default_serving_size, calories, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The food name. (required)
        :param str default_food_measurement_unit_id: The ID of the default measurement unit. Full list of units can be retrieved via the Get Food Units endpoint. (required)
        :param str default_serving_size: The size of the default serving. Nutrition values should be provided for this serving size. (required)
        :param str calories: The calories in the default serving size. (required)
        :param str form_type: Form type; LIQUID or DRY.
        :param str description: The description of the food.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_foods_with_http_info(
                name,
                default_food_measurement_unit_id,
                default_serving_size,
                calories,
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_foods_with_http_info(
                name,
                default_food_measurement_unit_id,
                default_serving_size,
                calories,
                **kwargs
            )  # noqa: E501
            return data

    def add_foods_with_http_info(
        self,
        name,
        default_food_measurement_unit_id,
        default_serving_size,
        calories,
        **kwargs
    ):  # noqa: E501
        """Create Food  # noqa: E501

        Creates a new private food for a user and returns a response in the format requested. The created food is found via the Search Foods call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_foods_with_http_info(name, default_food_measurement_unit_id, default_serving_size, calories, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The food name. (required)
        :param str default_food_measurement_unit_id: The ID of the default measurement unit. Full list of units can be retrieved via the Get Food Units endpoint. (required)
        :param str default_serving_size: The size of the default serving. Nutrition values should be provided for this serving size. (required)
        :param str calories: The calories in the default serving size. (required)
        :param str form_type: Form type; LIQUID or DRY.
        :param str description: The description of the food.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "name",
            "default_food_measurement_unit_id",
            "default_serving_size",
            "calories",
            "form_type",
            "description",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_foods" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'name' is set
        if "name" not in params or params["name"] is None:
            raise ValueError(
                "Missing the required parameter `name` when calling `add_foods`"
            )  # noqa: E501
        # verify the required parameter 'default_food_measurement_unit_id' is set
        if (
            "default_food_measurement_unit_id" not in params
            or params["default_food_measurement_unit_id"] is None
        ):
            raise ValueError(
                "Missing the required parameter `default_food_measurement_unit_id` when calling `add_foods`"
            )  # noqa: E501
        # verify the required parameter 'default_serving_size' is set
        if (
            "default_serving_size" not in params
            or params["default_serving_size"] is None
        ):
            raise ValueError(
                "Missing the required parameter `default_serving_size` when calling `add_foods`"
            )  # noqa: E501
        # verify the required parameter 'calories' is set
        if "calories" not in params or params["calories"] is None:
            raise ValueError(
                "Missing the required parameter `calories` when calling `add_foods`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "name" in params:
            query_params.append(("name", params["name"]))  # noqa: E501
        if "default_food_measurement_unit_id" in params:
            query_params.append(
                (
                    "defaultFoodMeasurementUnitId",
                    params["default_food_measurement_unit_id"],
                )
            )  # noqa: E501
        if "default_serving_size" in params:
            query_params.append(
                ("defaultServingSize", params["default_serving_size"])
            )  # noqa: E501
        if "calories" in params:
            query_params.append(("calories", params["calories"]))  # noqa: E501
        if "form_type" in params:
            query_params.append(("formType", params["form_type"]))  # noqa: E501
        if "description" in params:
            query_params.append(("description", params["description"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_foods_log(
        self, food_id, meal_type_id, unit_id, amount, _date, **kwargs
    ):  # noqa: E501
        """Log Food  # noqa: E501

        Creates food log entries for users with or without foodId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_foods_log(food_id, meal_type_id, unit_id, amount, _date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be logged. Either foodId or foodName must be provided. (required)
        :param str meal_type_id: Meal types. 1=Breakfast; 2=Morning Snack; 3=Lunch; 4=Afternoon Snack; 5=Dinner; 7=Anytime. (required)
        :param str unit_id: The ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: The amount consumed in the format X.XX in the specified unitId. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param str food_name: Food entry name. Either foodId or foodName must be provided.
        :param bool favorite: The `true` value will add the food to the user's favorites after creating the log entry; while the `false` value will not. Valid only with foodId value.
        :param str brand_name: Brand name of food. Valid only with foodName parameters.
        :param int calories: Calories for this serving size. This is allowed with foodName parameter (default to zero); otherwise it is ignored.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_foods_log_with_http_info(
                food_id, meal_type_id, unit_id, amount, _date, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_foods_log_with_http_info(
                food_id, meal_type_id, unit_id, amount, _date, **kwargs
            )  # noqa: E501
            return data

    def add_foods_log_with_http_info(
        self, food_id, meal_type_id, unit_id, amount, _date, **kwargs
    ):  # noqa: E501
        """Log Food  # noqa: E501

        Creates food log entries for users with or without foodId value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_foods_log_with_http_info(food_id, meal_type_id, unit_id, amount, _date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be logged. Either foodId or foodName must be provided. (required)
        :param str meal_type_id: Meal types. 1=Breakfast; 2=Morning Snack; 3=Lunch; 4=Afternoon Snack; 5=Dinner; 7=Anytime. (required)
        :param str unit_id: The ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: The amount consumed in the format X.XX in the specified unitId. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param str food_name: Food entry name. Either foodId or foodName must be provided.
        :param bool favorite: The `true` value will add the food to the user's favorites after creating the log entry; while the `false` value will not. Valid only with foodId value.
        :param str brand_name: Brand name of food. Valid only with foodName parameters.
        :param int calories: Calories for this serving size. This is allowed with foodName parameter (default to zero); otherwise it is ignored.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "food_id",
            "meal_type_id",
            "unit_id",
            "amount",
            "_date",
            "food_name",
            "favorite",
            "brand_name",
            "calories",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_foods_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `add_foods_log`"
            )  # noqa: E501
        # verify the required parameter 'meal_type_id' is set
        if "meal_type_id" not in params or params["meal_type_id"] is None:
            raise ValueError(
                "Missing the required parameter `meal_type_id` when calling `add_foods_log`"
            )  # noqa: E501
        # verify the required parameter 'unit_id' is set
        if "unit_id" not in params or params["unit_id"] is None:
            raise ValueError(
                "Missing the required parameter `unit_id` when calling `add_foods_log`"
            )  # noqa: E501
        # verify the required parameter 'amount' is set
        if "amount" not in params or params["amount"] is None:
            raise ValueError(
                "Missing the required parameter `amount` when calling `add_foods_log`"
            )  # noqa: E501
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `add_foods_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "food_id" in params:
            query_params.append(("foodId", params["food_id"]))  # noqa: E501
        if "food_name" in params:
            query_params.append(("foodName", params["food_name"]))  # noqa: E501
        if "meal_type_id" in params:
            query_params.append(("mealTypeId", params["meal_type_id"]))  # noqa: E501
        if "unit_id" in params:
            query_params.append(("unitId", params["unit_id"]))  # noqa: E501
        if "amount" in params:
            query_params.append(("amount", params["amount"]))  # noqa: E501
        if "_date" in params:
            query_params.append(("date", params["_date"]))  # noqa: E501
        if "favorite" in params:
            query_params.append(("favorite", params["favorite"]))  # noqa: E501
        if "brand_name" in params:
            query_params.append(("brandName", params["brand_name"]))  # noqa: E501
        if "calories" in params:
            query_params.append(("calories", params["calories"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_meal(
        self, name, description, food_id, unit_id, amount, **kwargs
    ):  # noqa: E501
        """Create Meal  # noqa: E501

        Creates a meal with the given food contained in the post body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_meal(name, description, food_id, unit_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of the meal. (required)
        :param str description: Short description of the meal. (required)
        :param str food_id: ID of the food to be included in the meal. (required)
        :param str unit_id: ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: Amount consumed; in the format X.XX, in the specified unitId. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_meal_with_http_info(
                name, description, food_id, unit_id, amount, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_meal_with_http_info(
                name, description, food_id, unit_id, amount, **kwargs
            )  # noqa: E501
            return data

    def add_meal_with_http_info(
        self, name, description, food_id, unit_id, amount, **kwargs
    ):  # noqa: E501
        """Create Meal  # noqa: E501

        Creates a meal with the given food contained in the post body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_meal_with_http_info(name, description, food_id, unit_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Name of the meal. (required)
        :param str description: Short description of the meal. (required)
        :param str food_id: ID of the food to be included in the meal. (required)
        :param str unit_id: ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: Amount consumed; in the format X.XX, in the specified unitId. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "name",
            "description",
            "food_id",
            "unit_id",
            "amount",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_meal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'name' is set
        if "name" not in params or params["name"] is None:
            raise ValueError(
                "Missing the required parameter `name` when calling `add_meal`"
            )  # noqa: E501
        # verify the required parameter 'description' is set
        if "description" not in params or params["description"] is None:
            raise ValueError(
                "Missing the required parameter `description` when calling `add_meal`"
            )  # noqa: E501
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `add_meal`"
            )  # noqa: E501
        # verify the required parameter 'unit_id' is set
        if "unit_id" not in params or params["unit_id"] is None:
            raise ValueError(
                "Missing the required parameter `unit_id` when calling `add_meal`"
            )  # noqa: E501
        # verify the required parameter 'amount' is set
        if "amount" not in params or params["amount"] is None:
            raise ValueError(
                "Missing the required parameter `amount` when calling `add_meal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "name" in params:
            query_params.append(("name", params["name"]))  # noqa: E501
        if "description" in params:
            query_params.append(("Description", params["description"]))  # noqa: E501
        if "food_id" in params:
            query_params.append(("foodId", params["food_id"]))  # noqa: E501
        if "unit_id" in params:
            query_params.append(("unitId", params["unit_id"]))  # noqa: E501
        if "amount" in params:
            query_params.append(("amount", params["amount"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/meals.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_update_foods_goal(self, calories, **kwargs):  # noqa: E501
        """Update Food Goal  # noqa: E501

        Updates a user's daily calories consumption goal or food plan and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_update_foods_goal(calories, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int calories: Manual calorie consumption goal in either calories or intensity must be provided. (required)
        :param str intensity: Food plan intensity (MAINTENANCE, EASIER, MEDIUM, KINDAHARD, or HARDER). Either calories or intensity must be provided.
        :param str personalized: Food plan type; true or false.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_update_foods_goal_with_http_info(
                calories, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_update_foods_goal_with_http_info(
                calories, **kwargs
            )  # noqa: E501
            return data

    def add_update_foods_goal_with_http_info(self, calories, **kwargs):  # noqa: E501
        """Update Food Goal  # noqa: E501

        Updates a user's daily calories consumption goal or food plan and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_update_foods_goal_with_http_info(calories, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int calories: Manual calorie consumption goal in either calories or intensity must be provided. (required)
        :param str intensity: Food plan intensity (MAINTENANCE, EASIER, MEDIUM, KINDAHARD, or HARDER). Either calories or intensity must be provided.
        :param str personalized: Food plan type; true or false.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["calories", "intensity", "personalized"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_update_foods_goal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'calories' is set
        if "calories" not in params or params["calories"] is None:
            raise ValueError(
                "Missing the required parameter `calories` when calling `add_update_foods_goal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "calories" in params:
            query_params.append(("calories", params["calories"]))  # noqa: E501
        if "intensity" in params:
            query_params.append(("intensity", params["intensity"]))  # noqa: E501
        if "personalized" in params:
            query_params.append(("personalized", params["personalized"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/goal.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_update_water_goal(self, target, **kwargs):  # noqa: E501
        """Update Water Goal  # noqa: E501

        Updates a user's daily calories consumption goal or food plan and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_update_water_goal(target, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int target: The target water goal in the format X.X is set in unit based on locale. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_update_water_goal_with_http_info(
                target, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_update_water_goal_with_http_info(
                target, **kwargs
            )  # noqa: E501
            return data

    def add_update_water_goal_with_http_info(self, target, **kwargs):  # noqa: E501
        """Update Water Goal  # noqa: E501

        Updates a user's daily calories consumption goal or food plan and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_update_water_goal_with_http_info(target, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int target: The target water goal in the format X.X is set in unit based on locale. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["target"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_update_water_goal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'target' is set
        if "target" not in params or params["target"] is None:
            raise ValueError(
                "Missing the required parameter `target` when calling `add_update_water_goal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "target" in params:
            query_params.append(("target", params["target"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/water/goal.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_water_log(self, _date, amount, **kwargs):  # noqa: E501
        """Log Water  # noqa: E501

        Creates a log entry for water using units in the unit systems that corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_water_log(_date, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date of records to be returned in the format yyyy-MM-dd. (required)
        :param int amount: The amount consumption in the format X.XX and in the specified waterUnit or in the unit system that corresponds to the Accept-Language header provided. (required)
        :param str unit: Water measurement unit; `ml`, `fl oz`, or `cup`.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_water_log_with_http_info(
                _date, amount, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_water_log_with_http_info(
                _date, amount, **kwargs
            )  # noqa: E501
            return data

    def add_water_log_with_http_info(self, _date, amount, **kwargs):  # noqa: E501
        """Log Water  # noqa: E501

        Creates a log entry for water using units in the unit systems that corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_water_log_with_http_info(_date, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date of records to be returned in the format yyyy-MM-dd. (required)
        :param int amount: The amount consumption in the format X.XX and in the specified waterUnit or in the unit system that corresponds to the Accept-Language header provided. (required)
        :param str unit: Water measurement unit; `ml`, `fl oz`, or `cup`.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date", "amount", "unit"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_water_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `add_water_log`"
            )  # noqa: E501
        # verify the required parameter 'amount' is set
        if "amount" not in params or params["amount"] is None:
            raise ValueError(
                "Missing the required parameter `amount` when calling `add_water_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "_date" in params:
            query_params.append(("date", params["_date"]))  # noqa: E501
        if "amount" in params:
            query_params.append(("amount", params["amount"]))  # noqa: E501
        if "unit" in params:
            query_params.append(("unit", params["unit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/water.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_favorite_food(self, food_id, **kwargs):  # noqa: E501
        """Delete Favorite Food  # noqa: E501

        Deletes a food with the given ID to the user's list of favorite foods.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_favorite_food(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be deleted from user's favorites. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_favorite_food_with_http_info(
                food_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_favorite_food_with_http_info(
                food_id, **kwargs
            )  # noqa: E501
            return data

    def delete_favorite_food_with_http_info(self, food_id, **kwargs):  # noqa: E501
        """Delete Favorite Food  # noqa: E501

        Deletes a food with the given ID to the user's list of favorite foods.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_favorite_food_with_http_info(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be deleted from user's favorites. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["food_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_favorite_food" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `delete_favorite_food`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "food_id" in params:
            path_params["food-id"] = params["food_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/favorite/{food-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_foods(self, food_id, **kwargs):  # noqa: E501
        """Delete Custom Food  # noqa: E501

        Deletes custom food for a user and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_foods(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_foods_with_http_info(food_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_foods_with_http_info(food_id, **kwargs)  # noqa: E501
            return data

    def delete_foods_with_http_info(self, food_id, **kwargs):  # noqa: E501
        """Delete Custom Food  # noqa: E501

        Deletes custom food for a user and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_foods_with_http_info(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["food_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_foods" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `delete_foods`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "food_id" in params:
            path_params["food-id"] = params["food_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/{food-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_foods_log(self, food_log_id, **kwargs):  # noqa: E501
        """Delete Food Log  # noqa: E501

        Deletes a user's food log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_foods_log(food_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_log_id: The ID of the food log entry to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_foods_log_with_http_info(
                food_log_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_foods_log_with_http_info(
                food_log_id, **kwargs
            )  # noqa: E501
            return data

    def delete_foods_log_with_http_info(self, food_log_id, **kwargs):  # noqa: E501
        """Delete Food Log  # noqa: E501

        Deletes a user's food log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_foods_log_with_http_info(food_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_log_id: The ID of the food log entry to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["food_log_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_foods_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_log_id' is set
        if "food_log_id" not in params or params["food_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_log_id` when calling `delete_foods_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "food_log_id" in params:
            path_params["food-log-id"] = params["food_log_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/{food-log-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_meal(self, meal_id, **kwargs):  # noqa: E501
        """Delete Meal  # noqa: E501

        Deletes a user's meal with the given meal id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_meal(meal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str meal_id: Id of the meal to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_meal_with_http_info(meal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_meal_with_http_info(meal_id, **kwargs)  # noqa: E501
            return data

    def delete_meal_with_http_info(self, meal_id, **kwargs):  # noqa: E501
        """Delete Meal  # noqa: E501

        Deletes a user's meal with the given meal id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_meal_with_http_info(meal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str meal_id: Id of the meal to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["meal_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_meal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'meal_id' is set
        if "meal_id" not in params or params["meal_id"] is None:
            raise ValueError(
                "Missing the required parameter `meal_id` when calling `delete_meal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "meal_id" in params:
            path_params["meal-id"] = params["meal_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/meals/{meal-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_water_log(self, water_log_id, **kwargs):  # noqa: E501
        """Delete Water Log  # noqa: E501

        Deletes a user's water log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_water_log(water_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str water_log_id: The ID of the waterUnit log entry to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_water_log_with_http_info(
                water_log_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_water_log_with_http_info(
                water_log_id, **kwargs
            )  # noqa: E501
            return data

    def delete_water_log_with_http_info(self, water_log_id, **kwargs):  # noqa: E501
        """Delete Water Log  # noqa: E501

        Deletes a user's water log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_water_log_with_http_info(water_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str water_log_id: The ID of the waterUnit log entry to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["water_log_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_water_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'water_log_id' is set
        if "water_log_id" not in params or params["water_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `water_log_id` when calling `delete_water_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "water_log_id" in params:
            path_params["water-log-id"] = params["water_log_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/water/{water-log-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def edit_foods_log(
        self, food_log_id, meal_type_id, unit_id, amount, **kwargs
    ):  # noqa: E501
        """Edit Food Log  # noqa: E501

        The Edit Food Log endpoint changes the quantity or calories consumed for a user's food log entry with the given Food Log ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_foods_log(food_log_id, meal_type_id, unit_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_log_id: The ID of the food log entry to be edited. (required)
        :param str meal_type_id: Meal types. 1=Breakfast; 2=Morning Snack; 3=Lunch; 4=Afternoon Snack; 5=Dinner; 7=Anytime. (required)
        :param str unit_id: The ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: The amount consumed in the format X.XX in the specified unitId. (required)
        :param int calories: Calories for this serving size. This is allowed with foodName parameter (default to zero); otherwise it is ignored.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.edit_foods_log_with_http_info(
                food_log_id, meal_type_id, unit_id, amount, **kwargs
            )  # noqa: E501
        else:
            (data) = self.edit_foods_log_with_http_info(
                food_log_id, meal_type_id, unit_id, amount, **kwargs
            )  # noqa: E501
            return data

    def edit_foods_log_with_http_info(
        self, food_log_id, meal_type_id, unit_id, amount, **kwargs
    ):  # noqa: E501
        """Edit Food Log  # noqa: E501

        The Edit Food Log endpoint changes the quantity or calories consumed for a user's food log entry with the given Food Log ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_foods_log_with_http_info(food_log_id, meal_type_id, unit_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_log_id: The ID of the food log entry to be edited. (required)
        :param str meal_type_id: Meal types. 1=Breakfast; 2=Morning Snack; 3=Lunch; 4=Afternoon Snack; 5=Dinner; 7=Anytime. (required)
        :param str unit_id: The ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: The amount consumed in the format X.XX in the specified unitId. (required)
        :param int calories: Calories for this serving size. This is allowed with foodName parameter (default to zero); otherwise it is ignored.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "food_log_id",
            "meal_type_id",
            "unit_id",
            "amount",
            "calories",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_foods_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_log_id' is set
        if "food_log_id" not in params or params["food_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_log_id` when calling `edit_foods_log`"
            )  # noqa: E501
        # verify the required parameter 'meal_type_id' is set
        if "meal_type_id" not in params or params["meal_type_id"] is None:
            raise ValueError(
                "Missing the required parameter `meal_type_id` when calling `edit_foods_log`"
            )  # noqa: E501
        # verify the required parameter 'unit_id' is set
        if "unit_id" not in params or params["unit_id"] is None:
            raise ValueError(
                "Missing the required parameter `unit_id` when calling `edit_foods_log`"
            )  # noqa: E501
        # verify the required parameter 'amount' is set
        if "amount" not in params or params["amount"] is None:
            raise ValueError(
                "Missing the required parameter `amount` when calling `edit_foods_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "food_log_id" in params:
            path_params["food-log-id"] = params["food_log_id"]  # noqa: E501

        query_params = []
        if "meal_type_id" in params:
            query_params.append(("mealTypeId", params["meal_type_id"]))  # noqa: E501
        if "unit_id" in params:
            query_params.append(("unitId", params["unit_id"]))  # noqa: E501
        if "amount" in params:
            query_params.append(("amount", params["amount"]))  # noqa: E501
        if "calories" in params:
            query_params.append(("calories", params["calories"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/{food-log-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_favorite_foods(self, **kwargs):  # noqa: E501
        """Get Favorite Foods  # noqa: E501

        Returns a list of a user's favorite foods in the format requested. A favorite food in the list provides a quick way to log the food via the Log Food endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_favorite_foods(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_favorite_foods_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_favorite_foods_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_favorite_foods_with_http_info(self, **kwargs):  # noqa: E501
        """Get Favorite Foods  # noqa: E501

        Returns a list of a user's favorite foods in the format requested. A favorite food in the list provides a quick way to log the food via the Log Food endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_favorite_foods_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_favorite_foods" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/favorite.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_foods_by_date(self, _date, **kwargs):  # noqa: E501
        """Get Food Logs  # noqa: E501

        Retreives a summary and list of a user's food log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_by_date(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date of records to be returned. In the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_foods_by_date_with_http_info(_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_foods_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
            return data

    def get_foods_by_date_with_http_info(self, _date, **kwargs):  # noqa: E501
        """Get Food Logs  # noqa: E501

        Retreives a summary and list of a user's food log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_by_date_with_http_info(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date of records to be returned. In the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_foods_by_date" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_foods_by_date`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/date/{date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_foods_goal(self, **kwargs):  # noqa: E501
        """Get Food Goals  # noqa: E501

        Returns a user's current daily calorie consumption goal and/or foodPlan value in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_goal(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_foods_goal_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_foods_goal_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_foods_goal_with_http_info(self, **kwargs):  # noqa: E501
        """Get Food Goals  # noqa: E501

        Returns a user's current daily calorie consumption goal and/or foodPlan value in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_goal_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_foods_goal" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/goal.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_foods_info(self, food_id, **kwargs):  # noqa: E501
        """Get Food  # noqa: E501

        Returns the details of a specific food in the Fitbit food databases or a private food that an authorized user has entered in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_info(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_foods_info_with_http_info(food_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_foods_info_with_http_info(food_id, **kwargs)  # noqa: E501
            return data

    def get_foods_info_with_http_info(self, food_id, **kwargs):  # noqa: E501
        """Get Food  # noqa: E501

        Returns the details of a specific food in the Fitbit food databases or a private food that an authorized user has entered in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_info_with_http_info(food_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str food_id: The ID of the food. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["food_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_foods_info" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `get_foods_info`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "food_id" in params:
            path_params["food-id"] = params["food_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/foods/{food-id}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_foods_list(self, query, **kwargs):  # noqa: E501
        """Search Foods  # noqa: E501

        Returns a list of public foods from the Fitbit food database and private food the user created in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_list(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: The URL-encoded search query. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_foods_list_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_foods_list_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def get_foods_list_with_http_info(self, query, **kwargs):  # noqa: E501
        """Search Foods  # noqa: E501

        Returns a list of public foods from the Fitbit food database and private food the user created in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_list_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: The URL-encoded search query. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["query"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_foods_list" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'query' is set
        if "query" not in params or params["query"] is None:
            raise ValueError(
                "Missing the required parameter `query` when calling `get_foods_list`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "query" in params:
            query_params.append(("query", params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/foods/search.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_foods_locales(self, **kwargs):  # noqa: E501
        """Get Food Locales  # noqa: E501

        Returns the food locales that the user may choose to search, log, and create food in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_locales(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_foods_locales_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_foods_locales_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_foods_locales_with_http_info(self, **kwargs):  # noqa: E501
        """Get Food Locales  # noqa: E501

        Returns the food locales that the user may choose to search, log, and create food in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_locales_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_foods_locales" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/foods/locales.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_foods_units(self, **kwargs):  # noqa: E501
        """Get Food Units  # noqa: E501

        Returns a list of all valid Fitbit food units in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_units(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_foods_units_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_foods_units_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_foods_units_with_http_info(self, **kwargs):  # noqa: E501
        """Get Food Units  # noqa: E501

        Returns a list of all valid Fitbit food units in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_foods_units_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_foods_units" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/foods/units.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_frequent_foods(self, **kwargs):  # noqa: E501
        """Get Frequent Foods  # noqa: E501

        Returns a list of a user's frequent foods in the format requested. A frequent food in the list provides a quick way to log the food via the Log Food endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_frequent_foods(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_frequent_foods_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_frequent_foods_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_frequent_foods_with_http_info(self, **kwargs):  # noqa: E501
        """Get Frequent Foods  # noqa: E501

        Returns a list of a user's frequent foods in the format requested. A frequent food in the list provides a quick way to log the food via the Log Food endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_frequent_foods_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_frequent_foods" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/frequent.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_meals(self, **kwargs):  # noqa: E501
        """Get Meals  # noqa: E501

        Returns a list of meals created by user in the user's food log in the format requested. User creates and manages meals on the Food Log tab on the website.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meals(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_meals_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_meals_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_meals_with_http_info(self, **kwargs):  # noqa: E501
        """Get Meals  # noqa: E501

        Returns a list of meals created by user in the user's food log in the format requested. User creates and manages meals on the Food Log tab on the website.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meals_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_meals" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/meals.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_recent_foods(self, **kwargs):  # noqa: E501
        """Get Recent Foods  # noqa: E501

        Returns a list of a user's frequent foods in the format requested. A frequent food in the list provides a quick way to log the food via the Log Food endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recent_foods(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_recent_foods_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_recent_foods_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_recent_foods_with_http_info(self, **kwargs):  # noqa: E501
        """Get Recent Foods  # noqa: E501

        Returns a list of a user's frequent foods in the format requested. A frequent food in the list provides a quick way to log the food via the Log Food endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recent_foods_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recent_foods" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/recent.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_water_by_date(self, _date, **kwargs):  # noqa: E501
        """Get Water Logs  # noqa: E501

        Retreives a summary and list of a user's water log entries for a given day in the requested using units in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_water_by_date(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date of records to be returned. In the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_water_by_date_with_http_info(_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_water_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
            return data

    def get_water_by_date_with_http_info(self, _date, **kwargs):  # noqa: E501
        """Get Water Logs  # noqa: E501

        Retreives a summary and list of a user's water log entries for a given day in the requested using units in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_water_by_date_with_http_info(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date of records to be returned. In the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_water_by_date" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_water_by_date`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/water/date/{date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_water_goal(self, **kwargs):  # noqa: E501
        """Get Water Goal  # noqa: E501

        Retreives a summary and list of a user's water goal entries for a given day in the requested using units in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_water_goal(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_water_goal_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_water_goal_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_water_goal_with_http_info(self, **kwargs):  # noqa: E501
        """Get Water Goal  # noqa: E501

        Retreives a summary and list of a user's water goal entries for a given day in the requested using units in the unit system that corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_water_goal_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_water_goal" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/water/goal.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_meal(
        self, meal_id, name, description, food_id, unit_id, amount, **kwargs
    ):  # noqa: E501
        """Edit Meal  # noqa: E501

        Replaces an existing meal with the contents of the request. The response contains the updated meal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_meal(meal_id, name, description, food_id, unit_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str meal_id: Id of the meal to edit. (required)
        :param str name: Name of the meal. (required)
        :param str description: Short description of the meal. (required)
        :param str food_id: ID of the food to be included in the meal. (required)
        :param str unit_id: ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: Amount consumed; in the format X.XX, in the specified unitId. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_meal_with_http_info(
                meal_id, name, description, food_id, unit_id, amount, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_meal_with_http_info(
                meal_id, name, description, food_id, unit_id, amount, **kwargs
            )  # noqa: E501
            return data

    def update_meal_with_http_info(
        self, meal_id, name, description, food_id, unit_id, amount, **kwargs
    ):  # noqa: E501
        """Edit Meal  # noqa: E501

        Replaces an existing meal with the contents of the request. The response contains the updated meal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_meal_with_http_info(meal_id, name, description, food_id, unit_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str meal_id: Id of the meal to edit. (required)
        :param str name: Name of the meal. (required)
        :param str description: Short description of the meal. (required)
        :param str food_id: ID of the food to be included in the meal. (required)
        :param str unit_id: ID of units used. Typically retrieved via a previous call to Get Food Logs, Search Foods, or Get Food Units. (required)
        :param str amount: Amount consumed; in the format X.XX, in the specified unitId. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "meal_id",
            "name",
            "description",
            "food_id",
            "unit_id",
            "amount",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_meal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'meal_id' is set
        if "meal_id" not in params or params["meal_id"] is None:
            raise ValueError(
                "Missing the required parameter `meal_id` when calling `update_meal`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if "name" not in params or params["name"] is None:
            raise ValueError(
                "Missing the required parameter `name` when calling `update_meal`"
            )  # noqa: E501
        # verify the required parameter 'description' is set
        if "description" not in params or params["description"] is None:
            raise ValueError(
                "Missing the required parameter `description` when calling `update_meal`"
            )  # noqa: E501
        # verify the required parameter 'food_id' is set
        if "food_id" not in params or params["food_id"] is None:
            raise ValueError(
                "Missing the required parameter `food_id` when calling `update_meal`"
            )  # noqa: E501
        # verify the required parameter 'unit_id' is set
        if "unit_id" not in params or params["unit_id"] is None:
            raise ValueError(
                "Missing the required parameter `unit_id` when calling `update_meal`"
            )  # noqa: E501
        # verify the required parameter 'amount' is set
        if "amount" not in params or params["amount"] is None:
            raise ValueError(
                "Missing the required parameter `amount` when calling `update_meal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "meal_id" in params:
            path_params["meal-id"] = params["meal_id"]  # noqa: E501

        query_params = []
        if "name" in params:
            query_params.append(("name", params["name"]))  # noqa: E501
        if "description" in params:
            query_params.append(("Description", params["description"]))  # noqa: E501
        if "food_id" in params:
            query_params.append(("foodId", params["food_id"]))  # noqa: E501
        if "unit_id" in params:
            query_params.append(("unitId", params["unit_id"]))  # noqa: E501
        if "amount" in params:
            query_params.append(("amount", params["amount"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/meals/{meal-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_water_log(self, water_log_id, amount, **kwargs):  # noqa: E501
        """Update Water Log  # noqa: E501

        Updates a user's water log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_water_log(water_log_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str water_log_id: The ID of the waterUnit log entry to be deleted. (required)
        :param str amount: Amount consumed; in the format X.X and in the specified waterUnit or in the unit system that corresponds to the Accept-Language header provided. (required)
        :param str unit: Water measurement unit. 'ml', 'fl oz', or 'cup'.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_water_log_with_http_info(
                water_log_id, amount, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_water_log_with_http_info(
                water_log_id, amount, **kwargs
            )  # noqa: E501
            return data

    def update_water_log_with_http_info(
        self, water_log_id, amount, **kwargs
    ):  # noqa: E501
        """Update Water Log  # noqa: E501

        Updates a user's water log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_water_log_with_http_info(water_log_id, amount, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str water_log_id: The ID of the waterUnit log entry to be deleted. (required)
        :param str amount: Amount consumed; in the format X.X and in the specified waterUnit or in the unit system that corresponds to the Accept-Language header provided. (required)
        :param str unit: Water measurement unit. 'ml', 'fl oz', or 'cup'.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["water_log_id", "amount", "unit"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_water_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'water_log_id' is set
        if "water_log_id" not in params or params["water_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `water_log_id` when calling `update_water_log`"
            )  # noqa: E501
        # verify the required parameter 'amount' is set
        if "amount" not in params or params["amount"] is None:
            raise ValueError(
                "Missing the required parameter `amount` when calling `update_water_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "water_log_id" in params:
            path_params["water-log-id"] = params["water_log_id"]  # noqa: E501

        query_params = []
        if "amount" in params:
            query_params.append(("amount", params["amount"]))  # noqa: E501
        if "unit" in params:
            query_params.append(("unit", params["unit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/foods/log/water/{water-log-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
