"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class DevicesApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_alarms(
        self, tracker_id, time, enabled, recurring, week_days, **kwargs
    ):  # noqa: E501
        """Add Alarm  # noqa: E501

        Adds the alarm settings to a given ID for a given device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_alarms(tracker_id, time, enabled, recurring, week_days, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker for which data is returned. The tracker-id value is found via the Get Devices endpoint. (required)
        :param str time: Time of day that the alarm vibrates with a UTC timezone offset, e.g. 07:15-08:00. (required)
        :param bool enabled: true or false. If false, alarm does not vibrate until enabled is set to true. (required)
        :param str recurring: true or false. If false, the alarm is a single event. (required)
        :param str week_days: Comma separated list of days of the week on which the alarm vibrates, e.g. MONDAY, TUESDAY. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_alarms_with_http_info(
                tracker_id, time, enabled, recurring, week_days, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_alarms_with_http_info(
                tracker_id, time, enabled, recurring, week_days, **kwargs
            )  # noqa: E501
            return data

    def add_alarms_with_http_info(
        self, tracker_id, time, enabled, recurring, week_days, **kwargs
    ):  # noqa: E501
        """Add Alarm  # noqa: E501

        Adds the alarm settings to a given ID for a given device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_alarms_with_http_info(tracker_id, time, enabled, recurring, week_days, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker for which data is returned. The tracker-id value is found via the Get Devices endpoint. (required)
        :param str time: Time of day that the alarm vibrates with a UTC timezone offset, e.g. 07:15-08:00. (required)
        :param bool enabled: true or false. If false, alarm does not vibrate until enabled is set to true. (required)
        :param str recurring: true or false. If false, the alarm is a single event. (required)
        :param str week_days: Comma separated list of days of the week on which the alarm vibrates, e.g. MONDAY, TUESDAY. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "tracker_id",
            "time",
            "enabled",
            "recurring",
            "week_days",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_alarms" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tracker_id' is set
        if "tracker_id" not in params or params["tracker_id"] is None:
            raise ValueError(
                "Missing the required parameter `tracker_id` when calling `add_alarms`"
            )  # noqa: E501
        # verify the required parameter 'time' is set
        if "time" not in params or params["time"] is None:
            raise ValueError(
                "Missing the required parameter `time` when calling `add_alarms`"
            )  # noqa: E501
        # verify the required parameter 'enabled' is set
        if "enabled" not in params or params["enabled"] is None:
            raise ValueError(
                "Missing the required parameter `enabled` when calling `add_alarms`"
            )  # noqa: E501
        # verify the required parameter 'recurring' is set
        if "recurring" not in params or params["recurring"] is None:
            raise ValueError(
                "Missing the required parameter `recurring` when calling `add_alarms`"
            )  # noqa: E501
        # verify the required parameter 'week_days' is set
        if "week_days" not in params or params["week_days"] is None:
            raise ValueError(
                "Missing the required parameter `week_days` when calling `add_alarms`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tracker_id" in params:
            path_params["tracker-id"] = params["tracker_id"]  # noqa: E501

        query_params = []
        if "time" in params:
            query_params.append(("time", params["time"]))  # noqa: E501
        if "enabled" in params:
            query_params.append(("enabled", params["enabled"]))  # noqa: E501
        if "recurring" in params:
            query_params.append(("recurring", params["recurring"]))  # noqa: E501
        if "week_days" in params:
            query_params.append(("weekDays", params["week_days"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/devices/tracker/{tracker-id}/alarms.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_alarms(self, tracker_id, alarm_id, **kwargs):  # noqa: E501
        """Delete Alarm  # noqa: E501

        Deletes the user's device alarm entry with the given ID for a given device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alarms(tracker_id, alarm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker whose alarms is managed. The tracker-id value is found via the Get Devices endpoint. (required)
        :param int alarm_id: The ID of the alarm to be updated. The alarm-id value is found via the Get Alarms endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_alarms_with_http_info(
                tracker_id, alarm_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_alarms_with_http_info(
                tracker_id, alarm_id, **kwargs
            )  # noqa: E501
            return data

    def delete_alarms_with_http_info(
        self, tracker_id, alarm_id, **kwargs
    ):  # noqa: E501
        """Delete Alarm  # noqa: E501

        Deletes the user's device alarm entry with the given ID for a given device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alarms_with_http_info(tracker_id, alarm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker whose alarms is managed. The tracker-id value is found via the Get Devices endpoint. (required)
        :param int alarm_id: The ID of the alarm to be updated. The alarm-id value is found via the Get Alarms endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["tracker_id", "alarm_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alarms" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tracker_id' is set
        if "tracker_id" not in params or params["tracker_id"] is None:
            raise ValueError(
                "Missing the required parameter `tracker_id` when calling `delete_alarms`"
            )  # noqa: E501
        # verify the required parameter 'alarm_id' is set
        if "alarm_id" not in params or params["alarm_id"] is None:
            raise ValueError(
                "Missing the required parameter `alarm_id` when calling `delete_alarms`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tracker_id" in params:
            path_params["tracker-id"] = params["tracker_id"]  # noqa: E501
        if "alarm_id" in params:
            path_params["alarm-id"] = params["alarm_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/devices/tracker/{tracker-id}/alarms/{alarm-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_alarms(self, tracker_id, **kwargs):  # noqa: E501
        """Get Alarms  # noqa: E501

        Returns alarms for a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alarms(tracker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker for which data is returned. The tracker-id value is found via the Get Devices endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_alarms_with_http_info(tracker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alarms_with_http_info(tracker_id, **kwargs)  # noqa: E501
            return data

    def get_alarms_with_http_info(self, tracker_id, **kwargs):  # noqa: E501
        """Get Alarms  # noqa: E501

        Returns alarms for a device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alarms_with_http_info(tracker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker for which data is returned. The tracker-id value is found via the Get Devices endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["tracker_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alarms" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tracker_id' is set
        if "tracker_id" not in params or params["tracker_id"] is None:
            raise ValueError(
                "Missing the required parameter `tracker_id` when calling `get_alarms`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tracker_id" in params:
            path_params["tracker-id"] = params["tracker_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/devices/tracker/{tracker-id}/alarms.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_devices(self, **kwargs):  # noqa: E501
        """Get Devices  # noqa: E501

        Returns a list of the Fitbit devices connected to a user's account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_devices_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_devices_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_devices_with_http_info(self, **kwargs):  # noqa: E501
        """Get Devices  # noqa: E501

        Returns a list of the Fitbit devices connected to a user's account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_devices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/devices.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_alarms(
        self,
        tracker_id,
        alarm_id,
        time,
        enabled,
        recurring,
        week_days,
        snooze_length,
        snooze_count,
        **kwargs
    ):  # noqa: E501
        """Update Alarm  # noqa: E501

        Updates the alarm entry with a given ID for a given device. It also gets a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_alarms(tracker_id, alarm_id, time, enabled, recurring, week_days, snooze_length, snooze_count, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker for which data is returned. The tracker-id value is found via the Get Devices endpoint. (required)
        :param int alarm_id: The ID of the alarm to be updated. The alarm-id value is found in the response of the Get Activity endpoint. (required)
        :param str time: Time of day that the alarm vibrates with a UTC timezone offset, e.g. 07:15-08:00. (required)
        :param bool enabled: true or false. If false, the alarm does not vibrate until enabled is set to true. (required)
        :param str recurring: true or false. If false, the alarm is a single event. (required)
        :param str week_days: Comma seperated list of days of the week on which the alarm vibrates, e.g. MONDAY, TUESDAY. (required)
        :param int snooze_length: Minutes between alarms. (required)
        :param int snooze_count: Maximum snooze count. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_alarms_with_http_info(
                tracker_id,
                alarm_id,
                time,
                enabled,
                recurring,
                week_days,
                snooze_length,
                snooze_count,
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_alarms_with_http_info(
                tracker_id,
                alarm_id,
                time,
                enabled,
                recurring,
                week_days,
                snooze_length,
                snooze_count,
                **kwargs
            )  # noqa: E501
            return data

    def update_alarms_with_http_info(
        self,
        tracker_id,
        alarm_id,
        time,
        enabled,
        recurring,
        week_days,
        snooze_length,
        snooze_count,
        **kwargs
    ):  # noqa: E501
        """Update Alarm  # noqa: E501

        Updates the alarm entry with a given ID for a given device. It also gets a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_alarms_with_http_info(tracker_id, alarm_id, time, enabled, recurring, week_days, snooze_length, snooze_count, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tracker_id: The ID of the tracker for which data is returned. The tracker-id value is found via the Get Devices endpoint. (required)
        :param int alarm_id: The ID of the alarm to be updated. The alarm-id value is found in the response of the Get Activity endpoint. (required)
        :param str time: Time of day that the alarm vibrates with a UTC timezone offset, e.g. 07:15-08:00. (required)
        :param bool enabled: true or false. If false, the alarm does not vibrate until enabled is set to true. (required)
        :param str recurring: true or false. If false, the alarm is a single event. (required)
        :param str week_days: Comma seperated list of days of the week on which the alarm vibrates, e.g. MONDAY, TUESDAY. (required)
        :param int snooze_length: Minutes between alarms. (required)
        :param int snooze_count: Maximum snooze count. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "tracker_id",
            "alarm_id",
            "time",
            "enabled",
            "recurring",
            "week_days",
            "snooze_length",
            "snooze_count",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_alarms" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'tracker_id' is set
        if "tracker_id" not in params or params["tracker_id"] is None:
            raise ValueError(
                "Missing the required parameter `tracker_id` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'alarm_id' is set
        if "alarm_id" not in params or params["alarm_id"] is None:
            raise ValueError(
                "Missing the required parameter `alarm_id` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'time' is set
        if "time" not in params or params["time"] is None:
            raise ValueError(
                "Missing the required parameter `time` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'enabled' is set
        if "enabled" not in params or params["enabled"] is None:
            raise ValueError(
                "Missing the required parameter `enabled` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'recurring' is set
        if "recurring" not in params or params["recurring"] is None:
            raise ValueError(
                "Missing the required parameter `recurring` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'week_days' is set
        if "week_days" not in params or params["week_days"] is None:
            raise ValueError(
                "Missing the required parameter `week_days` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'snooze_length' is set
        if "snooze_length" not in params or params["snooze_length"] is None:
            raise ValueError(
                "Missing the required parameter `snooze_length` when calling `update_alarms`"
            )  # noqa: E501
        # verify the required parameter 'snooze_count' is set
        if "snooze_count" not in params or params["snooze_count"] is None:
            raise ValueError(
                "Missing the required parameter `snooze_count` when calling `update_alarms`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "tracker_id" in params:
            path_params["tracker-id"] = params["tracker_id"]  # noqa: E501
        if "alarm_id" in params:
            path_params["alarm-id"] = params["alarm_id"]  # noqa: E501

        query_params = []
        if "time" in params:
            query_params.append(("time", params["time"]))  # noqa: E501
        if "enabled" in params:
            query_params.append(("enabled", params["enabled"]))  # noqa: E501
        if "recurring" in params:
            query_params.append(("recurring", params["recurring"]))  # noqa: E501
        if "week_days" in params:
            query_params.append(("weekDays", params["week_days"]))  # noqa: E501
        if "snooze_length" in params:
            query_params.append(("snoozeLength", params["snooze_length"]))  # noqa: E501
        if "snooze_count" in params:
            query_params.append(("snoozeCount", params["snooze_count"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/devices/tracker/{tracker-id}/alarms/{alarm-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
