"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class BodyAndWeightApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_body_fat_log(self, fat, _date, time, **kwargs):  # noqa: E501
        """Log Body Fat  # noqa: E501

        Creates a log entry for body fat and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_body_fat_log(fat, _date, time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int fat: Body fat in the format of X.XX in the unit system that corresponds to the Accept-Language header provided. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param str time: Time of the measurement in hours and minutes in the format HH:mm:ss that is set to the last second of the day if not provided. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_body_fat_log_with_http_info(
                fat, _date, time, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_body_fat_log_with_http_info(
                fat, _date, time, **kwargs
            )  # noqa: E501
            return data

    def add_body_fat_log_with_http_info(self, fat, _date, time, **kwargs):  # noqa: E501
        """Log Body Fat  # noqa: E501

        Creates a log entry for body fat and returns a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_body_fat_log_with_http_info(fat, _date, time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int fat: Body fat in the format of X.XX in the unit system that corresponds to the Accept-Language header provided. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param str time: Time of the measurement in hours and minutes in the format HH:mm:ss that is set to the last second of the day if not provided. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["fat", "_date", "time"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_body_fat_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'fat' is set
        if "fat" not in params or params["fat"] is None:
            raise ValueError(
                "Missing the required parameter `fat` when calling `add_body_fat_log`"
            )  # noqa: E501
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `add_body_fat_log`"
            )  # noqa: E501
        # verify the required parameter 'time' is set
        if "time" not in params or params["time"] is None:
            raise ValueError(
                "Missing the required parameter `time` when calling `add_body_fat_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "fat" in params:
            query_params.append(("fat", params["fat"]))  # noqa: E501
        if "_date" in params:
            query_params.append(("date", params["_date"]))  # noqa: E501
        if "time" in params:
            query_params.append(("time", params["time"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/fat.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_weight_log(self, weight, _date, **kwargs):  # noqa: E501
        """Log Weight  # noqa: E501

        Creates log entry for a body weight using units in the unit systems that corresponds to the Accept-Language header provided and gets a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_weight_log(weight, _date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int weight: Weight in the format of X.XX. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param str time: Time of the measurement; hours and minutes in the format of HH:mm:ss, which is set to the last second of the day if not provided.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_weight_log_with_http_info(
                weight, _date, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_weight_log_with_http_info(
                weight, _date, **kwargs
            )  # noqa: E501
            return data

    def add_weight_log_with_http_info(self, weight, _date, **kwargs):  # noqa: E501
        """Log Weight  # noqa: E501

        Creates log entry for a body weight using units in the unit systems that corresponds to the Accept-Language header provided and gets a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_weight_log_with_http_info(weight, _date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int weight: Weight in the format of X.XX. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param str time: Time of the measurement; hours and minutes in the format of HH:mm:ss, which is set to the last second of the day if not provided.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["weight", "_date", "time"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_weight_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'weight' is set
        if "weight" not in params or params["weight"] is None:
            raise ValueError(
                "Missing the required parameter `weight` when calling `add_weight_log`"
            )  # noqa: E501
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `add_weight_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "weight" in params:
            query_params.append(("weight", params["weight"]))  # noqa: E501
        if "_date" in params:
            query_params.append(("date", params["_date"]))  # noqa: E501
        if "time" in params:
            query_params.append(("time", params["time"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/weight.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_body_fat_log(self, body_fat_log_id, **kwargs):  # noqa: E501
        """Delete Body Fat Log  # noqa: E501

        Deletes a user's body fat log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_body_fat_log(body_fat_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body_fat_log_id: The ID of the body fat log entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_body_fat_log_with_http_info(
                body_fat_log_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_body_fat_log_with_http_info(
                body_fat_log_id, **kwargs
            )  # noqa: E501
            return data

    def delete_body_fat_log_with_http_info(
        self, body_fat_log_id, **kwargs
    ):  # noqa: E501
        """Delete Body Fat Log  # noqa: E501

        Deletes a user's body fat log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_body_fat_log_with_http_info(body_fat_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body_fat_log_id: The ID of the body fat log entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body_fat_log_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_body_fat_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body_fat_log_id' is set
        if "body_fat_log_id" not in params or params["body_fat_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `body_fat_log_id` when calling `delete_body_fat_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "body_fat_log_id" in params:
            path_params["body-fat-log-id"] = params["body_fat_log_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/fat/{body-fat-log-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_weight_log(self, body_weight_log_id, **kwargs):  # noqa: E501
        """Delete Weight Log  # noqa: E501

        Deletes a user's body weight log entrywith the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_weight_log(body_weight_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body_weight_log_id: The ID of the body weight log entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_weight_log_with_http_info(
                body_weight_log_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_weight_log_with_http_info(
                body_weight_log_id, **kwargs
            )  # noqa: E501
            return data

    def delete_weight_log_with_http_info(
        self, body_weight_log_id, **kwargs
    ):  # noqa: E501
        """Delete Weight Log  # noqa: E501

        Deletes a user's body weight log entrywith the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_weight_log_with_http_info(body_weight_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int body_weight_log_id: The ID of the body weight log entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body_weight_log_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_weight_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body_weight_log_id' is set
        if "body_weight_log_id" not in params or params["body_weight_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `body_weight_log_id` when calling `delete_weight_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "body_weight_log_id" in params:
            path_params["body-weight-log-id"] = params[
                "body_weight_log_id"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/weight/{body-weight-log-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_body_fat_by_date(self, _date, **kwargs):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_fat_by_date(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_body_fat_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_body_fat_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
            return data

    def get_body_fat_by_date_with_http_info(self, _date, **kwargs):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_fat_by_date_with_http_info(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_body_fat_by_date" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_body_fat_by_date`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/fat/date/{date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_body_fat_by_date_period(self, _date, period, **kwargs):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_fat_by_date_period(_date, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :param str period: The range for which data will be returned. Options are 1d, 7d, 30d, 1w, 1m, 3m, 6m, 1y, or max. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_body_fat_by_date_period_with_http_info(
                _date, period, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_body_fat_by_date_period_with_http_info(
                _date, period, **kwargs
            )  # noqa: E501
            return data

    def get_body_fat_by_date_period_with_http_info(
        self, _date, period, **kwargs
    ):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_fat_by_date_period_with_http_info(_date, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :param str period: The range for which data will be returned. Options are 1d, 7d, 30d, 1w, 1m, 3m, 6m, 1y, or max. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date", "period"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_body_fat_by_date_period" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_body_fat_by_date_period`"
            )  # noqa: E501
        # verify the required parameter 'period' is set
        if "period" not in params or params["period"] is None:
            raise ValueError(
                "Missing the required parameter `period` when calling `get_body_fat_by_date_period`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501
        if "period" in params:
            path_params["period"] = params["period"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/fat/date/{date}/{period}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_body_fat_by_date_range(self, base_date, end_date, **kwargs):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_fat_by_date_range(base_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date base_date: The range start date in the format yyyy-MM-dd or today. (required)
        :param date end_date: The end date of the range. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_body_fat_by_date_range_with_http_info(
                base_date, end_date, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_body_fat_by_date_range_with_http_info(
                base_date, end_date, **kwargs
            )  # noqa: E501
            return data

    def get_body_fat_by_date_range_with_http_info(
        self, base_date, end_date, **kwargs
    ):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_fat_by_date_range_with_http_info(base_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date base_date: The range start date in the format yyyy-MM-dd or today. (required)
        :param date end_date: The end date of the range. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["base_date", "end_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_body_fat_by_date_range" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'base_date' is set
        if "base_date" not in params or params["base_date"] is None:
            raise ValueError(
                "Missing the required parameter `base_date` when calling `get_body_fat_by_date_range`"
            )  # noqa: E501
        # verify the required parameter 'end_date' is set
        if "end_date" not in params or params["end_date"] is None:
            raise ValueError(
                "Missing the required parameter `end_date` when calling `get_body_fat_by_date_range`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "base_date" in params:
            path_params["base-date"] = params["base_date"]  # noqa: E501
        if "end_date" in params:
            path_params["end-date"] = params["end_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/fat/date/{base-date}/{end-date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_body_goals(self, goal_type, **kwargs):  # noqa: E501
        """Get Body Goals  # noqa: E501

        Retreives a user's current body fat percentage or weight goal using units in the unit systems that corresponds to the Accept-Language header providedin the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_goals(goal_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_type: weight or fat. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_body_goals_with_http_info(goal_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_body_goals_with_http_info(
                goal_type, **kwargs
            )  # noqa: E501
            return data

    def get_body_goals_with_http_info(self, goal_type, **kwargs):  # noqa: E501
        """Get Body Goals  # noqa: E501

        Retreives a user's current body fat percentage or weight goal using units in the unit systems that corresponds to the Accept-Language header providedin the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_body_goals_with_http_info(goal_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_type: weight or fat. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["goal_type"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_body_goals" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'goal_type' is set
        if "goal_type" not in params or params["goal_type"] is None:
            raise ValueError(
                "Missing the required parameter `goal_type` when calling `get_body_goals`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "goal_type" in params:
            path_params["goal-type"] = params["goal_type"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/{goal-type}/goal.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_weight_by_date(self, _date, **kwargs):  # noqa: E501
        """Get Weight Logs  # noqa: E501

        Retreives a list of all user's body weight log entries for a given day using units in the unit systems which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weight_by_date(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_weight_by_date_with_http_info(_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_weight_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
            return data

    def get_weight_by_date_with_http_info(self, _date, **kwargs):  # noqa: E501
        """Get Weight Logs  # noqa: E501

        Retreives a list of all user's body weight log entries for a given day using units in the unit systems which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weight_by_date_with_http_info(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_weight_by_date" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_weight_by_date`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/weight/date/{date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_weight_by_date_period(self, _date, period, **kwargs):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body weight log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weight_by_date_period(_date, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :param str period: The range for which data will be returned. Options are 1d, 7d, 30d, 1w, 1m, 3m, 6m, 1y, or max. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_weight_by_date_period_with_http_info(
                _date, period, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_weight_by_date_period_with_http_info(
                _date, period, **kwargs
            )  # noqa: E501
            return data

    def get_weight_by_date_period_with_http_info(
        self, _date, period, **kwargs
    ):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body weight log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weight_by_date_period_with_http_info(_date, period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd. (required)
        :param str period: The range for which data will be returned. Options are 1d, 7d, 30d, 1w, 1m, 3m, 6m, 1y, or max. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date", "period"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_weight_by_date_period" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_weight_by_date_period`"
            )  # noqa: E501
        # verify the required parameter 'period' is set
        if "period" not in params or params["period"] is None:
            raise ValueError(
                "Missing the required parameter `period` when calling `get_weight_by_date_period`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501
        if "period" in params:
            path_params["period"] = params["period"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/weight/date/{date}/{period}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_weight_by_date_range(self, base_date, end_date, **kwargs):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weight_by_date_range(base_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date base_date: The range start date in the format yyyy-MM-dd or today. (required)
        :param date end_date: The end date of the range. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_weight_by_date_range_with_http_info(
                base_date, end_date, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_weight_by_date_range_with_http_info(
                base_date, end_date, **kwargs
            )  # noqa: E501
            return data

    def get_weight_by_date_range_with_http_info(
        self, base_date, end_date, **kwargs
    ):  # noqa: E501
        """Get Body Fat Logs  # noqa: E501

        Retreives a list of all user's body fat log entries for a given day in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_weight_by_date_range_with_http_info(base_date, end_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date base_date: The range start date in the format yyyy-MM-dd or today. (required)
        :param date end_date: The end date of the range. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["base_date", "end_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_weight_by_date_range" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'base_date' is set
        if "base_date" not in params or params["base_date"] is None:
            raise ValueError(
                "Missing the required parameter `base_date` when calling `get_weight_by_date_range`"
            )  # noqa: E501
        # verify the required parameter 'end_date' is set
        if "end_date" not in params or params["end_date"] is None:
            raise ValueError(
                "Missing the required parameter `end_date` when calling `get_weight_by_date_range`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "base_date" in params:
            path_params["base-date"] = params["base_date"]  # noqa: E501
        if "end_date" in params:
            path_params["end-date"] = params["end_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/weight/date/{base-date}/{end-date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_body_fat_goal(self, fat, **kwargs):  # noqa: E501
        """Update Body Fat Goal  # noqa: E501

        Updates user's fat percentage goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_body_fat_goal(fat, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fat: Target body fat percentage; in the format X.XX. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_body_fat_goal_with_http_info(fat, **kwargs)  # noqa: E501
        else:
            (data) = self.update_body_fat_goal_with_http_info(
                fat, **kwargs
            )  # noqa: E501
            return data

    def update_body_fat_goal_with_http_info(self, fat, **kwargs):  # noqa: E501
        """Update Body Fat Goal  # noqa: E501

        Updates user's fat percentage goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_body_fat_goal_with_http_info(fat, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fat: Target body fat percentage; in the format X.XX. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["fat"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_body_fat_goal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'fat' is set
        if "fat" not in params or params["fat"] is None:
            raise ValueError(
                "Missing the required parameter `fat` when calling `update_body_fat_goal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "fat" in params:
            query_params.append(("fat", params["fat"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/fat/goal.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_weight_goal(self, start_date, start_weight, **kwargs):  # noqa: E501
        """Update Weight Goal  # noqa: E501

        Updates user's fat percentage goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_weight_goal(start_date, start_weight, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Weight goal start date; in the format yyyy-MM-dd. (required)
        :param str start_weight: Weight goal start weight; in the format X.XX, in the unit systems that corresponds to the Accept-Language header provided. (required)
        :param str weight: Weight goal target weight; in the format X.XX, in the unit systems that corresponds to the Accept-Language header provided; required if user doesn't have an existing weight goal.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_weight_goal_with_http_info(
                start_date, start_weight, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_weight_goal_with_http_info(
                start_date, start_weight, **kwargs
            )  # noqa: E501
            return data

    def update_weight_goal_with_http_info(
        self, start_date, start_weight, **kwargs
    ):  # noqa: E501
        """Update Weight Goal  # noqa: E501

        Updates user's fat percentage goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_weight_goal_with_http_info(start_date, start_weight, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str start_date: Weight goal start date; in the format yyyy-MM-dd. (required)
        :param str start_weight: Weight goal start weight; in the format X.XX, in the unit systems that corresponds to the Accept-Language header provided. (required)
        :param str weight: Weight goal target weight; in the format X.XX, in the unit systems that corresponds to the Accept-Language header provided; required if user doesn't have an existing weight goal.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["start_date", "start_weight", "weight"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_weight_goal" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'start_date' is set
        if "start_date" not in params or params["start_date"] is None:
            raise ValueError(
                "Missing the required parameter `start_date` when calling `update_weight_goal`"
            )  # noqa: E501
        # verify the required parameter 'start_weight' is set
        if "start_weight" not in params or params["start_weight"] is None:
            raise ValueError(
                "Missing the required parameter `start_weight` when calling `update_weight_goal`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "start_date" in params:
            query_params.append(("startDate", params["start_date"]))  # noqa: E501
        if "start_weight" in params:
            query_params.append(("startWeight", params["start_weight"]))  # noqa: E501
        if "weight" in params:
            query_params.append(("weight", params["weight"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/body/log/weight/goal.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
