"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from fitbit.api_client import ApiClient


class ActivityApi:
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_activities_log(
        self,
        activity_id,
        manual_calories,
        start_time,
        duration_millis,
        _date,
        distance,
        **kwargs
    ):  # noqa: E501
        """Log Activity  # noqa: E501

        The Log Activity endpoint creates log entry for an activity or user's private custom activity using units in the unit system which corresponds to the Accept-Language header provided (or using optional custom distanceUnit) and get a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_activities_log(activity_id, manual_calories, start_time, duration_millis, _date, distance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_id: The ID of the activity, directory activity or intensity level activity. (required)
        :param int manual_calories: Calories burned that are manaully specified. Required with activityName must be provided. (required)
        :param str start_time: Activity start time. Hours and minutes in the format HH:mm:ss. (required)
        :param int duration_millis: Duration in milliseconds. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param int distance: Distance is required for logging directory activity in the format X.XX and in the selected distanceUnit. (required)
        :param str activity_name: Custom activity name. Either activityId or activityName must be provided.
        :param int distance_unit: Distance measurement unit. Steps units are available only for Walking (activityId=90013) and Running (activityId=90009) directory activities and their intensity levels.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_activities_log_with_http_info(
                activity_id,
                manual_calories,
                start_time,
                duration_millis,
                _date,
                distance,
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_activities_log_with_http_info(
                activity_id,
                manual_calories,
                start_time,
                duration_millis,
                _date,
                distance,
                **kwargs
            )  # noqa: E501
            return data

    def add_activities_log_with_http_info(
        self,
        activity_id,
        manual_calories,
        start_time,
        duration_millis,
        _date,
        distance,
        **kwargs
    ):  # noqa: E501
        """Log Activity  # noqa: E501

        The Log Activity endpoint creates log entry for an activity or user's private custom activity using units in the unit system which corresponds to the Accept-Language header provided (or using optional custom distanceUnit) and get a response in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_activities_log_with_http_info(activity_id, manual_calories, start_time, duration_millis, _date, distance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_id: The ID of the activity, directory activity or intensity level activity. (required)
        :param int manual_calories: Calories burned that are manaully specified. Required with activityName must be provided. (required)
        :param str start_time: Activity start time. Hours and minutes in the format HH:mm:ss. (required)
        :param int duration_millis: Duration in milliseconds. (required)
        :param date _date: Log entry date in the format yyyy-MM-dd. (required)
        :param int distance: Distance is required for logging directory activity in the format X.XX and in the selected distanceUnit. (required)
        :param str activity_name: Custom activity name. Either activityId or activityName must be provided.
        :param int distance_unit: Distance measurement unit. Steps units are available only for Walking (activityId=90013) and Running (activityId=90009) directory activities and their intensity levels.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "activity_id",
            "manual_calories",
            "start_time",
            "duration_millis",
            "_date",
            "distance",
            "activity_name",
            "distance_unit",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_activities_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'activity_id' is set
        if "activity_id" not in params or params["activity_id"] is None:
            raise ValueError(
                "Missing the required parameter `activity_id` when calling `add_activities_log`"
            )  # noqa: E501
        # verify the required parameter 'manual_calories' is set
        if "manual_calories" not in params or params["manual_calories"] is None:
            raise ValueError(
                "Missing the required parameter `manual_calories` when calling `add_activities_log`"
            )  # noqa: E501
        # verify the required parameter 'start_time' is set
        if "start_time" not in params or params["start_time"] is None:
            raise ValueError(
                "Missing the required parameter `start_time` when calling `add_activities_log`"
            )  # noqa: E501
        # verify the required parameter 'duration_millis' is set
        if "duration_millis" not in params or params["duration_millis"] is None:
            raise ValueError(
                "Missing the required parameter `duration_millis` when calling `add_activities_log`"
            )  # noqa: E501
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `add_activities_log`"
            )  # noqa: E501
        # verify the required parameter 'distance' is set
        if "distance" not in params or params["distance"] is None:
            raise ValueError(
                "Missing the required parameter `distance` when calling `add_activities_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "activity_id" in params:
            query_params.append(("activityId", params["activity_id"]))  # noqa: E501
        if "activity_name" in params:
            query_params.append(("activityName", params["activity_name"]))  # noqa: E501
        if "manual_calories" in params:
            query_params.append(
                ("manualCalories", params["manual_calories"])
            )  # noqa: E501
        if "start_time" in params:
            query_params.append(("startTime", params["start_time"]))  # noqa: E501
        if "duration_millis" in params:
            query_params.append(
                ("durationMillis", params["duration_millis"])
            )  # noqa: E501
        if "_date" in params:
            query_params.append(("date", params["_date"]))  # noqa: E501
        if "distance" in params:
            query_params.append(("distance", params["distance"]))  # noqa: E501
        if "distance_unit" in params:
            query_params.append(("distanceUnit", params["distance_unit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_favorite_activities(self, activity_id, **kwargs):  # noqa: E501
        """Add Favorite Activity  # noqa: E501

        Adds the activity with the given ID to user's list of favorite activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_favorite_activities(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: The encoded ID of the activity. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_favorite_activities_with_http_info(
                activity_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_favorite_activities_with_http_info(
                activity_id, **kwargs
            )  # noqa: E501
            return data

    def add_favorite_activities_with_http_info(
        self, activity_id, **kwargs
    ):  # noqa: E501
        """Add Favorite Activity  # noqa: E501

        Adds the activity with the given ID to user's list of favorite activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_favorite_activities_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: The encoded ID of the activity. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["activity_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_favorite_activities" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'activity_id' is set
        if "activity_id" not in params or params["activity_id"] is None:
            raise ValueError(
                "Missing the required parameter `activity_id` when calling `add_favorite_activities`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "activity_id" in params:
            path_params["activity-id"] = params["activity_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/favorite/{activity-id}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def add_update_activities_goals(self, period, type, value, **kwargs):  # noqa: E501
        """Update Activity Goals  # noqa: E501

        Updates a user's daily or weekly activity goals and returns a response using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_update_activities_goals(period, type, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str period: daily or weekly. (required)
        :param str type: goal type (required)
        :param str value: goal value (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.add_update_activities_goals_with_http_info(
                period, type, value, **kwargs
            )  # noqa: E501
        else:
            (data) = self.add_update_activities_goals_with_http_info(
                period, type, value, **kwargs
            )  # noqa: E501
            return data

    def add_update_activities_goals_with_http_info(
        self, period, type, value, **kwargs
    ):  # noqa: E501
        """Update Activity Goals  # noqa: E501

        Updates a user's daily or weekly activity goals and returns a response using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_update_activities_goals_with_http_info(period, type, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str period: daily or weekly. (required)
        :param str type: goal type (required)
        :param str value: goal value (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["period", "type", "value"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_update_activities_goals" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'period' is set
        if "period" not in params or params["period"] is None:
            raise ValueError(
                "Missing the required parameter `period` when calling `add_update_activities_goals`"
            )  # noqa: E501
        # verify the required parameter 'type' is set
        if "type" not in params or params["type"] is None:
            raise ValueError(
                "Missing the required parameter `type` when calling `add_update_activities_goals`"
            )  # noqa: E501
        # verify the required parameter 'value' is set
        if "value" not in params or params["value"] is None:
            raise ValueError(
                "Missing the required parameter `value` when calling `add_update_activities_goals`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "period" in params:
            path_params["period"] = params["period"]  # noqa: E501

        query_params = []
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501
        if "value" in params:
            query_params.append(("value", params["value"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/goals/{period}.json",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_activities_log(self, activity_log_id, **kwargs):  # noqa: E501
        """Delete Activity Log  # noqa: E501

        Deletes a user's activity log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activities_log(activity_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_log_id: The id of the activity log entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_activities_log_with_http_info(
                activity_log_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_activities_log_with_http_info(
                activity_log_id, **kwargs
            )  # noqa: E501
            return data

    def delete_activities_log_with_http_info(
        self, activity_log_id, **kwargs
    ):  # noqa: E501
        """Delete Activity Log  # noqa: E501

        Deletes a user's activity log entry with the given ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activities_log_with_http_info(activity_log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_log_id: The id of the activity log entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["activity_log_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_activities_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'activity_log_id' is set
        if "activity_log_id" not in params or params["activity_log_id"] is None:
            raise ValueError(
                "Missing the required parameter `activity_log_id` when calling `delete_activities_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "activity_log_id" in params:
            path_params["activity-log-id"] = params["activity_log_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/{activity-log-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_favorite_activities(self, activity_id, **kwargs):  # noqa: E501
        """Delete Favorite Activity  # noqa: E501

        Removes the activity with the given ID from a user's list of favorite activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_favorite_activities(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: The ID of the activity to be removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_favorite_activities_with_http_info(
                activity_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_favorite_activities_with_http_info(
                activity_id, **kwargs
            )  # noqa: E501
            return data

    def delete_favorite_activities_with_http_info(
        self, activity_id, **kwargs
    ):  # noqa: E501
        """Delete Favorite Activity  # noqa: E501

        Removes the activity with the given ID from a user's list of favorite activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_favorite_activities_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: The ID of the activity to be removed. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["activity_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_favorite_activities" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'activity_id' is set
        if "activity_id" not in params or params["activity_id"] is None:
            raise ValueError(
                "Missing the required parameter `activity_id` when calling `delete_favorite_activities`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "activity_id" in params:
            path_params["activity-id"] = params["activity_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/favorite/{activity-id}.json",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_by_date(self, _date, **kwargs):  # noqa: E501
        """Get Activity Summary by Date   # noqa: E501

        Retrieves a summary and list of a user's activities and activity log entries for a given day.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_by_date(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_activities_by_date_with_http_info(
                _date, **kwargs
            )  # noqa: E501
            return data

    def get_activities_by_date_with_http_info(self, _date, **kwargs):  # noqa: E501
        """Get Activity Summary by Date   # noqa: E501

        Retrieves a summary and list of a user's activities and activity log entries for a given day.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_by_date_with_http_info(_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param date _date: The date in the format yyyy-MM-dd (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["_date"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_by_date" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter '_date' is set
        if "_date" not in params or params["_date"] is None:
            raise ValueError(
                "Missing the required parameter `_date` when calling `get_activities_by_date`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "_date" in params:
            path_params["date"] = params["_date"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/date/{date}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_goals(self, period, **kwargs):  # noqa: E501
        """Get Activity Goals  # noqa: E501

        Retreives a user's current daily or weekly activity goals using measurement units as defined in the unit system, which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_goals(period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str period: daily or weekly. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_goals_with_http_info(
                period, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_activities_goals_with_http_info(
                period, **kwargs
            )  # noqa: E501
            return data

    def get_activities_goals_with_http_info(self, period, **kwargs):  # noqa: E501
        """Get Activity Goals  # noqa: E501

        Retreives a user's current daily or weekly activity goals using measurement units as defined in the unit system, which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_goals_with_http_info(period, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str period: daily or weekly. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["period"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_goals" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'period' is set
        if "period" not in params or params["period"] is None:
            raise ValueError(
                "Missing the required parameter `period` when calling `get_activities_goals`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "period" in params:
            path_params["period"] = params["period"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/goals/{period}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_log(self, **kwargs):  # noqa: E501
        """Get Lifetime Stats  # noqa: E501

        Updates a user's daily activity goals and returns a response using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_log(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_log_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activities_log_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activities_log_with_http_info(self, **kwargs):  # noqa: E501
        """Get Lifetime Stats  # noqa: E501

        Updates a user's daily activity goals and returns a response using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_log_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_log" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_log_list(self, sort, offset, limit, **kwargs):  # noqa: E501
        """Get Activity Log List  # noqa: E501

        Retreives a list of user's activity log entries before or after a given day with offset and limit using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_log_list(sort, offset, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The sort order of entries by date asc (ascending) or desc (descending). (required)
        :param int offset: The offset number of entries. (required)
        :param int limit: The maximum number of entries returned (maximum;100). (required)
        :param date before_date: The date in the format yyyy-MM-ddTHH:mm:ss. Only yyyy-MM-dd is required. Either beforeDate or afterDate should be specified.
        :param date after_date: The date in the format yyyy-MM-ddTHH:mm:ss.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_log_list_with_http_info(
                sort, offset, limit, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_activities_log_list_with_http_info(
                sort, offset, limit, **kwargs
            )  # noqa: E501
            return data

    def get_activities_log_list_with_http_info(
        self, sort, offset, limit, **kwargs
    ):  # noqa: E501
        """Get Activity Log List  # noqa: E501

        Retreives a list of user's activity log entries before or after a given day with offset and limit using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_log_list_with_http_info(sort, offset, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sort: The sort order of entries by date asc (ascending) or desc (descending). (required)
        :param int offset: The offset number of entries. (required)
        :param int limit: The maximum number of entries returned (maximum;100). (required)
        :param date before_date: The date in the format yyyy-MM-ddTHH:mm:ss. Only yyyy-MM-dd is required. Either beforeDate or afterDate should be specified.
        :param date after_date: The date in the format yyyy-MM-ddTHH:mm:ss.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "sort",
            "offset",
            "limit",
            "before_date",
            "after_date",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_log_list" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'sort' is set
        if "sort" not in params or params["sort"] is None:
            raise ValueError(
                "Missing the required parameter `sort` when calling `get_activities_log_list`"
            )  # noqa: E501
        # verify the required parameter 'offset' is set
        if "offset" not in params or params["offset"] is None:
            raise ValueError(
                "Missing the required parameter `offset` when calling `get_activities_log_list`"
            )  # noqa: E501
        # verify the required parameter 'limit' is set
        if "limit" not in params or params["limit"] is None:
            raise ValueError(
                "Missing the required parameter `limit` when calling `get_activities_log_list`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "before_date" in params:
            query_params.append(("beforeDate", params["before_date"]))  # noqa: E501
        if "after_date" in params:
            query_params.append(("afterDate", params["after_date"]))  # noqa: E501
        if "sort" in params:
            query_params.append(("sort", params["sort"]))  # noqa: E501
        if "offset" in params:
            query_params.append(("offset", params["offset"]))  # noqa: E501
        if "limit" in params:
            query_params.append(("limit", params["limit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/list.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_tcx(self, log_id, **kwargs):  # noqa: E501
        """Get Activity TCX  # noqa: E501

        Retreives the details of a user's location and heart rate data during a logged exercise activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_tcx(log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str log_id: The activity's log ID. (required)
        :param bool include_partial_tcx: Include TCX points regardless of GPS data being present
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_tcx_with_http_info(
                log_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_activities_tcx_with_http_info(
                log_id, **kwargs
            )  # noqa: E501
            return data

    def get_activities_tcx_with_http_info(self, log_id, **kwargs):  # noqa: E501
        """Get Activity TCX  # noqa: E501

        Retreives the details of a user's location and heart rate data during a logged exercise activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_tcx_with_http_info(log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str log_id: The activity's log ID. (required)
        :param bool include_partial_tcx: Include TCX points regardless of GPS data being present
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["log_id", "include_partial_tcx"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_tcx" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'log_id' is set
        if "log_id" not in params or params["log_id"] is None:
            raise ValueError(
                "Missing the required parameter `log_id` when calling `get_activities_tcx`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "log_id" in params:
            path_params["log-id"] = params["log_id"]  # noqa: E501

        query_params = []
        if "include_partial_tcx" in params:
            query_params.append(
                ("includePartialTCX", params["include_partial_tcx"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/{log-id}.tcx",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_type_detail(self, activity_id, **kwargs):  # noqa: E501
        """Get Activity Type  # noqa: E501

        Returns the detail of a specific activity in the Fitbit activities database in the format requested. If activity has levels, it also returns a list of activity level details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_type_detail(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: The activity ID. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_type_detail_with_http_info(
                activity_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_activities_type_detail_with_http_info(
                activity_id, **kwargs
            )  # noqa: E501
            return data

    def get_activities_type_detail_with_http_info(
        self, activity_id, **kwargs
    ):  # noqa: E501
        """Get Activity Type  # noqa: E501

        Returns the detail of a specific activity in the Fitbit activities database in the format requested. If activity has levels, it also returns a list of activity level details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_type_detail_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: The activity ID. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["activity_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_type_detail" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'activity_id' is set
        if "activity_id" not in params or params["activity_id"] is None:
            raise ValueError(
                "Missing the required parameter `activity_id` when calling `get_activities_type_detail`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "activity_id" in params:
            path_params["activity-id"] = params["activity_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/activities/{activity-id}.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_activities_types(self, **kwargs):  # noqa: E501
        """Browse Activity Types  # noqa: E501

        Retreives a tree of all valid Fitbit public activities from the activities catelog as well as private custom activities the user created in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_types(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_activities_types_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activities_types_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activities_types_with_http_info(self, **kwargs):  # noqa: E501
        """Browse Activity Types  # noqa: E501

        Retreives a tree of all valid Fitbit public activities from the activities catelog as well as private custom activities the user created in the format requested.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities_types" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/activities.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_favorite_activities(self, **kwargs):  # noqa: E501
        """Get Favorite Activities  # noqa: E501

        Returns a list of a user's favorite activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_favorite_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_favorite_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_favorite_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_favorite_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Get Favorite Activities  # noqa: E501

        Returns a list of a user's favorite activities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_favorite_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_favorite_activities" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/favorite.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_frequent_activities(self, **kwargs):  # noqa: E501
        """Get Frequent Activities  # noqa: E501

        Retreives a list of a user's frequent activities in the format requested using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_frequent_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_frequent_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_frequent_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_frequent_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Get Frequent Activities  # noqa: E501

        Retreives a list of a user's frequent activities in the format requested using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_frequent_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_frequent_activities" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/frequent.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_recent_activities(self, **kwargs):  # noqa: E501
        """Get Recent Activity Types  # noqa: E501

        Retreives a list of a user's recent activities types logged with some details of the last activity log of that type using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recent_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_recent_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_recent_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_recent_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Get Recent Activity Types  # noqa: E501

        Retreives a list of a user's recent activities types logged with some details of the last activity log of that type using units in the unit system which corresponds to the Accept-Language header provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recent_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recent_activities" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/1/user/-/activities/recent.json",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
