# flake8: noqa

"""
    Fitbit Web API

    Fitbit provides a Web API for accessing data from Fitbit activity trackers, Aria scale, and manually entered logs. Anyone can develop an application to access and modify a Fitbit user's data on their behalf, so long as it complies with Fitbit Platform Terms of Service. These Swagger UI docs do not currently support making Fitbit API requests directly. In order to make a request, construct a request for the appropriate endpoint using this documentation, and then add an Authorization header to each request with an access token obtained using the steps outlined here: https://dev.fitbit.com/build/reference/web-api/oauth2/#obtaining-consent.  # noqa: E501

    OpenAPI spec version: 1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


# import apis into sdk package
from fitbit.api.activity_api import ActivityApi
from fitbit.api.activity_intraday_time_series_api import ActivityIntradayTimeSeriesApi
from fitbit.api.activity_time_series_api import ActivityTimeSeriesApi
from fitbit.api.auth_api import AuthApi
from fitbit.api.body_and_weight_api import BodyAndWeightApi
from fitbit.api.body_and_weight_time_series_api import BodyAndWeightTimeSeriesApi
from fitbit.api.devices_api import DevicesApi
from fitbit.api.food_and_water_api import FoodAndWaterApi
from fitbit.api.food_and_water_time_series_api import FoodAndWaterTimeSeriesApi
from fitbit.api.friends_api import FriendsApi
from fitbit.api.heart_rate_intraday_time_series_api import (
    HeartRateIntradayTimeSeriesApi,
)
from fitbit.api.heart_rate_time_series_api import HeartRateTimeSeriesApi
from fitbit.api.sleep_api import SleepApi
from fitbit.api.subscriptions_api import SubscriptionsApi
from fitbit.api.user_api import UserApi

# import ApiClient
from fitbit.api_client import ApiClient
from fitbit.configuration import Configuration

# import models into sdk package
from fitbit.models.oauth2_introspect_body import Oauth2IntrospectBody
from fitbit.models.profile_json_body import ProfileJsonBody
