# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05_inter_widgets.ipynb (unless otherwise specified).

__all__ = ['display_df', 'search_box', 'paginate']

# Cell
import pandas as pd
import numpy as np
from .df import PandasDisplay

# Cell
def display_df(df):display(df)

def search_box(df,columns,manual = False,max_rows = 10,callback = display_df):
    """
    create a search box based on dataframe
    df: pandas dataframe
    columns: str, dataframe field name
    manual: bool, search the dataframe on when click the button(manual=True),
        or on keypress reaction to inputbox (manual=False), default False
    max_rows:int, max rows of show result, default 10
    callback: python callable, discribe the action you want to put on
        search result (a filtered dataframe), default is to display the dataframe
    """
    from ipywidgets import interact,interact_manual
    from IPython.display import HTML

    intera = interact_manual if manual else interact

    @intera
    def search(KeyWord = "",):
        for col in columns:
            result = df[col].fillna("NaN Value").str.contains(KeyWord)
            if sum(result)>0:
                with PandasDisplay(max_colwidth=0,max_rows=max_rows):
                    display(HTML(f"<h3>\"{KeyWord}\" matched on column:[{col}]</h3>"))
                    callback(df[result].head(max_rows))
                    return
        print(f"Nothing found on any column on keyword:{KeyWord}")
        return

# Cell
def paginate(df,page_len = 20):
    """
    Paginate dataframe in jupyter notebook interactively
    Like you can flip through the page
    """
    from ipywidgets import interact,interact_manual
    from IPython.display import display,HTML
    pages = len(df)//page_len
    @interact
    def preview(page = (0,pages)):
        display(HTML(f"<h4>page:{page}/{pages}</4>"))
        end = (page+1)*page_len
        display(df.head(end).tail(page_len))