# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/imports.ipynb (unless otherwise specified).

__all__ = ['list_vc', 'col_list_vc', 'to_optim', '__all__']

# Cell

__all__ = ["pd","np","partial","Path","json","Counter",
           "plt","os","sys","glob","Image",]
import pandas as pd

def list_vc(
    df, colname: str, value: str
) -> pd.DataFrame:
    """
    count the values in a column
        that each cell is a list
    """
    return df[colname].list_vc(value)

def col_list_vc(
    col, value: str
) -> pd.DataFrame:
    """
    count the values in a column
        that each cell is a list
    """
    return pd.DataFrame(
        col.apply(lambda x: value in x).value_counts()
    )

pd.DataFrame.vc = lambda self,col:pd.DataFrame(self[col].value_counts())
pd.Series.list_vc = col_list_vc
pd.DataFrame.list_vc = list_vc

import numpy as np
from pathlib import Path
import json
from functools import partial
from collections import Counter
from matplotlib import pyplot as plt

import os
import sys

try:
    from .widgets import search_box,paginate
    pd.DataFrame.search_box = search_box
    pd.DataFrame.paginate = paginate
except:
    pass

try:
    import torch
    from torch import nn
    from torch.utils.data.dataset import Dataset
    from torch.utils.data.dataloader import DataLoader
    __all__+=["nn","torch","Dataset","DataLoader"]
except:
    print("""Pytorch not loaded""")

try:
    from torchvision import transforms as tfm
    __all__.append("tfm")
except:
    print("""Torch Vision not loaded""")

try:
    from ipywidgets import interact, interact_manual
    from IPython.display import HTML
    __all__+=["interact","interact_manual","HTML"]
except:
    print("Jupyter notebook libs not loaded")

from glob import glob
from PIL import Image

Path.ls = lambda x:os.listdir(x)

def to_optim(self,optimizer = torch.optim.Adam,**kwargs):
    self.optimizer = optimizer(self.parameters(),**kwargs)

torch.nn.Module.to_optim=to_optim
__all__.append("to_optim")