"""
MonkAI Agent - A flexible and powerful AI agent framework
"""

from .providers import OpenAIProvider, LLMProvider, AzureProvider
from .base import AgentManager
from .types import Agent, Response, Result, PromptTest, PromptOptimizer
from .memory import Memory, AgentMemory
from .prompt_optimizer import PromptOptimizerManager
from .monkai_agent_creator import MonkaiAgentCreator, TransferTriageAgentCreator
from .triage_agent_creator import TriageAgentCreator
from .mcp_agent import MCPAgent, MCPClientConfig, MCPClientConnection, create_stdio_mcp_config, create_sse_mcp_config, create_http_mcp_config

__all__ = [
    'AgentManager',
    'Agent',
    'Response',
    'Result',
    'PromptTest',
    'PromptOptimizer',
    'PromptOptimizerManager',
    'MonkaiAgentCreator',
    'TriageAgentCreator',
    'TransferTriageAgentCreator',
    'Memory',
    'AgentMemory',
    'OpenAIProvider',
    'AzureProvider',
    'LLMProvider',
    'MCPAgent',
    'MCPClientConfig',
    'MCPClientConnection',
    'create_stdio_mcp_config',
    'create_sse_mcp_config',
    'create_http_mcp_config'
]
