# -*- coding: utf-8 -*-

"""
    dropbox_test_api_implicit

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from dropbox_test_api_implicit.api_helper import APIHelper


class Configuration(object):

    """A class used for configuring the SDK by a user.

    This class need not be instantiated and all properties and methods
    are accessible without instance creation.

    """

    # Set the array parameter serialization method
    # (allowed: indexed, unindexed, plain, csv, tsv, psv)
    array_serialization = "indexed"

    # An enum for SDK environments
    class Environment(object):
        PRODUCTION = 0

    # An enum for API servers
    class Server(object):
        DEFAULT = 0
        TOKEN_AUTH = 1
        AUTH = 2

    # The environment in which the SDK is running
    environment = Environment.PRODUCTION

    # TODO: Set an appropriate value
    basepath = 'api.dropboxapi.com'

    # OAuth 2 Client ID
    # TODO: Set an appropriate value
    o_auth_client_id = None

    # OAuth 2 Redirection endpoint or Callback Uri
    # TODO: Set an appropriate value
    o_auth_redirect_uri = None


    # All the environments the SDK can run in
    environments = {
        Environment.PRODUCTION: {
            Server.DEFAULT: 'https://{basepath}/2',
            Server.TOKEN_AUTH: 'https://api.dropbox.com/oauth2',
            Server.AUTH: 'https://www.dropbox.com/oauth2',
        },
    }

    @classmethod
    def get_base_uri(cls, server=Server.DEFAULT):
        """Generates the appropriate base URI for the environment and the server.

        Args:
            server (Configuration.Server): The server enum for which the base URI is required.

        Returns:
            String: The base URI.

        """
        parameters = {
            "basepath": cls.basepath,
        }
        return APIHelper.append_url_with_template_parameters(
            cls.environments[cls.environment][server], parameters, False)
