# Generated by Django 3.2.11 on 2022-05-07 02:53

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        ("edc_action_item", "0028_auto_20210203_0706"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("effect_subject", "0057_auto_20220505_0718"),
    ]

    operations = [
        migrations.AddField(
            model_name="bloodresultschem",
            name="crp_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="crp_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="crp_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="crp_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="crp_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="crp_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="C-reactive protein",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="magnesium_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="magnesium_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="magnesium_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="magnesium_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="magnesium_units",
            field=models.CharField(
                blank=True,
                choices=[("mmol/L", "mmol/L (millimoles/L)"), ("mg/dL", "mg/dL")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="magnesium_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="Magnesium",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="potassium_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="potassium_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="potassium_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="potassium_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="potassium_units",
            field=models.CharField(
                blank=True,
                choices=[("mmol/L", "mmol/L (millimoles/L)")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="potassium_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="Potassium",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="tbil_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="tbil_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="tbil_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="tbil_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="tbil_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="bloodresultschem",
            name="tbil_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="Total Bilirubin",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="crp_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="crp_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="crp_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="crp_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="crp_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="crp_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="C-reactive protein",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="magnesium_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="magnesium_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="magnesium_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="magnesium_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="magnesium_units",
            field=models.CharField(
                blank=True,
                choices=[("mmol/L", "mmol/L (millimoles/L)"), ("mg/dL", "mg/dL")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="magnesium_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="Magnesium",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="potassium_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="potassium_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="potassium_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="potassium_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="potassium_units",
            field=models.CharField(
                blank=True,
                choices=[("mmol/L", "mmol/L (millimoles/L)")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="potassium_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="Potassium",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="tbil_abnormal",
            field=models.CharField(
                blank=True,
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                null=True,
                verbose_name="abnormal",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="tbil_grade",
            field=models.IntegerField(
                blank=True,
                choices=[
                    (0, "Not graded"),
                    (1, "Grade 1"),
                    (2, "Grade 2"),
                    (3, "Grade 3"),
                    (4, "Grade 4"),
                    (5, "Grade 5"),
                ],
                null=True,
                verbose_name="Grade",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="tbil_grade_description",
            field=models.CharField(
                blank=True, max_length=250, null=True, verbose_name="Grade description"
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="tbil_reportable",
            field=models.CharField(
                blank=True,
                choices=[
                    ("N/A", "Not applicable"),
                    ("3", "Yes, grade 3"),
                    ("4", "Yes, grade 4"),
                    ("No", "Not reportable"),
                    ("Already reported", "Already reported"),
                    ("present_at_baseline", "Present at baseline"),
                ],
                max_length=25,
                null=True,
                verbose_name="reportable",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="tbil_units",
            field=models.CharField(
                blank=True,
                choices=[("mg/dL", "mg/dL")],
                max_length=15,
                null=True,
                verbose_name="units",
            ),
        ),
        migrations.AddField(
            model_name="historicalbloodresultschem",
            name="tbil_value",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                max_digits=8,
                null=True,
                validators=[django.core.validators.MinValueValidator(0.0)],
                verbose_name="Total Bilirubin",
            ),
        ),
        migrations.CreateModel(
            name="Urinalysis",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "proteinuria_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Proteinuria",
                    ),
                ),
                (
                    "proteinuria_units",
                    models.CharField(
                        blank=True,
                        choices=[("+", "+")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "proteinuria_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "proteinuria_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "proteinuria_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "proteinuria_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Urinalysis",
                "verbose_name_plural": "Urinalysis",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalUrinalysis",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "proteinuria_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Proteinuria",
                    ),
                ),
                (
                    "proteinuria_units",
                    models.CharField(
                        blank=True,
                        choices=[("+", "+")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "proteinuria_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "proteinuria_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "proteinuria_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "proteinuria_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Urinalysis",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddIndex(
            model_name="urinalysis",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_dd71f9_idx"
            ),
        ),
    ]
