# Generated by Django 3.2.7 on 2021-11-09 00:58

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_lab.managers
import edc_model.models.fields.initials_field
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import edc_vitals.models.fields.weight
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import effect_subject.fields.temperature
import effect_subject.models.subject_visit


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("effect_lists", "0001_initial"),
        ("edc_appointment", "0025_auto_20210624_0225"),
        ("edc_action_item", "0028_auto_20210203_0706"),
        ("edc_lab", "0021_auto_20200513_0034"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                ("visit_code", models.CharField(editable=False, max_length=25, null=True)),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        default="alive",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit"),
                            ("unscheduled", "Unscheduled visit"),
                            ("missed", "Missed visit"),
                        ],
                        help_text="If 'missed', fill in the separate missed visit report",
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            ("patient_unwell_outpatient", "Patient unwell (outpatient)"),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("recurrence_symptoms", "Recurrence of symptoms"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "unschedule_self_referral",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="If 'unschedule', is this a self-referral?",
                    ),
                ),
                (
                    "unschedule_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If 'unschedule', please provide further details, if any",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            ("patient", "Patient"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("N/A", "Not applicable (if missed)"),
                            ("OTHER", "Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "appointment",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_appointment.appointment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "ordering": (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", effect_subject.models.subject_visit.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.VisitModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="VitalSigns",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField(null=True)),
                (
                    "weight_measured_or_est",
                    models.CharField(
                        choices=[
                            ("measured", "Measured (weighed)"),
                            ("estimated", "Estimated"),
                        ],
                        max_length=25,
                        verbose_name="Is the weight estimated or measured?",
                    ),
                ),
                (
                    "heart_rate",
                    models.IntegerField(
                        help_text="BPM",
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(200),
                        ],
                        verbose_name="Heart rate:",
                    ),
                ),
                (
                    "respiratory_rate",
                    models.IntegerField(
                        help_text="breaths/min",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(6),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Respiratory rate:",
                    ),
                ),
                ("temperature", effect_subject.fields.temperature.TemperatureField()),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Are any of the above reportable as Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to any of the above?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Vital Signs",
                "verbose_name_plural": "Vital Signs",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectVisitMissed",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        help_text="If deceased, complete the death report",
                        max_length=25,
                        verbose_name="Survival status",
                    ),
                ),
                (
                    "contact_attempted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Not including pre-appointment reminders",
                        max_length=25,
                        verbose_name="Were any attempts made to contact the participant since the expected appointment date?",
                    ),
                ),
                (
                    "contact_attempts_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Not including pre-appointment reminders",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of attempts made to contact participantsince the expected appointment date",
                    ),
                ),
                (
                    "contact_attempts_explained",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If contact not made and less than 3 attempts, please explain",
                    ),
                ),
                (
                    "contact_last_date",
                    models.DateField(
                        blank=True,
                        default=edc_utils.date.get_utcnow,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_not_future,
                            edc_protocol.validators.date_not_before_study_start,
                        ],
                        verbose_name="Date of last telephone contact/attempt",
                    ),
                ),
                (
                    "contact_made",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Was contact finally made with the participant?",
                    ),
                ),
                (
                    "missed_reasons_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ltfu",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="No",
                        help_text="If 'Yes', complete the Loss to Follow up form",
                        max_length=15,
                        verbose_name="Has the participant met the protocol criteria for lost to follow up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide further details, if any",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "missed_reasons",
                    models.ManyToManyField(
                        blank=True,
                        related_name="effect_missed_reasons",
                        to="effect_lists.SubjectVisitMissedReasons",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Missed Visit Report",
                "verbose_name_plural": "Missed Visit Report",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(editable=False, max_length=50, null=True, unique=True),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(editable=False, max_length=18, null=True, unique=True),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model.models.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Specimen type"
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "panel",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_lab.panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CurrentSiteManager()),
                ("objects", edc_lab.managers.RequisitionManager()),
            ],
        ),
        migrations.CreateModel(
            name="StudyTreatmentDay14",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "other_antibiotics_first_2w_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "other_drugs_first_2w_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "medicines_rx_d14_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "other_antibiotics_first_2w",
                    models.ManyToManyField(
                        blank=True,
                        related_name="antibiotics_2w",
                        to="effect_lists.Antibiotics",
                        verbose_name="Other antibiotics given during the first 14 days?",
                    ),
                ),
                (
                    "other_drugs_first_2w",
                    models.ManyToManyField(
                        blank=True,
                        to="effect_lists.Drugs",
                        verbose_name="Other drugs/intervention given during the first 14 days?",
                    ),
                ),
                (
                    "prescribed_d14",
                    models.ManyToManyField(
                        blank=True,
                        to="effect_lists.MedicinesDay14",
                        verbose_name="Medicines prescribed on day 14?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Study Treatment: Day 14",
                "verbose_name_plural": "Study Treatment: Day 14",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="StudyTreatment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "lp_completed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete laboratory results",
                        max_length=15,
                        verbose_name="LP completed?",
                    ),
                ),
                (
                    "cm_confirmed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Cryptococcal meningitis confirmed?",
                    ),
                ),
                (
                    "cm_tx_administered",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Cryptococcal meningitis treatment administered?",
                    ),
                ),
                (
                    "cm_tx_given",
                    models.CharField(
                        choices=[
                            ("1w_amb_5fc", "1 week AmB + 5FC"),
                            ("OTHER", "Other, please specify below ..."),
                            ("N/A", "Not applicable (no CM treatment given)"),
                        ],
                        max_length=15,
                        verbose_name="Cryptococcal meningitis treatment given?",
                    ),
                ),
                (
                    "cm_tx_given_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "steroids_administered",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Steroids administered?",
                    ),
                ),
                (
                    "which_steroids",
                    models.CharField(
                        choices=[
                            ("oral_prednisolone", "Oral prednisolone"),
                            ("iv_dexamethasone", "IV Dexamethasone"),
                            ("OTHER", "Other, please specify below ..."),
                            ("N/A", "Not applicable (no steroids administered)"),
                        ],
                        max_length=35,
                        verbose_name="If yes, which steroids where administered?",
                    ),
                ),
                (
                    "which_steroids_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "steroids_course_duration",
                    models.IntegerField(
                        help_text="in days",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Length of steroid course?",
                    ),
                ),
                (
                    "co_trimoxazole",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Co-Trimoxazole given?",
                    ),
                ),
                (
                    "antibiotics",
                    models.ManyToManyField(
                        blank=True, to="effect_lists.Antibiotics", verbose_name="Antibiotics?"
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
                (
                    "tb_tx_given",
                    models.ManyToManyField(
                        blank=True,
                        to="effect_lists.TbTreatments",
                        verbose_name="TB treatment given?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Study Treatment",
                "verbose_name_plural": "Study Treatment",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="SignsAndSymptoms",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "cm_signs_symptoms",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        max_length=15,
                        verbose_name="Has the patient had signs or symptoms of cryptococcal meningitis (CM) since last contact with trial team?",
                    ),
                ),
                (
                    "headache_duration",
                    models.IntegerField(
                        blank=True,
                        help_text="in days",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If patient currently has headache, for what duration have they had it for",
                    ),
                ),
                (
                    "visual_field_loss",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If visual field loss, please provide details ...",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these signs or symptoms Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to any of these signs or symptoms?",
                    ),
                ),
                (
                    "signs_and_symptoms",
                    models.ManyToManyField(
                        blank=True,
                        to="effect_lists.SiSx",
                        verbose_name="Is patient currently experiencing any of the following signs/symptoms?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Signs and Symptoms",
                "verbose_name_plural": "Signs and Symptoms",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Neurological",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "meningism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Meningism?",
                    ),
                ),
                (
                    "papilloedema",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Papilloedema?",
                    ),
                ),
                (
                    "focal_neurologic_deficits_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other focal neurologic deficit, please specify ...",
                    ),
                ),
                (
                    "cn_palsy_left_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other cranial nerve palsy (left), please specify ...",
                    ),
                ),
                (
                    "cn_palsy_right_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other cranial nerve palsy (right), please specify ...",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these neurological symptoms Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to these neurological symptoms?",
                    ),
                ),
                (
                    "focal_neurologic_deficits",
                    models.ManyToManyField(
                        related_name="focal_neurologic_deficits",
                        to="effect_lists.FocalNeurologicDeficits",
                        verbose_name="Does patient have any of the following focal neurologic deficits?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Neurological Symptoms",
                "verbose_name_plural": "Neurological Symptoms",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="MentalStatus",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "recent_seizure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Recent seizure (<72 hours)?",
                    ),
                ),
                (
                    "behaviour_change",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Behaviour change?",
                    ),
                ),
                (
                    "confusion",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Confusion?",
                    ),
                ),
                (
                    "modified_rankin_score",
                    models.CharField(
                        choices=[
                            ("1", "1"),
                            ("2", "2"),
                            ("3", "3"),
                            ("4", "4"),
                            ("5", "5"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        verbose_name="Modified Rankin Score?",
                    ),
                ),
                (
                    "ecog_score",
                    models.CharField(
                        choices=[
                            (
                                "0",
                                "Fully active, able to carry on all pre-disease performance without restriction",
                            ),
                            (
                                "1",
                                "Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work",
                            ),
                            (
                                "2",
                                "Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours ",
                            ),
                            (
                                "3",
                                "Capable of only limited self-care; confined to bed or chair more than 50% of waking hours",
                            ),
                            (
                                "4",
                                "Completely disabled; cannot carry on any self-care; totally confined to bed or chair",
                            ),
                            ("5", "Deceased"),
                        ],
                        max_length=15,
                        verbose_name="ECOG score?",
                    ),
                ),
                (
                    "glasgow_coma_score",
                    models.IntegerField(
                        help_text="/15",
                        validators=[
                            django.core.validators.MinValueValidator(3),
                            django.core.validators.MaxValueValidator(15),
                        ],
                        verbose_name="Glasgow Coma Score?",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these symptoms Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to these symptoms?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mental Status",
                "verbose_name_plural": "Mental Status",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="MedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        null=True, verbose_name="Number of pills left in the bottle"
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "missed_pill_reason",
                    models.ManyToManyField(
                        blank=True,
                        to="effect_lists.NonAdherenceReasons",
                        verbose_name="Reasons for missing study pills",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Medication Adherence",
                "verbose_name_plural": "Medication Adherence",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalVitalSigns",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                ("weight", edc_vitals.models.fields.weight.WeightField(null=True)),
                (
                    "weight_measured_or_est",
                    models.CharField(
                        choices=[
                            ("measured", "Measured (weighed)"),
                            ("estimated", "Estimated"),
                        ],
                        max_length=25,
                        verbose_name="Is the weight estimated or measured?",
                    ),
                ),
                (
                    "heart_rate",
                    models.IntegerField(
                        help_text="BPM",
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(200),
                        ],
                        verbose_name="Heart rate:",
                    ),
                ),
                (
                    "respiratory_rate",
                    models.IntegerField(
                        help_text="breaths/min",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(6),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Respiratory rate:",
                    ),
                ),
                ("temperature", effect_subject.fields.temperature.TemperatureField()),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Are any of the above reportable as Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to any of the above?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Vital Signs",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisitMissed",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        help_text="If deceased, complete the death report",
                        max_length=25,
                        verbose_name="Survival status",
                    ),
                ),
                (
                    "contact_attempted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Not including pre-appointment reminders",
                        max_length=25,
                        verbose_name="Were any attempts made to contact the participant since the expected appointment date?",
                    ),
                ),
                (
                    "contact_attempts_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Not including pre-appointment reminders",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Number of attempts made to contact participantsince the expected appointment date",
                    ),
                ),
                (
                    "contact_attempts_explained",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If contact not made and less than 3 attempts, please explain",
                    ),
                ),
                (
                    "contact_last_date",
                    models.DateField(
                        blank=True,
                        default=edc_utils.date.get_utcnow,
                        null=True,
                        validators=[
                            edc_model.validators.date.date_not_future,
                            edc_protocol.validators.date_not_before_study_start,
                        ],
                        verbose_name="Date of last telephone contact/attempt",
                    ),
                ),
                (
                    "contact_made",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Was contact finally made with the participant?",
                    ),
                ),
                (
                    "missed_reasons_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ltfu",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="No",
                        help_text="If 'Yes', complete the Loss to Follow up form",
                        max_length=15,
                        verbose_name="Has the participant met the protocol criteria for lost to follow up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide further details, if any",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Missed Visit Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                ("visit_code", models.CharField(editable=False, max_length=25, null=True)),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        default="alive",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit"),
                            ("unscheduled", "Unscheduled visit"),
                            ("missed", "Missed visit"),
                        ],
                        help_text="If 'missed', fill in the separate missed visit report",
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            ("patient_unwell_outpatient", "Patient unwell (outpatient)"),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("recurrence_symptoms", "Recurrence of symptoms"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "unschedule_self_referral",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        max_length=25,
                        verbose_name="If 'unschedule', is this a self-referral?",
                    ),
                ),
                (
                    "unschedule_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If 'unschedule', please provide further details, if any",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            ("patient", "Patient"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("N/A", "Not applicable (if missed)"),
                            ("OTHER", "Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "appointment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_appointment.appointment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject visit",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(db_index=True, editable=False, max_length=50, null=True),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(db_index=True, editable=False, max_length=18, null=True),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model.models.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Specimen type"
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "panel",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_lab.panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject requisition",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalStudyTreatmentDay14",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "other_antibiotics_first_2w_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "other_drugs_first_2w_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "medicines_rx_d14_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Study Treatment: Day 14",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalStudyTreatment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "lp_completed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete laboratory results",
                        max_length=15,
                        verbose_name="LP completed?",
                    ),
                ),
                (
                    "cm_confirmed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Cryptococcal meningitis confirmed?",
                    ),
                ),
                (
                    "cm_tx_administered",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Cryptococcal meningitis treatment administered?",
                    ),
                ),
                (
                    "cm_tx_given",
                    models.CharField(
                        choices=[
                            ("1w_amb_5fc", "1 week AmB + 5FC"),
                            ("OTHER", "Other, please specify below ..."),
                            ("N/A", "Not applicable (no CM treatment given)"),
                        ],
                        max_length=15,
                        verbose_name="Cryptococcal meningitis treatment given?",
                    ),
                ),
                (
                    "cm_tx_given_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "steroids_administered",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Steroids administered?",
                    ),
                ),
                (
                    "which_steroids",
                    models.CharField(
                        choices=[
                            ("oral_prednisolone", "Oral prednisolone"),
                            ("iv_dexamethasone", "IV Dexamethasone"),
                            ("OTHER", "Other, please specify below ..."),
                            ("N/A", "Not applicable (no steroids administered)"),
                        ],
                        max_length=35,
                        verbose_name="If yes, which steroids where administered?",
                    ),
                ),
                (
                    "which_steroids_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "steroids_course_duration",
                    models.IntegerField(
                        help_text="in days",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Length of steroid course?",
                    ),
                ),
                (
                    "co_trimoxazole",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Co-Trimoxazole given?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Study Treatment",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSignsAndSymptoms",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "cm_signs_symptoms",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        max_length=15,
                        verbose_name="Has the patient had signs or symptoms of cryptococcal meningitis (CM) since last contact with trial team?",
                    ),
                ),
                (
                    "headache_duration",
                    models.IntegerField(
                        blank=True,
                        help_text="in days",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If patient currently has headache, for what duration have they had it for",
                    ),
                ),
                (
                    "visual_field_loss",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If visual field loss, please provide details ...",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these signs or symptoms Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to any of these signs or symptoms?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Signs and Symptoms",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalNeurological",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "meningism",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Meningism?",
                    ),
                ),
                (
                    "papilloedema",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Papilloedema?",
                    ),
                ),
                (
                    "focal_neurologic_deficits_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other focal neurologic deficit, please specify ...",
                    ),
                ),
                (
                    "cn_palsy_left_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other cranial nerve palsy (left), please specify ...",
                    ),
                ),
                (
                    "cn_palsy_right_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other cranial nerve palsy (right), please specify ...",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these neurological symptoms Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to these neurological symptoms?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Neurological Symptoms",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMentalStatus",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "recent_seizure",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Recent seizure (<72 hours)?",
                    ),
                ),
                (
                    "behaviour_change",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Behaviour change?",
                    ),
                ),
                (
                    "confusion",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Confusion?",
                    ),
                ),
                (
                    "modified_rankin_score",
                    models.CharField(
                        choices=[
                            ("1", "1"),
                            ("2", "2"),
                            ("3", "3"),
                            ("4", "4"),
                            ("5", "5"),
                            ("not_done", "Not done"),
                        ],
                        max_length=15,
                        verbose_name="Modified Rankin Score?",
                    ),
                ),
                (
                    "ecog_score",
                    models.CharField(
                        choices=[
                            (
                                "0",
                                "Fully active, able to carry on all pre-disease performance without restriction",
                            ),
                            (
                                "1",
                                "Restricted in physically strenuous activity but ambulatory and able to carry out work of a light or sedentary nature, e.g., light house work, office work",
                            ),
                            (
                                "2",
                                "Ambulatory and capable of all self-care but unable to carry out any work activities; up and about more than 50% of waking hours ",
                            ),
                            (
                                "3",
                                "Capable of only limited self-care; confined to bed or chair more than 50% of waking hours",
                            ),
                            (
                                "4",
                                "Completely disabled; cannot carry on any self-care; totally confined to bed or chair",
                            ),
                            ("5", "Deceased"),
                        ],
                        max_length=15,
                        verbose_name="ECOG score?",
                    ),
                ),
                (
                    "glasgow_coma_score",
                    models.IntegerField(
                        help_text="/15",
                        validators=[
                            django.core.validators.MinValueValidator(3),
                            django.core.validators.MaxValueValidator(15),
                        ],
                        verbose_name="Glasgow Coma Score?",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these symptoms Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to these symptoms?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Mental Status",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "visual_score_slider",
                    models.CharField(help_text="%", max_length=3, verbose_name="Visual score"),
                ),
                (
                    "visual_score_confirmed",
                    models.IntegerField(
                        help_text="%",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                        verbose_name="<B><font color='orange'>Interviewer</font></B>: please confirm the score indicated from above.",
                    ),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(
                        null=True, verbose_name="Number of pills left in the bottle"
                    ),
                ),
                (
                    "other_missed_pill_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Medication Adherence",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDiagnoses",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "gi_side_effects",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report where appropriate",
                        max_length=15,
                        verbose_name="Has the patient experienced any gastrointestinal side effects?",
                    ),
                ),
                (
                    "gi_side_effects_details",
                    models.TextField(
                        blank=True, null=True, verbose_name="If yes, please give details"
                    ),
                ),
                (
                    "has_diagnoses",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are there any new significant diagnoses to report since last visit?",
                    ),
                ),
                (
                    "diagnoses_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these diagnoses Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to any of these diagnoses?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Significant Diagnoses",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalClinicalNote",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "has_comment",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are there any comments on the clinical care or assessment plan",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True, verbose_name="Comments")),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinical Note",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalClinicalAssessment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "who_speak_to",
                    models.CharField(
                        choices=[
                            ("patient", "Patient"),
                            ("next_of_kin", "Next of kin"),
                            ("OTHER", "Other"),
                        ],
                        max_length=15,
                        verbose_name="Who did you speak to?",
                    ),
                ),
                (
                    "who_speak_to_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "assessment_method",
                    models.CharField(
                        choices=[("telephone", "Telephone"), ("in_person", "In person")],
                        max_length=15,
                        verbose_name="Was this a telephone follow up or an in person visit?",
                    ),
                ),
                (
                    "patient_hospitalized",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Has the patient been hospitalized",
                    ),
                ),
                (
                    "patient_status",
                    models.CharField(
                        choices=[
                            ("alive_well", "Alive and well"),
                            ("alive_unwell", "Alive, but unwell"),
                            ("dead", "Dead"),
                        ],
                        max_length=15,
                        verbose_name="Patient status?",
                    ),
                ),
                (
                    "adherence_counselling",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Was adherence counselling given?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinical Assessment",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalChestXray",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "chest_xray",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has a chest x-ray been carried out?",
                    ),
                ),
                (
                    "chest_xray_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="If yes, what date was it performed?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Chest X-ray",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsRft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "creatinine_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Creatinine",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "creatinine_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "creatinine_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "creatinine_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "creatinine_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "egfr_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "egfr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mL/min/1.73m2", "mL/min/1.73m2")],
                        default="mL/min/1.73m2",
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "egfr_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "egfr_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "egfr_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "urea_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Urea (BUN)",
                    ),
                ),
                (
                    "urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "urea_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "urea_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "urea_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "urea_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "uric_acid_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Uric Acid",
                    ),
                ),
                (
                    "uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)"), ("mg/dL", "mg/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "uric_acid_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "uric_acid_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "uric_acid_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "uric_acid_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: RFT",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsLft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "albumin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum albumin",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "albumin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "albumin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "albumin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "albumin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alp_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALP",
                    ),
                ),
                (
                    "alp_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alp_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alp_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alp_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alp_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALT",
                    ),
                ),
                (
                    "alt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ast_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="AST",
                    ),
                ),
                (
                    "ast_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ast_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ast_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ast_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ast_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "amylase_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum Amylase",
                    ),
                ),
                (
                    "amylase_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "amylase_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "amylase_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "amylase_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "amylase_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ggt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="GGT",
                    ),
                ),
                (
                    "ggt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ggt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ggt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ggt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ggt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: LFT",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsFbc",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "haemoglobin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Haemoglobin",
                    ),
                ),
                (
                    "haemoglobin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "haemoglobin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "haemoglobin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "haemoglobin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "haemoglobin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "hct_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Hematocrit",
                    ),
                ),
                (
                    "hct_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hct_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hct_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hct_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "hct_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mch_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCH",
                    ),
                ),
                (
                    "mch_units",
                    models.CharField(
                        blank=True,
                        choices=[("pg/cell", "pg/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mch_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mch_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mch_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mch_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mchc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCHC",
                    ),
                ),
                (
                    "mchc_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mchc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mchc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mchc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mchc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mcv_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCV",
                    ),
                ),
                (
                    "mcv_units",
                    models.CharField(
                        blank=True,
                        choices=[("fL/cell", "fL/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mcv_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mcv_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mcv_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mcv_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "platelets_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="Platelets",
                    ),
                ),
                (
                    "platelets_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "platelets_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "platelets_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "platelets_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "platelets_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "rbc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999999.0),
                        ],
                        verbose_name="Red blood cell count",
                    ),
                ),
                (
                    "rbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm^3")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "rbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "rbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "rbc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "rbc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "wbc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="WBC",
                    ),
                ),
                (
                    "wbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "wbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "wbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "wbc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "wbc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: FBC",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalArvTreatment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "on_arv_regimen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If ART regimen is on hold, answer yes and clarify below",
                        max_length=15,
                        verbose_name="Is the patient currently on an ART regimen?",
                    ),
                ),
                (
                    "adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="In the opinion of the clinican, is the patient at least 90% adherent",
                        max_length=15,
                        verbose_name="If yes, on an ART regimen, has the patient adhered to this ART regimen?",
                    ),
                ),
                (
                    "arv_regimen_stopped",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has ART been held/stopped this clinical episode?",
                    ),
                ),
                (
                    "arv_regimen_stopped_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date held or stopped?"
                    ),
                ),
                (
                    "arv_regimen_changed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient's ART regimen changed since the last study assessment",
                    ),
                ),
                (
                    "arv_regimen_start_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Start date of the changed ART regimen?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Required if on an ART regimen",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_lists.arvregimens",
                        verbose_name="Current ART regimen?",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ARV Treatment",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Diagnoses",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "gi_side_effects",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report where appropriate",
                        max_length=15,
                        verbose_name="Has the patient experienced any gastrointestinal side effects?",
                    ),
                ),
                (
                    "gi_side_effects_details",
                    models.TextField(
                        blank=True, null=True, verbose_name="If yes, please give details"
                    ),
                ),
                (
                    "has_diagnoses",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are there any new significant diagnoses to report since last visit?",
                    ),
                ),
                (
                    "diagnoses_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "reportable_as_ae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are any of these diagnoses Grade 3 or above?",
                    ),
                ),
                (
                    "patient_admitted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, complete SAE report",
                        max_length=15,
                        verbose_name="Has the patient been admitted due to any of these diagnoses?",
                    ),
                ),
                (
                    "diagnoses",
                    models.ManyToManyField(
                        to="effect_lists.Dx",
                        verbose_name="Please select all diagnoses that are relevant",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Significant Diagnoses",
                "verbose_name_plural": "Significant Diagnoses",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ClinicalNote",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "has_comment",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are there any comments on the clinical care or assessment plan",
                    ),
                ),
                ("comments", models.TextField(blank=True, null=True, verbose_name="Comments")),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinical Note",
                "verbose_name_plural": "Clinical Note",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ClinicalAssessment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "who_speak_to",
                    models.CharField(
                        choices=[
                            ("patient", "Patient"),
                            ("next_of_kin", "Next of kin"),
                            ("OTHER", "Other"),
                        ],
                        max_length=15,
                        verbose_name="Who did you speak to?",
                    ),
                ),
                (
                    "who_speak_to_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "assessment_method",
                    models.CharField(
                        choices=[("telephone", "Telephone"), ("in_person", "In person")],
                        max_length=15,
                        verbose_name="Was this a telephone follow up or an in person visit?",
                    ),
                ),
                (
                    "patient_hospitalized",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Has the patient been hospitalized",
                    ),
                ),
                (
                    "patient_status",
                    models.CharField(
                        choices=[
                            ("alive_well", "Alive and well"),
                            ("alive_unwell", "Alive, but unwell"),
                            ("dead", "Dead"),
                        ],
                        max_length=15,
                        verbose_name="Patient status?",
                    ),
                ),
                (
                    "adherence_counselling",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        max_length=15,
                        verbose_name="Was adherence counselling given?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinical Assessment",
                "verbose_name_plural": "Clinical Assessment",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ChestXray",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "chest_xray",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has a chest x-ray been carried out?",
                    ),
                ),
                (
                    "chest_xray_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="If yes, what date was it performed?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True, null=True, verbose_name="Any additional comment"
                    ),
                ),
                (
                    "chest_xray_results",
                    models.ManyToManyField(
                        blank=True,
                        to="effect_lists.XRayResults",
                        verbose_name="Chest x-ray result",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Chest X-ray",
                "verbose_name_plural": "Chest X-ray",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsRft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "creatinine_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Creatinine",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("umol/L", "μmol/L (micromoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "creatinine_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "creatinine_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "creatinine_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "creatinine_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "egfr_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "egfr_units",
                    models.CharField(
                        blank=True,
                        choices=[("mL/min/1.73m2", "mL/min/1.73m2")],
                        default="mL/min/1.73m2",
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "egfr_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "egfr_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "egfr_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "urea_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Urea (BUN)",
                    ),
                ),
                (
                    "urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "urea_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "urea_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "urea_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "urea_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "uric_acid_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Uric Acid",
                    ),
                ),
                (
                    "uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L (millimoles/L)"), ("mg/dL", "mg/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "uric_acid_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "uric_acid_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "uric_acid_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "uric_acid_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: RFT",
                "verbose_name_plural": "Blood Results: RFT",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsLft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "albumin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum albumin",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "albumin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "albumin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "albumin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "albumin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alp_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALP",
                    ),
                ),
                (
                    "alp_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alp_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alp_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alp_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alp_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "alt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="ALT",
                    ),
                ),
                (
                    "alt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "alt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ast_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="AST",
                    ),
                ),
                (
                    "ast_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ast_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ast_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ast_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ast_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "amylase_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(9999.9),
                        ],
                        verbose_name="Serum Amylase",
                    ),
                ),
                (
                    "amylase_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "amylase_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "amylase_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "amylase_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "amylase_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "ggt_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="GGT",
                    ),
                ),
                (
                    "ggt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "U/L")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ggt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ggt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ggt_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "ggt_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: LFT",
                "verbose_name_plural": "Blood Results: LFT",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsFbc",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "haemoglobin_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Haemoglobin",
                    ),
                ),
                (
                    "haemoglobin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "haemoglobin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "haemoglobin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "haemoglobin_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "haemoglobin_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "hct_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999.0),
                        ],
                        verbose_name="Hematocrit",
                    ),
                ),
                (
                    "hct_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hct_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hct_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hct_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "hct_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mch_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCH",
                    ),
                ),
                (
                    "mch_units",
                    models.CharField(
                        blank=True,
                        choices=[("pg/cell", "pg/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mch_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mch_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mch_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mch_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mchc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCHC",
                    ),
                ),
                (
                    "mchc_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mchc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mchc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mchc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mchc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "mcv_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="MCV",
                    ),
                ),
                (
                    "mcv_units",
                    models.CharField(
                        blank=True,
                        choices=[("fL/cell", "fL/cell")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "mcv_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "mcv_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "mcv_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "mcv_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "platelets_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="Platelets",
                    ),
                ),
                (
                    "platelets_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "platelets_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "platelets_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "platelets_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "platelets_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "rbc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999999.0),
                        ],
                        verbose_name="Red blood cell count",
                    ),
                ),
                (
                    "rbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm^3")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "rbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "rbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "rbc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "rbc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "wbc_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=8,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="WBC",
                    ),
                ),
                (
                    "wbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm<sup>3</sup>")],
                        max_length=15,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "wbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "wbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "wbc_grade",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (0, "Not graded"),
                            (1, "Grade 1"),
                            (2, "Grade 2"),
                            (3, "Grade 3"),
                            (4, "Grade 4"),
                            (5, "Grade 5"),
                        ],
                        null=True,
                        verbose_name="Grade",
                    ),
                ),
                (
                    "wbc_grade_description",
                    models.CharField(
                        blank=True, max_length=250, null=True, verbose_name="Grade description"
                    ),
                ),
                (
                    "assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="effect_subject.subjectrequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: FBC",
                "verbose_name_plural": "Blood Results: FBC",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="ArvTreatment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "on_arv_regimen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If ART regimen is on hold, answer yes and clarify below",
                        max_length=15,
                        verbose_name="Is the patient currently on an ART regimen?",
                    ),
                ),
                (
                    "adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="In the opinion of the clinican, is the patient at least 90% adherent",
                        max_length=15,
                        verbose_name="If yes, on an ART regimen, has the patient adhered to this ART regimen?",
                    ),
                ),
                (
                    "arv_regimen_stopped",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has ART been held/stopped this clinical episode?",
                    ),
                ),
                (
                    "arv_regimen_stopped_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date held or stopped?"
                    ),
                ),
                (
                    "arv_regimen_changed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has the patient's ART regimen changed since the last study assessment",
                    ),
                ),
                (
                    "arv_regimen_start_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Start date of the changed ART regimen?",
                    ),
                ),
                (
                    "arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        help_text="Required if on an ART regimen",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_lists.arvregimens",
                        verbose_name="Current ART regimen?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "ARV Treatment",
                "verbose_name_plural": "ARV Treatment",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="vitalsigns",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_93a0c7_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subjectvisitmissed",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_1e9ef7_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subjectvisit",
            index=models.Index(
                fields=[
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ],
                name="effect_subj_subject_505860_idx",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="subjectvisit",
            unique_together={
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                ),
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "report_datetime",
                ),
            },
        ),
        migrations.AlterUniqueTogether(
            name="subjectrequisition",
            unique_together={("panel", "subject_visit")},
        ),
        migrations.AddIndex(
            model_name="studytreatmentday14",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_e896d0_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="studytreatment",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_4b8a9e_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="signsandsymptoms",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_9edf0f_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="neurological",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_29e696_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="mentalstatus",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_8477f6_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="medicationadherence",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_53f67a_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="diagnoses",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_b0c15d_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="clinicalnote",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_8b519f_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="clinicalassessment",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_e35b24_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="chestxray",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_85bfb1_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultsrft",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_60cd73_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultslft",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_f36318_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultsfbc",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_b87d19_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="arvtreatment",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_8953bc_idx"
            ),
        ),
    ]
