/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.LdbSqlByteArrayOutputStream;
import com.datapps.linkoopdb.jdbc.lib.ReaderInputStream;
import com.datapps.linkoopdb.jdbc.lib.StringConverter;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends BufferedOutputStream
implements DataOutput {
    byte[] tempBuffer = new byte[8];

    public DataOutputStream(OutputStream stream) {
        super(stream, 8);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        int count = 0;
        this.tempBuffer[count++] = (byte)(v >>> 24);
        this.tempBuffer[count++] = (byte)(v >>> 16);
        this.tempBuffer[count++] = (byte)(v >>> 8);
        this.tempBuffer[count++] = (byte)v;
        this.write(this.tempBuffer, 0, count);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.writeInt((int)(v >>> 32));
        this.writeInt((int)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        int count = 0;
        this.tempBuffer[count++] = (byte)(v >>> 8);
        this.tempBuffer[count++] = (byte)v;
        this.write(this.tempBuffer, 0, count);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            int count = 0;
            this.tempBuffer[count++] = (byte)(v >>> 8);
            this.tempBuffer[count++] = (byte)v;
            this.write(this.tempBuffer, 0, count);
        }
    }

    public void writeChars(char[] c) throws IOException {
        this.writeChars(c, c.length);
    }

    public void writeChars(char[] c, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            char v = c[i];
            int count = 0;
            this.tempBuffer[count++] = (byte)(v >>> 8);
            this.tempBuffer[count++] = (byte)v;
            this.write(this.tempBuffer, 0, count);
        }
    }

    public long write(Reader reader, long length) throws IOException {
        ReaderInputStream inputStream = new ReaderInputStream(reader);
        return this.write(inputStream, length * 2L) / 2L;
    }

    public long write(InputStream inputStream, long length) throws IOException {
        byte[] data = new byte[1024];
        long totalCount = 0L;
        while (true) {
            long count;
            if ((count = length - totalCount) > (long)data.length) {
                count = data.length;
            }
            if ((count = (long)inputStream.read(data, 0, (int)count)) < 1L) break;
            this.write(data, 0, (int)count);
            totalCount += count;
        }
        return totalCount;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        int val = v ? 1 : 0;
        this.write(val);
    }

    @Override
    public void writeShort(int v) throws IOException {
        int count = 0;
        this.tempBuffer[count++] = (byte)(v >> 8);
        this.tempBuffer[count++] = (byte)v;
        this.write(this.tempBuffer, 0, count);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int len = str.length();
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        int bytecount = StringConverter.getUTFSize(str);
        if (bytecount > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeChar(bytecount);
        LdbSqlByteArrayOutputStream bao = new LdbSqlByteArrayOutputStream(bytecount);
        StringConverter.stringToUTFBytes(str, bao);
        this.write(bao.getBuffer(), 0, bao.size());
    }
}

