"""
    Configure ``setup.py`` for digicloud cli app.
"""
from setuptools import setup, find_packages


try:
    LONG_DESCRIPTION = open('README.md', 'rt').read()
except IOError:
    LONG_DESCRIPTION = ''

setup(
    name='digicloud',
    version='2.5.5',
    description='DigiCloud CLI',

    long_description=LONG_DESCRIPTION,

    author='Arash Shams',
    author_email='a.shams@digikala.com',
    url='https://digicloud.ir',
    download_url='',
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Intended Audience :: Developers',
        'Environment :: Console',
    ],
    platforms=['Any'],
    scripts=[],
    provides=[],
    install_requires=[
        'cliff',
        'rich',
        'requests',
        'marshmallow',
        'setuptools',
        'tzlocal',
        'pytz',
        'sentry-sdk',
    ],
    extras_require={
        'dev': [
            'pytest==6.1.0'
        ]
    },
    packages=find_packages(exclude=["tests"]),
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'digicloud = digicloud.main:main'
        ],
        'digicloud.formatters.list': [
            'rich = digicloud.cli.formatters:RichFormatter',
            'table = cliff.formatters.table:TableFormatter',
            'json = cliff.formatters.json_format:JSONFormatter',
            'yaml = cliff.formatters.yaml_format:YAMLFormatter',
            'value = cliff.formatters.value:ValueFormatter',
        ],
        'digicloud.formatters.details': [
            'rich = digicloud.cli.formatters:RichFormatter',
            'table = cliff.formatters.table:TableFormatter',
            'json = cliff.formatters.json_format:JSONFormatter',
            'yaml = cliff.formatters.yaml_format:YAMLFormatter',
            'value = cliff.formatters.value:ValueFormatter',
        ],
        'digicloud.cli': [
            'explain = digicloud.commands.explain:Explain',
            'config = digicloud.commands.config:Config',
            'account_login = digicloud.commands.account:Login',
            'account_logout = digicloud.commands.account:Logout',
            'account_current = digicloud.commands.account:CurrentUser',
            'namespace_current = digicloud.commands.namespace:CurrentNamespace',
            'namespace_select = digicloud.commands.namespace:SelectNamespace',
            'namespace_create = digicloud.commands.namespace:CreateNamespace',
            'namespace_leave = digicloud.commands.namespace:LeaveNamespace',
            'namespace_list = digicloud.commands.namespace:ListNamespace',
            'namespace_show = digicloud.commands.namespace:ShowNamespace',
            'namespace_member_list = digicloud.commands.namespace:ListNamespaceMember',
            'namespace_member_add = digicloud.commands.namespace:InviteMember',
            'namespace_invitation_accept = digicloud.commands.namespace:AcceptInvitation',
            'namespace_member_delete = digicloud.commands.namespace:DeleteNamespaceMember',
            'namespace_quota_list = digicloud.commands.namespace:ListQuota',
            'namespace_quota_request = digicloud.commands.quota:RequestMoreQuota',
            'namespace_quota_request_list = digicloud.commands.quota:QuotaRequestList',
            'namespace_invitation_list = digicloud.commands.namespace:ListUserInvitations',
            'instance_type_list = digicloud.commands.instance_type:ListInstanceType',
            'instance_type_show = digicloud.commands.instance_type:ShowInstanceType',
            'public_ip_list = digicloud.commands.access:ListPublicIp',
            'public_ip_show = digicloud.commands.access:ShowPublicIp',
            'public_ip_create = digicloud.commands.access:CreatePublicIp',
            'public_ip_delete = digicloud.commands.access:DeletePublicIp',
            'public_ip_associate = digicloud.commands.access:AssociatePublicIp',
            'public_ip_revoke = digicloud.commands.access:RevokePublicIp',
            'image_list = digicloud.commands.image:ListImage',
            'image_show = digicloud.commands.image:ShowImage',
            'instance_list = digicloud.commands.instance:ListInstance',
            'instance_create = digicloud.commands.instance:CreateInstance',
            'instance_delete = digicloud.commands.instance:DeleteInstance',
            'instance_update = digicloud.commands.instance:UpdateInstance',
            'instance_resize = digicloud.commands.instance:ResizeInstance',
            'instance_start = digicloud.commands.instance_operations:StartInstance',
            'instance_stop = digicloud.commands.instance_operations:StopInstance',
            'instance_suspend = digicloud.commands.instance_operations:SuspendInstance',
            'instance_resume = digicloud.commands.instance_operations:ResumeInstance',
            'instance_reboot = digicloud.commands.instance_operations:RebootInstance',
            'instance_show = digicloud.commands.instance:ShowInstance',
            'instance_volume_list = digicloud.commands.instance:ListInstanceVolume',
            'instance_volume_show = digicloud.commands.instance:ShowInstanceVolume',
            'instance_volume_attach = digicloud.commands.instance:AttachInstanceVolume',
            'instance_volume_detach = digicloud.commands.instance:DetachInstanceVolume',
            'instance_interface_list = digicloud.commands.instance:ListInstanceInterface',
            'instance_interface_attach = digicloud.commands.instance:AttachInterface',
            'instance_interface_detach = digicloud.commands.instance:DetachInterface',
            'instance_firewall_list = digicloud.commands.instance:ListFirewall',
            'instance_firewall_add = digicloud.commands.instance:AddFirewall',
            'instance_firewall_remove = digicloud.commands.instance:RemoveFirewall',
            'instance_snapshot_list = digicloud.commands.instance:ListInstanceSnapshot',
            'snapshot_create = digicloud.commands.snapshot:CreateSnapshot',
            'snapshot_list = digicloud.commands.snapshot:ListSnapshot',
            'snapshot_show = digicloud.commands.snapshot:ShowSnapshot',
            'snapshot_delete = digicloud.commands.snapshot:DeleteSnapshot',
            'snapshot_update = digicloud.commands.snapshot:UpdateSnapshot',
            'volume_list = digicloud.commands.volume:ListVolume',
            'volume_show = digicloud.commands.volume:ShowVolume',
            'volume_delete = digicloud.commands.volume:DeleteVolume',
            'volume_create = digicloud.commands.volume:CreateVolume',
            'volume_update = digicloud.commands.volume:UpdateVolume',
            'volume_attach = digicloud.commands.volume:AttachVolume',
            'volume_detach = digicloud.commands.volume:DetachVolume',
            'network_list = digicloud.commands.network:ListNetwork',
            'network_show = digicloud.commands.network:ShowNetwork',
            'network_delete = digicloud.commands.network:DeleteNetwork',
            'network_create = digicloud.commands.network:CreateNetwork',
            'network_update = digicloud.commands.network:UpdateNetwork',
            'network_port_list = digicloud.commands.network:ListNetworkPorts',
            'firewall_list = digicloud.commands.security:ListFirewall',
            'firewall_show = digicloud.commands.security:ShowFirewall',
            'firewall_create = digicloud.commands.security:CreateFirewall',
            'firewall_delete = digicloud.commands.security:DeleteFirewall',
            'firewall_update = digicloud.commands.security:UpdateFirewall',
            'firewall_rule_list = digicloud.commands.security:ListFirewallRule',
            'firewall_rule_show = digicloud.commands.security:ShowFirewallRule',
            'firewall_rule_create = digicloud.commands.security:CreateFirewallRule',
            'firewall_rule_delete = digicloud.commands.security:DeleteFirewallRule',
            'subnet_create = digicloud.commands.subnet:CreateSubnet',
            'subnet_list = digicloud.commands.subnet:ListSubnet',
            'subnet_show = digicloud.commands.subnet:ShowSubnet',
            'subnet_delete = digicloud.commands.subnet:DeleteSubnet',
            'subnet_update = digicloud.commands.subnet:UpdateSubnet',
            'ssh_key_list = digicloud.commands.ssh_key:ListSSHKey',
            'ssh_key_show = digicloud.commands.ssh_key:ShowSSHKey',
            'ssh_key_delete = digicloud.commands.ssh_key:DeleteSSHKey',
            'ssh_key_create = digicloud.commands.ssh_key:CreateSSHKey',
            'router_list = digicloud.commands.router:ListRouter',
            'router_show = digicloud.commands.router:ShowRouter',
            'router_update = digicloud.commands.router:UpdateRouter',
            'router_delete = digicloud.commands.router:DeleteRouter',
            'router_create = digicloud.commands.router:CreateRouter',
            'router_interface_list = digicloud.commands.router:ListRouterInterface',
            'router_interface_show = digicloud.commands.router:ShowRouterInterface',
            'router_interface_add = digicloud.commands.router:AddRouterInterface',
            'router_interface_remove = digicloud.commands.router:RemoveRouterInterface',
            'router_external_add = digicloud.commands.router:AddRouterExternal',
            'router_external_remove = digicloud.commands.router:RemoveRouterExternal',
            'router_static_list = digicloud.commands.router:ListRouterStatic',
            'router_static_add = digicloud.commands.router:AddRouterStatic',
            'router_static_delete = digicloud.commands.router:DeleteRouterStatic',
            'region_list = digicloud.commands.region:ListRegions',
            'region_select = digicloud.commands.region:SelectRegion',
            'region_current = digicloud.commands.region:CurrentRegion',
            'vpn_external_create = digicloud.commands.vpn:CreateExternalVpnConnection',
            'vpn_external_list = digicloud.commands.vpn:ListExternalVpnConnections',
            'vpn_external_delete = digicloud.commands.vpn:DeleteExternalVpnConnection',
            'vpn_external_update = digicloud.commands.vpn:UpdateExternalVpnConnection',
            'vpn_external_show = digicloud.commands.vpn:ShowExternalVpnConnections',

            'edge_domain_list = digicloud.commands.edge:ListDomain',
            'edge_domain_create = digicloud.commands.edge:CreateDomain',
            'edge_domain_delete = digicloud.commands.edge:DeleteDomain',
            'edge_domain_show = digicloud.commands.edge:ShowDomain',
            'edge_record_list = digicloud.commands.edge:ListRecord',
            'edge_record_show = digicloud.commands.edge:ShowRecord',
            'edge_record_create = digicloud.commands.edge:CreateRecord',
            'edge_record_delete = digicloud.commands.edge:DeleteRecord',
            'edge_record_update = digicloud.commands.edge:UpdateRecord',
            'edge_upstream_list = digicloud.commands.edge:ListUpstream',
            'edge_upstream_show = digicloud.commands.edge:ShowUpstream',
            'edge_upstream_create = digicloud.commands.edge:CreateUpstream',
            'edge_upstream_delete = digicloud.commands.edge:DeleteUpstream',
            'edge_upstream_update = digicloud.commands.edge:UpdateUpstream',
            'edge_upstream_server_list = digicloud.commands.edge:ListUpstreamServer',
            'edge_upstream_server_show = digicloud.commands.edge:ShowUpstreamServer',
            'edge_upstream_server_create = digicloud.commands.edge:CreateUpstreamServer',
            'edge_upstream_server_delete = digicloud.commands.edge:DeleteUpstreamServer',
            'edge_upstream_server_update = digicloud.commands.edge:UpdateUpstreamServer',
            'edge_ssl_show = digicloud.commands.edge:ShowSSL',
            'edge_ssl_update = digicloud.commands.edge:UpdateSSL',
            'edge_location_list = digicloud.commands.edge:ListLocation',
            'edge_location_show = digicloud.commands.edge:ShowLocation',
            'edge_location_create = digicloud.commands.edge:CreateLocation',
            'edge_location_delete = digicloud.commands.edge:DeleteLocation',
            'edge_location_update = digicloud.commands.edge:UpdateLocation',
            'edge_firewall_list = digicloud.commands.edge:ListFirewall',
            'edge_firewall_show = digicloud.commands.edge:ShowFirewall',
            'edge_firewall_create = digicloud.commands.edge:CreateFirewall',
            'edge_firewall_delete = digicloud.commands.edge:DeleteFirewall',
            'edge_firewall_update = digicloud.commands.edge:UpdateFirewall',
            'edge_cache_zone_list = digicloud.commands.edge:ListCacheZone',
            'loadbalancer_create = digicloud.commands.load_balancer:CreateLoadBalancer',
            'loadbalancer_list = digicloud.commands.load_balancer:ListLoadBalancer',
            'loadbalancer_delete = digicloud.commands.load_balancer:DeleteLoadBalancer',
            'loadbalancer_update = digicloud.commands.load_balancer:UpdateLoadBalancer',
            'loadbalancer_show = digicloud.commands.load_balancer:ShowLoadBalancer',
            'loadbalancer_backend_create = digicloud.commands.load_balancer:CreateBackend',
            'loadbalancer_backend_delete = digicloud.commands.load_balancer:DeleteBackend',
            'loadbalancer_backend_list = digicloud.commands.load_balancer:ListBackend',
            'loadbalancer_frontend_create = digicloud.commands.load_balancer:CreateFrontend',
            'loadbalancer_frontend_delete = digicloud.commands.load_balancer:DeleteFrontend',
            'loadbalancer_frontend_list = digicloud.commands.load_balancer:ListFrontend',
            'loadbalancer_backend_member_add = digicloud.commands.load_balancer:AddBackendMember',
            'loadbalancer_backend_member_list = digicloud.commands.load_balancer:ListBackendMember',
            'loadbalancer_backend_member_remove = digicloud.commands.load_balancer:DeleteBackendMember',
            'loadbalancer_backend_health_check_list = digicloud.commands.load_balancer:ListHealthCheck',
            'loadbalancer_backend_health_check_create = digicloud.commands.load_balancer:CreateHealthCheck',
            'loadbalancer_backend_health_check_delete = digicloud.commands.load_balancer:DeleteHealthCheck',
        ],
    },
    zip_safe=False,
)
