# coding: utf-8

"""
    BlackFox

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from blackfox_restapi.configuration import Configuration


class AnnTrainingConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'batch_size': 'int',
        'dataset_id': 'str',
        'input_ranges': 'list[Range]',
        'output_layer': 'AnnLayerConfig',
        'hidden_layer_configs': 'list[AnnHiddenLayerConfig]',
        'training_algorithm': 'NeuralNetworkTrainingAlgorithm',
        'max_epoch': 'int',
        'cross_validation': 'bool',
        'validation_split': 'float',
        'random_seed': 'int'
    }

    attribute_map = {
        'batch_size': 'batchSize',
        'dataset_id': 'datasetId',
        'input_ranges': 'inputRanges',
        'output_layer': 'outputLayer',
        'hidden_layer_configs': 'hiddenLayerConfigs',
        'training_algorithm': 'trainingAlgorithm',
        'max_epoch': 'maxEpoch',
        'cross_validation': 'crossValidation',
        'validation_split': 'validationSplit',
        'random_seed': 'randomSeed'
    }

    def __init__(self, batch_size=512, dataset_id=None, input_ranges=None, output_layer=None, hidden_layer_configs=None, training_algorithm=None, max_epoch=3000, cross_validation=False, validation_split=0.2, random_seed=300, local_vars_configuration=None):  # noqa: E501
        """AnnTrainingConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._batch_size = None
        self._dataset_id = None
        self._input_ranges = None
        self._output_layer = None
        self._hidden_layer_configs = None
        self._training_algorithm = None
        self._max_epoch = None
        self._cross_validation = None
        self._validation_split = None
        self._random_seed = None
        self.discriminator = None

        if batch_size is not None:
            self.batch_size = batch_size
        self.dataset_id = dataset_id
        self.input_ranges = input_ranges
        self.output_layer = output_layer
        self.hidden_layer_configs = hidden_layer_configs
        if training_algorithm is not None:
            self.training_algorithm = training_algorithm
        self.max_epoch = max_epoch
        if cross_validation is not None:
            self.cross_validation = cross_validation
        self.validation_split = validation_split
        self.random_seed = random_seed

    @property
    def batch_size(self):
        """Gets the batch_size of this AnnTrainingConfig.  # noqa: E501

        Training batch size  # noqa: E501

        :return: The batch_size of this AnnTrainingConfig.  # noqa: E501
        :rtype: int
        """
        return self._batch_size

    @batch_size.setter
    def batch_size(self, batch_size):
        """Sets the batch_size of this AnnTrainingConfig.

        Training batch size  # noqa: E501

        :param batch_size: The batch_size of this AnnTrainingConfig.  # noqa: E501
        :type: int
        """

        self._batch_size = batch_size

    @property
    def dataset_id(self):
        """Gets the dataset_id of this AnnTrainingConfig.  # noqa: E501

        Data set id on which to train network  # noqa: E501

        :return: The dataset_id of this AnnTrainingConfig.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this AnnTrainingConfig.

        Data set id on which to train network  # noqa: E501

        :param dataset_id: The dataset_id of this AnnTrainingConfig.  # noqa: E501
        :type: str
        """

        self._dataset_id = dataset_id

    @property
    def input_ranges(self):
        """Gets the input_ranges of this AnnTrainingConfig.  # noqa: E501

        Define min and max value for each input column(feature)  # noqa: E501

        :return: The input_ranges of this AnnTrainingConfig.  # noqa: E501
        :rtype: list[Range]
        """
        return self._input_ranges

    @input_ranges.setter
    def input_ranges(self, input_ranges):
        """Sets the input_ranges of this AnnTrainingConfig.

        Define min and max value for each input column(feature)  # noqa: E501

        :param input_ranges: The input_ranges of this AnnTrainingConfig.  # noqa: E501
        :type: list[Range]
        """

        self._input_ranges = input_ranges

    @property
    def output_layer(self):
        """Gets the output_layer of this AnnTrainingConfig.  # noqa: E501

        Define min and max value for each output column(feature), and output activation function  # noqa: E501

        :return: The output_layer of this AnnTrainingConfig.  # noqa: E501
        :rtype: AnnLayerConfig
        """
        return self._output_layer

    @output_layer.setter
    def output_layer(self, output_layer):
        """Sets the output_layer of this AnnTrainingConfig.

        Define min and max value for each output column(feature), and output activation function  # noqa: E501

        :param output_layer: The output_layer of this AnnTrainingConfig.  # noqa: E501
        :type: AnnLayerConfig
        """

        self._output_layer = output_layer

    @property
    def hidden_layer_configs(self):
        """Gets the hidden_layer_configs of this AnnTrainingConfig.  # noqa: E501

        Hidden layers configuration  # noqa: E501

        :return: The hidden_layer_configs of this AnnTrainingConfig.  # noqa: E501
        :rtype: list[AnnHiddenLayerConfig]
        """
        return self._hidden_layer_configs

    @hidden_layer_configs.setter
    def hidden_layer_configs(self, hidden_layer_configs):
        """Sets the hidden_layer_configs of this AnnTrainingConfig.

        Hidden layers configuration  # noqa: E501

        :param hidden_layer_configs: The hidden_layer_configs of this AnnTrainingConfig.  # noqa: E501
        :type: list[AnnHiddenLayerConfig]
        """

        self._hidden_layer_configs = hidden_layer_configs

    @property
    def training_algorithm(self):
        """Gets the training_algorithm of this AnnTrainingConfig.  # noqa: E501

        Training algorithm to use  # noqa: E501

        :return: The training_algorithm of this AnnTrainingConfig.  # noqa: E501
        :rtype: NeuralNetworkTrainingAlgorithm
        """
        return self._training_algorithm

    @training_algorithm.setter
    def training_algorithm(self, training_algorithm):
        """Sets the training_algorithm of this AnnTrainingConfig.

        Training algorithm to use  # noqa: E501

        :param training_algorithm: The training_algorithm of this AnnTrainingConfig.  # noqa: E501
        :type: NeuralNetworkTrainingAlgorithm
        """

        self._training_algorithm = training_algorithm

    @property
    def max_epoch(self):
        """Gets the max_epoch of this AnnTrainingConfig.  # noqa: E501

        Maximum number of epoch  # noqa: E501

        :return: The max_epoch of this AnnTrainingConfig.  # noqa: E501
        :rtype: int
        """
        return self._max_epoch

    @max_epoch.setter
    def max_epoch(self, max_epoch):
        """Sets the max_epoch of this AnnTrainingConfig.

        Maximum number of epoch  # noqa: E501

        :param max_epoch: The max_epoch of this AnnTrainingConfig.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and max_epoch is None:  # noqa: E501
            raise ValueError("Invalid value for `max_epoch`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                max_epoch is not None and max_epoch > 4294967295):  # noqa: E501
            raise ValueError("Invalid value for `max_epoch`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                max_epoch is not None and max_epoch < 1):  # noqa: E501
            raise ValueError("Invalid value for `max_epoch`, must be a value greater than or equal to `1`")  # noqa: E501

        self._max_epoch = max_epoch

    @property
    def cross_validation(self):
        """Gets the cross_validation of this AnnTrainingConfig.  # noqa: E501

        Use cross validation  # noqa: E501

        :return: The cross_validation of this AnnTrainingConfig.  # noqa: E501
        :rtype: bool
        """
        return self._cross_validation

    @cross_validation.setter
    def cross_validation(self, cross_validation):
        """Sets the cross_validation of this AnnTrainingConfig.

        Use cross validation  # noqa: E501

        :param cross_validation: The cross_validation of this AnnTrainingConfig.  # noqa: E501
        :type: bool
        """

        self._cross_validation = cross_validation

    @property
    def validation_split(self):
        """Gets the validation_split of this AnnTrainingConfig.  # noqa: E501

        Portion of data set to use for validation, must be between 0 and 1.   Used only when CrossValidation = false.  # noqa: E501

        :return: The validation_split of this AnnTrainingConfig.  # noqa: E501
        :rtype: float
        """
        return self._validation_split

    @validation_split.setter
    def validation_split(self, validation_split):
        """Sets the validation_split of this AnnTrainingConfig.

        Portion of data set to use for validation, must be between 0 and 1.   Used only when CrossValidation = false.  # noqa: E501

        :param validation_split: The validation_split of this AnnTrainingConfig.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and validation_split is None:  # noqa: E501
            raise ValueError("Invalid value for `validation_split`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                validation_split is not None and validation_split > 1):  # noqa: E501
            raise ValueError("Invalid value for `validation_split`, must be a value less than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                validation_split is not None and validation_split < 0):  # noqa: E501
            raise ValueError("Invalid value for `validation_split`, must be a value greater than or equal to `0`")  # noqa: E501

        self._validation_split = validation_split

    @property
    def random_seed(self):
        """Gets the random_seed of this AnnTrainingConfig.  # noqa: E501

        Random number generator seed, if the value is zero, the rows will not be randomly shuffled  Used only if CrossValidation = false  # noqa: E501

        :return: The random_seed of this AnnTrainingConfig.  # noqa: E501
        :rtype: int
        """
        return self._random_seed

    @random_seed.setter
    def random_seed(self, random_seed):
        """Sets the random_seed of this AnnTrainingConfig.

        Random number generator seed, if the value is zero, the rows will not be randomly shuffled  Used only if CrossValidation = false  # noqa: E501

        :param random_seed: The random_seed of this AnnTrainingConfig.  # noqa: E501
        :type: int
        """

        self._random_seed = random_seed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnnTrainingConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnnTrainingConfig):
            return True

        return self.to_dict() != other.to_dict()
