# based on: https://github.com/python/typeshed/blob/master/stdlib/3/re.pyi

from collections.abc import Callable, Iterator
from re import Match, Pattern, RegexFlag
from typing import overload, type_check_only, Any, Optional, Union

_FlagsType = Union[int, RegexFlag]
_Str = Union[bytes, memoryview]

@type_check_only
class _RevPattern:
    def search(self, string: _Str, pos: int = ..., endpos: int = ...) -> Optional[Match[bytes]]: ...
    def match(self, string: _Str, pos: int = ..., endpos: int = ...) -> Optional[Match[bytes]]: ...
    def fullmatch(self, string: _Str, pos: int = ..., endpos: int = ...) -> Optional[Match[bytes]]: ...
    def split(self, string: _Str, maxsplit: int = ...) -> list[bytes]: ...
    def findall(self, string: _Str, pos: int = ..., endpos: int = ...) -> list[Any]: ...
    def finditer(self, string: _Str, pos: int = ..., endpos: int = ...) -> Iterator[Match[bytes]]: ...
    @overload
    def sub(self, repl: bytes, string: _Str, count: int = ...) -> bytes: ...
    @overload
    def sub(self, repl: Callable[[Match[bytes]], bytes], string: _Str, count: int = ...) -> bytes: ...
    @overload
    def subn(self, repl: bytes, string: _Str, count: int = ...) -> tuple[bytes, int]: ...
    @overload
    def subn(self, repl: Callable[[Match[bytes]], bytes], string: _Str, count: int = ...) -> tuple[bytes, int]: ...

@overload
def compile(pattern: bytes, flags: _FlagsType = ...) -> _RevPattern: ...
@overload
def compile(pattern: Pattern[bytes], flags: _FlagsType = ...) -> _RevPattern: ...
