/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.config.DatasetNamerType;

public class DatasetNamer {
    private static Logger logger = LoggerFactory.getLogger(DatasetNamer.class);
    private InvDataset parentDataset = null;
    private String name = null;
    private boolean addLevel = false;
    private DatasetNamerType type = null;
    private String matchPattern = null;
    protected Pattern regExpPattern;
    private String substitutePattern = null;
    private String attribContainer = null;
    private String attribName = null;
    private boolean isValid = true;
    private StringBuffer msgLog = new StringBuffer();

    public DatasetNamer(InvDataset parentDs, String name, String addLevelBoolean, String typeName, String matchPattern, String substitutePattern, String attribContainer, String attribName) {
        this(parentDs, name, Boolean.parseBoolean(addLevelBoolean), DatasetNamerType.getType(typeName), matchPattern, substitutePattern, attribContainer, attribName);
        if (this.getType() == null) {
            this.isValid = false;
            this.msgLog.append(" ** DatasetNamer (1): invalid type [" + typeName + "] for datasetNamer [" + name + "].");
        }
    }

    public DatasetNamer(InvDataset parentDs, String name, boolean addLevel, DatasetNamerType type, String matchPattern, String substitutePattern, String attribContainer, String attribName) {
        this.parentDataset = parentDs;
        this.name = name;
        this.addLevel = addLevel;
        if (type == null) {
            this.isValid = false;
            this.msgLog.append(" ** DatasetNamer (1): null type for datasetNamer [" + name + "].");
        }
        this.type = type;
        if (matchPattern != null) {
            this.matchPattern = matchPattern;
            if (DatasetNamerType.REGULAR_EXPRESSION.equals((Object)this.type)) {
                try {
                    this.regExpPattern = Pattern.compile(this.matchPattern);
                }
                catch (PatternSyntaxException e) {
                    this.isValid = false;
                    this.msgLog.append(" ** DatasetNamer (3): invalid matchPattern [" + this.matchPattern + "].");
                }
            }
        }
        this.substitutePattern = substitutePattern;
        this.attribContainer = attribContainer;
        this.attribName = attribName;
    }

    public InvDataset getParentDataset() {
        return this.parentDataset;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAddLevel() {
        return this.addLevel;
    }

    public DatasetNamerType getType() {
        return this.type;
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public String getSubstitutePattern() {
        return this.substitutePattern;
    }

    public String getAttribContainer() {
        return this.attribContainer;
    }

    public String getAttribName() {
        return this.attribName;
    }

    boolean validate(StringBuilder out) {
        this.isValid = true;
        if (this.msgLog.length() > 0) {
            out.append(this.msgLog);
        }
        if (this.getName() == null) {
            this.isValid = false;
            out.append(" ** DatasetNamer (1): null value for name is not valid.");
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** DatasetNamer (3): null value for type is not valid (set with bad string?).");
        }
        if (this.getType() == DatasetNamerType.REGULAR_EXPRESSION && (this.getMatchPattern() == null || this.getSubstitutePattern() == null)) {
            this.isValid = false;
            out.append(" ** DatasetNamer (4): invalid datasetNamer <" + this.getName() + ">; type is " + this.getType().toString() + ": matchPattern(" + this.getMatchPattern() + ") and substitutionPattern(" + this.getSubstitutePattern() + ") must not be null.");
        }
        if (this.getType() == DatasetNamerType.DODS_ATTRIBUTE && (this.getAttribContainer() == null || this.getAttribName() == null)) {
            this.isValid = false;
            out.append(" ** DatasetNamer (5): invalid datasetNamer <" + this.getName() + ">; type is " + this.getType().toString() + ": attriuteContainer(" + this.getAttribContainer() + ") and attributeName(" + this.getAttribName() + ") must not be null.");
        }
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("DatasetNamer[name:<" + this.getName() + "> addLevel:<" + this.getAddLevel() + "> type:<" + (Object)((Object)this.getType()) + "> matchPattern:<" + this.getMatchPattern() + "> substitutePatter:<" + this.getSubstitutePattern() + "> attribContainer:<" + this.getAttribContainer() + "> attribName:<" + this.getAttribName() + ">]");
        return tmp.toString();
    }

    public boolean nameDataset(InvDatasetImpl dataset) {
        if (this.type == DatasetNamerType.REGULAR_EXPRESSION) {
            return this.nameDatasetRegExp(dataset);
        }
        String tmpMsg = "This DatasetNamer <" + this.getName() + "> has unsupported type <" + this.type.toString() + ">.";
        logger.error("nameDataset(): " + tmpMsg);
        throw new IllegalStateException(tmpMsg);
    }

    public boolean nameDatasetList(List datasetList) throws Exception {
        boolean returnValue = false;
        InvDatasetImpl curDataset = null;
        for (int i = 0; i < datasetList.size(); ++i) {
            curDataset = (InvDatasetImpl)datasetList.get(i);
            returnValue &= this.nameDataset(curDataset);
        }
        return returnValue;
    }

    private boolean nameDatasetRegExp(InvDatasetImpl dataset) {
        boolean isMatch;
        Matcher matcher;
        if (dataset.getUrlPath() != null) {
            logger.debug("nameDatasetRegExp(): try naming on urlPath <{}>", (Object)dataset.getUrlPath());
            matcher = this.regExpPattern.matcher(dataset.getUrlPath());
            isMatch = matcher.find();
        } else {
            matcher = this.regExpPattern.matcher(dataset.getName());
            isMatch = matcher.find();
        }
        if (isMatch) {
            StringBuffer resultingName = new StringBuffer();
            matcher.appendReplacement(resultingName, this.substitutePattern);
            resultingName.delete(0, matcher.start());
            if (resultingName.length() != 0) {
                logger.debug("nameDatasetRegExp(): Setting name to \"" + resultingName + "\".");
                dataset.setName(resultingName.toString());
                return true;
            }
            logger.debug("nameDatasetRegExp(): No name for regEx substitution.");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("nameDatasetRegExp(): Neither URL <" + dataset.getUrlPath() + "> or name <" + dataset.getName() + "> matched pattern <" + this.matchPattern + "> .");
        }
        return false;
    }
}

