import * as iam from '@aws-cdk/aws-iam';
import { RetentionDays } from '@aws-cdk/aws-logs';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct as CoreConstruct, Duration } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AlarmActions, Domain } from './api';
import { DenyListRule } from './backend/deny-list/api';
import { DomainRedirectSource } from './domain-redirect';
import { IPackageSource } from './package-source';
import { PackageTag } from './package-tag';
import { PackageTagGroup } from './package-tag-group';
import { PreloadFile } from './preload-file';
import { SpdxLicense } from './spdx-license';
import { PackageLinkConfig, FeaturedPackages, FeatureFlags, Category } from './webapp';
/**
 * (experimental) Props for `ConstructHub`.
 *
 * @experimental
 */
export interface ConstructHubProps {
    /**
     * (experimental) Connect the hub to a domain (requires a hosted zone and a certificate).
     *
     * @experimental
     */
    readonly domain?: Domain;
    /**
     * (experimental) Actions to perform when alarms are set.
     *
     * @experimental
     */
    readonly alarmActions?: AlarmActions;
    /**
     * (deprecated) Whether compute environments for sensitive tasks (which operate on un-trusted complex data, such as the transliterator, which operates with externally-sourced npm package tarballs) should run in network-isolated environments.
     *
     * This implies the creation of additonal resources, including:
     *
     * - A VPC with only isolated subnets.
     * - VPC Endpoints (CloudWatch Logs, CodeArtifact, CodeArtifact API, S3, ...)
     * - A CodeArtifact Repository with an external connection to npmjs.com
     *
     * @deprecated use sensitiveTaskIsolation instead.
     */
    readonly isolateSensitiveTasks?: boolean;
    /**
     * (experimental) Whether compute environments for sensitive tasks (which operate on un-trusted complex data, such as the transliterator, which operates with externally-sourced npm package tarballs) should run in network-isolated environments.
     *
     * This implies the creation of additonal resources, including:
     *
     * - A VPC with only isolated subnets.
     * - VPC Endpoints (CloudWatch Logs, CodeArtifact, CodeArtifact API, S3, ...)
     * - A CodeArtifact Repository with an external connection to npmjs.com
     *
     * @default Isolation.NO_INTERNET_ACCESS
     * @experimental
     */
    readonly sensitiveTaskIsolation?: Isolation;
    /**
     * (experimental) How long to retain CloudWatch logs for.
     *
     * @experimental
     * @defaults RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * (experimental) The name of the CloudWatch dashboard that represents the health of backend systems.
     *
     * @experimental
     */
    readonly backendDashboardName?: string;
    /**
     * (experimental) A list of packages to block from the construct hub.
     *
     * @default []
     * @experimental
     */
    readonly denyList?: DenyListRule[];
    /**
     * (experimental) The package sources to register with this ConstructHub instance.
     *
     * @default - a standard npmjs.com package source will be configured.
     * @experimental
     */
    readonly packageSources?: IPackageSource[];
    /**
     * (experimental) The allowed licenses for packages indexed by this instance of ConstructHub.
     *
     * @default [...SpdxLicense.apache(),...SpdxLicense.bsd(),...SpdxLicense.cddl(),...SpdxLicense.epl(),SpdxLicense.ISC,...SpdxLicense.mit(),SpdxLicense.MPL_2_0]
     * @experimental
     */
    readonly allowedLicenses?: SpdxLicense[];
    /**
     * (experimental) When using a CodeArtifact package source, it is often desirable to have ConstructHub provision it's internal CodeArtifact repository in the same CodeArtifact domain, and to configure the package source repository as an upstream of the internal repository.
     *
     * This way, all packages in the source
     * are available to ConstructHub's backend processing.
     *
     * @default - none.
     * @experimental
     */
    readonly codeArtifactDomain?: CodeArtifactDomainProps;
    /**
     * (experimental) Configuration for custom package page links.
     *
     * @experimental
     */
    readonly packageLinks?: PackageLinkConfig[];
    /**
     * (experimental) Configuration for custom package tags.
     *
     * @experimental
     */
    readonly packageTags?: PackageTag[];
    /**
     * (experimental) Optional configuration for grouping custom package tags.
     *
     * @experimental
     */
    readonly packageTagGroups?: PackageTagGroup[];
    /**
     * (experimental) Configuration for packages to feature on the home page.
     *
     * @default - Display the 10 most recently updated packages
     * @experimental
     */
    readonly featuredPackages?: FeaturedPackages;
    /**
     * (experimental) Configure feature flags for the web app.
     *
     * @experimental
     */
    readonly featureFlags?: FeatureFlags;
    /**
     * (experimental) Configure whether or not the backend should periodically query NPM for the number of downloads a package has in the past week, and display download counts on the web app.
     *
     * @default - true if packageSources is not specified (the defaults are
     * used), false otherwise
     * @experimental
     */
    readonly fetchPackageStats?: boolean;
    /**
     * (experimental) Browse categories.
     *
     * Each category will appear in the home page as a button
     * with a link to the relevant search query.
     *
     * @experimental
     */
    readonly categories?: Category[];
    /**
     * (experimental) Wire construct hub to use the failover storage buckets.
     *
     * Do not activate this property until you've populated your failover buckets
     * with the necessary data.
     *
     * @default false
     * @see https://github.com/cdklabs/construct-hub/blob/dev/docs/operator-runbook.md#storage-disaster
     * @experimental
     */
    readonly failoverStorage?: boolean;
    /**
     * (experimental) How frequently all packages should get fully reprocessed.
     *
     * See the operator runbook for more information about reprocessing.
     *
     * @default - never
     * @see https://github.com/cdklabs/construct-hub/blob/main/docs/operator-runbook.md
     * @experimental
     */
    readonly reprocessFrequency?: Duration;
    /**
     * (experimental) Additional domains which will be set up to redirect to the primary construct hub domain.
     *
     * @default []
     * @experimental
     */
    readonly additionalDomains?: DomainRedirectSource[];
    /**
     * (experimental) Javascript to run on webapp before app loads.
     *
     * @experimental
     */
    readonly preloadScript?: PreloadFile;
}
/**
 * (experimental) Information pertaining to an existing CodeArtifact Domain.
 *
 * @experimental
 */
export interface CodeArtifactDomainProps {
    /**
     * (experimental) The name of the CodeArtifact domain.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Any upstream repositories in this CodeArtifact domain that should be configured on the internal CodeArtifact repository.
     *
     * @experimental
     */
    readonly upstreams?: string[];
}
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
export declare class ConstructHub extends CoreConstruct implements iam.IGrantable {
    private readonly ingestion;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ConstructHubProps);
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * @experimental
     */
    get ingestionQueue(): sqs.IQueue;
    private createVpc;
}
/**
 * (experimental) How possibly risky operations (such as doc-generation, which requires installing the indexed packages in order to trans-literate sample code) are isolated to mitigate possible arbitrary code execution vulnerabilities in and around `npm install` or the transliterator's use of the TypeScript compiler.
 *
 * @experimental
 */
export declare enum Isolation {
    /**
     * (experimental) No isolation is done whatsoever. The doc-generation process still is provisioned with least-privilege permissions, but retains complete access to internet.
     *
     * While this maximizes the chances of successfully installing packages (and
     * hence successfully generating documentation for those), it is also the
     * least secure mode of operation.
     *
     * We advise you only consider using this isolation mode if you are hosting a
     * ConstructHub instance that only indexes trusted packages (including
     * transitive dependencies).
     *
     * @experimental
     */
    UNLIMITED_INTERNET_ACCESS = 0,
    /**
     * (experimental) The same protections as `UNLIMITED_INTERNET_ACCESS`, except outbound internet connections are limited to IP address ranges corresponding to hosting endpoints for npmjs.com.
     *
     * @experimental
     */
    LIMITED_INTERNET_ACCESS = 1,
    /**
     * (experimental) The same protections as `LIMITED_INTERNET_ACCESS`, except all remaining internet access is removed.
     *
     * All traffic to AWS service endpoints is routed
     * through VPC Endpoints, as the compute nodes are jailed in a completely
     * isolated VPC.
     *
     * This is the most secure (and recommended) mode of operation for
     * ConstructHub instances.
     *
     * @experimental
     */
    NO_INTERNET_ACCESS = 2
}
