"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheStrategy = void 0;
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const core_1 = require("@aws-cdk/core");
/**
 * Caching policies for serving data for the Construct Hub web app.
 */
class CacheStrategy {
    constructor(cacheControl) {
        this.cacheControl = cacheControl;
    }
    /**
     * Default caching policy for all S3 objects.
     */
    static default() {
        return new CacheStrategy([
            aws_s3_deployment_1.CacheControl.setPublic(),
            aws_s3_deployment_1.CacheControl.maxAge(core_1.Duration.minutes(5)),
            aws_s3_deployment_1.CacheControl.mustRevalidate(),
            aws_s3_deployment_1.CacheControl.sMaxAge(core_1.Duration.minutes(1)),
            aws_s3_deployment_1.CacheControl.proxyRevalidate(),
        ]);
    }
    toString() {
        return this.cacheControl.map(c => c.value).join(', ');
    }
    toArray() {
        return this.cacheControl;
    }
}
exports.CacheStrategy = CacheStrategy;
//# sourceMappingURL=data:application/json;base64,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