#!/usr/bin/env node
"use strict";
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
Object.defineProperty(exports, "__esModule", { value: true });
const os = require("os");
const process_1 = require("process");
const client_sfn_1 = require("@aws-sdk/client-sfn");
const transliterator_ecstask_1 = require("./transliterator.ecstask");
const sfn = new client_sfn_1.SFNClient({});
const taskToken = process_1.env.SFN_TASK_TOKEN;
delete process_1.env.SFN_TASK_TOKEN;
function sendHeartbeat() {
    sfn.send(new client_sfn_1.SendTaskHeartbeatCommand({ taskToken })).then(() => console.log('Successfully sent task heartbeat!'), (reason) => {
        console.error('Failed to send task heartbeat:', reason);
        if (reason.code === 'TaskTimedOut') {
            process_1.exit(-(os.constants.errno.ETIMEDOUT || 1));
        }
    });
}
sendHeartbeat();
const heartbeat = setInterval(sendHeartbeat, 60000);
async function main() {
    var _a, _b;
    try {
        const input = process_1.argv.slice(2).map((text) => JSON.parse(text));
        const result = await transliterator_ecstask_1.handler(...input);
        console.log('Task result:', result);
        await sfn.send(new client_sfn_1.SendTaskSuccessCommand({ output: JSON.stringify(result), taskToken }));
    }
    catch (err) {
        console.log('Task failed:', err);
        process.exitCode = 1;
        await sfn.send(new client_sfn_1.SendTaskFailureCommand({
            cause: JSON.stringify(err instanceof Error ? { message: err.message, name: err.name, stack: err.stack } : err),
            error: (_b = (_a = err.name) !== null && _a !== void 0 ? _a : err.constructor.name) !== null && _b !== void 0 ? _b : 'Error',
            taskToken,
        }));
    }
    finally {
        clearInterval(heartbeat);
    }
}
main().catch((cause) => {
    console.log('Unexpected error:', cause);
    process_1.exit(-1);
});
//# sourceMappingURL=data:application/json;base64,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