import { MathExpression, MathExpressionOptions, Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { SubnetSelection, Vpc, ISecurityGroup } from '@aws-cdk/aws-ec2';
import { ICluster } from '@aws-cdk/aws-ecs';
import { IFunction } from '@aws-cdk/aws-lambda';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { IStateMachine } from '@aws-cdk/aws-stepfunctions';
import { Construct } from '@aws-cdk/core';
import { Repository } from '../../codeartifact/repository';
import { Monitoring } from '../../monitoring';
import { CatalogBuilder } from '../catalog-builder';
import { DenyList } from '../deny-list';
import { Transliterator, TransliteratorVpcEndpoints } from '../transliterator';
export interface OrchestrationProps {
    /**
     * The bucket in which to source assemblies to transliterate.
     */
    readonly bucket: IBucket;
    /**
     * The CodeArtifact registry to use for regular operations.
     */
    readonly codeArtifact?: Repository;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The VPC in which to place networked resources.
     */
    readonly vpc?: Vpc;
    /**
     * The VPC subnet selection to use.
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * VPC endpoints to use for interacting with CodeArtifact and S3.
     */
    readonly vpcEndpoints?: TransliteratorVpcEndpoints;
    /**
     * VPC Security groups to associate with the ECS tasks.
     */
    readonly vpcSecurityGroups?: ISecurityGroup[];
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * The deny list.
     */
    readonly denyList: DenyList;
}
/**
 * Orchestrates the backend processing tasks using a StepFunctions State Machine.
 */
export declare class Orchestration extends Construct {
    /**
     * The state machine that should be triggered for starting back-end processing
     * for a newly discovered package.
     */
    readonly stateMachine: IStateMachine;
    /**
     * The dead letter queue from the state machine. Inputs and errors are written
     * there if the state machine fails.
     */
    readonly deadLetterQueue: IQueue;
    /**
     * The function operators can use to redrive messages from the dead letter
     * queue.
     */
    readonly redriveFunction: IFunction;
    /**
     * The function operators can use to reprocess all indexed packages through
     * the backend data pipeline.
     */
    readonly regenerateAllDocumentation: IStateMachine;
    /**
     * The function that builds the catalog.
     */
    readonly catalogBuilder: CatalogBuilder;
    /**
     * The ECS cluster used to run tasks.
     */
    readonly ecsCluster: ICluster;
    /**
     * The transliterator used by this orchestration workflow.
     */
    readonly transliterator: Transliterator;
    constructor(scope: Construct, id: string, props: OrchestrationProps);
    metricEcsTaskCount(opts: MetricOptions): Metric;
    metricEcsCpuReserved(opts?: MetricOptions): Metric;
    metricEcsCpuUtilized(opts?: MetricOptions): Metric;
    metricEcsCpuUtilization(opts?: MathExpressionOptions): MathExpression;
    metricEcsMemoryReserved(opts?: MetricOptions): Metric;
    metricEcsMemoryUtilized(opts?: MetricOptions): Metric;
    metricEcsMemoryUtilization(opts?: MathExpressionOptions): MathExpression;
    metricEcsNetworkRxBytes(opts?: MetricOptions): Metric;
    metricEcsNetworkTxBytes(opts?: MetricOptions): Metric;
}
