"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, privateMap, value) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to set private field on non-instance");
    }
    privateMap.set(receiver, value);
    return value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, privateMap) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to get private field on non-instance");
    }
    return privateMap.get(receiver);
};
var _bucketName, _objectKey, _map;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicenseListClient = void 0;
const aws_lambda_shared_1 = require("../shared/aws.lambda-shared");
const env_lambda_shared_1 = require("../shared/env.lambda-shared");
/**
 * A client for working with the license list.
 */
class LicenseListClient {
    constructor() {
        _bucketName.set(this, void 0);
        _objectKey.set(this, void 0);
        _map.set(this, void 0);
        __classPrivateFieldSet(this, _bucketName, env_lambda_shared_1.requireEnv("LICENSE_LIST_BUCKET_NAME" /* BUCKET_NAME */));
        __classPrivateFieldSet(this, _objectKey, env_lambda_shared_1.requireEnv("LICENSE_LIST_OBJECT_KEY" /* OBJECT_KEY */));
    }
    static async newClient() {
        const client = new LicenseListClient();
        await client.init();
        return client;
    }
    /**
     * Looks up a license ID in this list.
     *
     * @param licenseId the license ID to look up (possibly with unorthodox case).
     *
     * @returns the normalized SPDX license identifier for this license, if it is
     *          in the list, or `undefined` otherwise.
     */
    lookup(licenseId) {
        /* istanbul ignore if (should never happen) */
        if (__classPrivateFieldGet(this, _map) == null) {
            throw new Error('LicenseListClient must be initialized');
        }
        return __classPrivateFieldGet(this, _map).get(licenseId.toUpperCase());
    }
    async init() {
        /* istanbul ignore if (should never happen) */
        if (__classPrivateFieldGet(this, _map) != null) {
            throw new Error('init() cannot be called twice');
        }
        const { Body: body } = await aws_lambda_shared_1.s3().getObject({ Bucket: __classPrivateFieldGet(this, _bucketName), Key: __classPrivateFieldGet(this, _objectKey) }).promise();
        if (!body) {
            console.log(`WARNING: license list is empty at ${__classPrivateFieldGet(this, _bucketName)}/${__classPrivateFieldGet(this, _objectKey)}`);
            __classPrivateFieldSet(this, _map, new Map());
            return;
        }
        const licenseIds = JSON.parse(body.toString('utf-8'));
        if (!Array.isArray(licenseIds)) {
            throw new Error(`Invalid format in license list file at ${__classPrivateFieldGet(this, _bucketName)}/${__classPrivateFieldGet(this, _objectKey)}. Expected an array.`);
        }
        __classPrivateFieldSet(this, _map, new Map(licenseIds.map((id) => [id.toUpperCase(), id])));
    }
}
exports.LicenseListClient = LicenseListClient;
_bucketName = new WeakMap(), _objectKey = new WeakMap(), _map = new WeakMap();
//# sourceMappingURL=data:application/json;base64,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