/**
 * A client for working with the license list.
 */
export declare class LicenseListClient {
    #private;
    static newClient(): Promise<LicenseListClient>;
    private constructor();
    /**
     * Looks up a license ID in this list.
     *
     * @param licenseId the license ID to look up (possibly with unorthodox case).
     *
     * @returns the normalized SPDX license identifier for this license, if it is
     *          in the list, or `undefined` otherwise.
     */
    lookup(licenseId: string): string | undefined;
    private init;
}
