import { Assembly } from '@jsii/spec';
export declare const enum ConstructFrameworkName {
    AWS_CDK = "aws-cdk",
    CDK8S = "cdk8s",
    CDKTF = "cdktf"
}
export interface ConstructFramework {
    /**
     * The name of the construct framework.
     */
    readonly name: ConstructFrameworkName;
    /**
     * The major version of the construct framework that is used, if it could be
     * identified.
     */
    readonly majorVersion?: number;
}
/**
 * Determines the Construct framework used by the provided assembly.
 *
 * @param assembly the assembly for which a construct framework should be
 *                 identified.
 *
 * @returns a construct framework if one could be identified.
 */
export declare function detectConstructFramework(assembly: Assembly): ConstructFramework | undefined;
