"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gravitonLambdaIfAvailable = void 0;
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const REGIONS_WITH_GRAVITON_LAMBDA = new Set([
    'us-east-1',
    'us-east-2',
    'us-west-2',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'ap-south-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
]);
/**
 * Returns the Graviton Lambda architecture (`Architecture.ARM`) if it's
 * available in the current region. This falls back to default in case the
 * region is not known at synthesis time.
 *
 * @param scope the scope from which the region should be extracted.
 */
function gravitonLambdaIfAvailable(scope) {
    return REGIONS_WITH_GRAVITON_LAMBDA.has(core_1.Stack.of(scope).region)
        ? aws_lambda_1.Architecture.ARM_64
        : undefined;
}
exports.gravitonLambdaIfAvailable = gravitonLambdaIfAvailable;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX2xhbWJkYS1hcmNoaXRlY3R1cmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYmFja2VuZC9fbGFtYmRhLWFyY2hpdGVjdHVyZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxvREFBbUQ7QUFDbkQsd0NBQWlEO0FBRWpELE1BQU0sNEJBQTRCLEdBQUcsSUFBSSxHQUFHLENBQUM7SUFDM0MsV0FBVztJQUNYLFdBQVc7SUFDWCxXQUFXO0lBQ1gsY0FBYztJQUNkLFdBQVc7SUFDWCxXQUFXO0lBQ1gsWUFBWTtJQUNaLGdCQUFnQjtJQUNoQixnQkFBZ0I7SUFDaEIsZ0JBQWdCO0NBQ2pCLENBQUMsQ0FBQztBQUVIOzs7Ozs7R0FNRztBQUNILFNBQWdCLHlCQUF5QixDQUFDLEtBQWdCO0lBQ3hELE9BQU8sNEJBQTRCLENBQUMsR0FBRyxDQUFDLFlBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxDQUFDO1FBQzdELENBQUMsQ0FBQyx5QkFBWSxDQUFDLE1BQU07UUFDckIsQ0FBQyxDQUFDLFNBQVMsQ0FBQztBQUNoQixDQUFDO0FBSkQsOERBSUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcmNoaXRlY3R1cmUgfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFN0YWNrLCBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuY29uc3QgUkVHSU9OU19XSVRIX0dSQVZJVE9OX0xBTUJEQSA9IG5ldyBTZXQoW1xuICAndXMtZWFzdC0xJyxcbiAgJ3VzLWVhc3QtMicsXG4gICd1cy13ZXN0LTInLFxuICAnZXUtY2VudHJhbC0xJyxcbiAgJ2V1LXdlc3QtMScsXG4gICdldS13ZXN0LTInLFxuICAnYXAtc291dGgtMScsXG4gICdhcC1zb3V0aGVhc3QtMScsXG4gICdhcC1zb3V0aGVhc3QtMicsXG4gICdhcC1ub3J0aGVhc3QtMScsXG5dKTtcblxuLyoqXG4gKiBSZXR1cm5zIHRoZSBHcmF2aXRvbiBMYW1iZGEgYXJjaGl0ZWN0dXJlIChgQXJjaGl0ZWN0dXJlLkFSTWApIGlmIGl0J3NcbiAqIGF2YWlsYWJsZSBpbiB0aGUgY3VycmVudCByZWdpb24uIFRoaXMgZmFsbHMgYmFjayB0byBkZWZhdWx0IGluIGNhc2UgdGhlXG4gKiByZWdpb24gaXMgbm90IGtub3duIGF0IHN5bnRoZXNpcyB0aW1lLlxuICpcbiAqIEBwYXJhbSBzY29wZSB0aGUgc2NvcGUgZnJvbSB3aGljaCB0aGUgcmVnaW9uIHNob3VsZCBiZSBleHRyYWN0ZWQuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBncmF2aXRvbkxhbWJkYUlmQXZhaWxhYmxlKHNjb3BlOiBDb25zdHJ1Y3QpOiBBcmNoaXRlY3R1cmUgfCB1bmRlZmluZWQge1xuICByZXR1cm4gUkVHSU9OU19XSVRIX0dSQVZJVE9OX0xBTUJEQS5oYXMoU3RhY2sub2Yoc2NvcGUpLnJlZ2lvbilcbiAgICA/IEFyY2hpdGVjdHVyZS5BUk1fNjRcbiAgICA6IHVuZGVmaW5lZDtcbn1cbiJdfQ==