import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { DenyList } from './backend/deny-list';
import { Ingestion } from './backend/ingestion';
import { Inventory } from './backend/inventory';
import { Orchestration } from './backend/orchestration';
import { PackageStats } from './backend/package-stats';
import { VersionTracker } from './backend/version-tracker';
import { PackageSourceBindResult } from './package-source';
export interface BackendDashboardProps {
    readonly dashboardName?: string;
    readonly packageSources: PackageSourceBindResult[];
    readonly ingestion: Ingestion;
    readonly orchestration: Orchestration;
    readonly inventory: Inventory;
    readonly denyList: DenyList;
    readonly packageData: IBucket;
    readonly packageStats?: PackageStats;
    readonly versionTracker: VersionTracker;
}
export declare class BackendDashboard extends Construct {
    constructor(scope: Construct, id: string, props: BackendDashboardProps);
    private perLanguageReports;
    private catalogOverviewLanguageSections;
}
