import { CfnProject } from './codebuild.generated';
import { IProject } from './project';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * The type returned from {@link IFileSystemLocation#bind}.
 *
 * @stability stable
 */
export interface FileSystemConfig {
    /**
     * File system location wrapper property.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html
     * @stability stable
     */
    readonly location: CfnProject.ProjectFileSystemLocationProperty;
}
/**
 * The interface of a CodeBuild FileSystemLocation.
 *
 * Implemented by {@link EfsFileSystemLocation}.
 *
 * @stability stable
 */
export interface IFileSystemLocation {
    /**
     * Called by the project when a file system is added so it can perform binding operations on this file system location.
     *
     * @stability stable
     */
    bind(scope: CoreConstruct, project: IProject): FileSystemConfig;
}
/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 *
 * @stability stable
 */
export declare class FileSystemLocation {
    /**
     * EFS file system provider.
     *
     * @param props the EFS File System location property.
     * @stability stable
     */
    static efs(props: EfsFileSystemLocationProps): IFileSystemLocation;
}
/**
 * Construction properties for {@link EfsFileSystemLocation}.
 *
 * @stability stable
 */
export interface EfsFileSystemLocationProps {
    /**
     * The name used to access a file system created by Amazon EFS.
     *
     * @stability stable
     */
    readonly identifier: string;
    /**
     * A string that specifies the location of the file system, like Amazon EFS.
     *
     * @stability stable
     * @example
     *
     * 'fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory'.
     */
    readonly location: string;
    /**
     * The mount options for a file system such as Amazon EFS.
     *
     * @default 'nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2'.
     * @stability stable
     */
    readonly mountOptions?: string;
    /**
     * The location in the container where you mount the file system.
     *
     * @stability stable
     */
    readonly mountPoint: string;
}
