"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhaseChangeEvent = exports.StateChangeEvent = void 0;
const events = require("@aws-cdk/aws-events");
/**
 * Event fields for the CodeBuild "state change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @stability stable
 */
class StateChangeEvent {
    /**
     * The triggering build's status.
     *
     * @stability stable
     */
    static get buildStatus() {
        return events.EventField.fromPath('$.detail.build-status');
    }
    /**
     * The triggering build's project name.
     *
     * @stability stable
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * Return the build id.
     *
     * @stability stable
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * @stability stable
     */
    static get currentPhase() {
        return events.EventField.fromPath('$.detail.current-phase');
    }
    constructor() {
    }
}
exports.StateChangeEvent = StateChangeEvent;
/**
 * Event fields for the CodeBuild "phase change" event.
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 * @stability stable
 */
class PhaseChangeEvent {
    /**
     * The triggering build's project name.
     *
     * @stability stable
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * The triggering build's id.
     *
     * @stability stable
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * The phase that was just completed.
     *
     * @stability stable
     */
    static get completedPhase() {
        return events.EventField.fromPath('$.detail.completed-phase');
    }
    /**
     * The status of the completed phase.
     *
     * @stability stable
     */
    static get completedPhaseStatus() {
        return events.EventField.fromPath('$.detail.completed-phase-status');
    }
    /**
     * The duration of the completed phase.
     *
     * @stability stable
     */
    static get completedPhaseDurationSeconds() {
        return events.EventField.fromPath('$.detail.completed-phase-duration-seconds');
    }
    /**
     * Whether the build is complete.
     *
     * @stability stable
     */
    static get buildComplete() {
        return events.EventField.fromPath('$.detail.build-complete');
    }
    constructor() {
    }
}
exports.PhaseChangeEvent = PhaseChangeEvent;
//# sourceMappingURL=data:application/json;base64,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