"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultS3NotificationEventTypes = exports.DefaultLoggingBucketProps = exports.DefaultS3Props = void 0;
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
function DefaultS3Props(loggingBucket, lifecycleRules) {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: core_1.RemovalPolicy.RETAIN,
        ...((lifecycleRules !== undefined) && { lifecycleRules }),
        ...((loggingBucket !== undefined) && { serverAccessLogsBucket: loggingBucket })
    };
}
exports.DefaultS3Props = DefaultS3Props;
function DefaultLoggingBucketProps() {
    return {
        encryption: s3.BucketEncryption.S3_MANAGED,
        versioned: true,
        blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
        removalPolicy: core_1.RemovalPolicy.RETAIN,
    };
}
exports.DefaultLoggingBucketProps = DefaultLoggingBucketProps;
// Default event types to trigger S3 notifications
exports.defaultS3NotificationEventTypes = [s3.EventType.OBJECT_CREATED];
//# sourceMappingURL=data:application/json;base64,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