# Generated by Django 2.1.7 on 2019-03-19 18:13

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import observation_portal.sciapplications.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('proposals', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Call',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('opens', models.DateTimeField()),
                ('deadline', models.DateTimeField()),
                ('call_url', models.URLField(blank=True, default='')),
                ('proposal_type', models.CharField(choices=[('SCI', 'Science'), ('DDT', "Director's Discretionary Time"), ('KEY', 'Key Project'), ('NAOC', 'NAOC proposal'), ('COLAB', 'Science Collaboration Proposal')], max_length=5)),
                ('eligibility', models.TextField(blank=True, default='')),
                ('eligibility_short', models.TextField(blank=True, default='')),
            ],
        ),
        migrations.CreateModel(
            name='CoInvestigator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('first_name', models.CharField(max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('institution', models.CharField(max_length=255)),
            ],
            options={
                'ordering': ('last_name', 'first_name'),
            },
        ),
        migrations.CreateModel(
            name='Instrument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=50)),
                ('display', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='ScienceApplication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200)),
                ('abstract', models.TextField(blank=True, default='')),
                ('pi', models.EmailField(blank=True, default='', max_length=254)),
                ('pi_first_name', models.CharField(blank=True, default='', max_length=255)),
                ('pi_last_name', models.CharField(blank=True, default='', max_length=255)),
                ('pi_institution', models.CharField(blank=True, default='', max_length=255)),
                ('status', models.CharField(choices=[('DRAFT', 'Draft'), ('SUBMITTED', 'Submitted'), ('ACCEPTED', 'Accepted'), ('REJECTED', 'Rejected'), ('PORTED', 'Ported')], default='DRAFT', max_length=50)),
                ('tac_rank', models.PositiveIntegerField(default=0)),
                ('tac_priority', models.PositiveIntegerField(default=0)),
                ('pdf', models.FileField(blank=True, null=True, upload_to=observation_portal.sciapplications.models.pdf_upload_path)),
                ('notes', models.TextField(blank=True, default='', help_text='Add notes here. Not visible to users.')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('submitted', models.DateTimeField(blank=True, null=True)),
                ('call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sciapplications.Call')),
                ('proposal', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='proposals.Proposal')),
                ('submitter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='TimeRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('std_time', models.PositiveIntegerField(default=0)),
                ('rr_time', models.PositiveIntegerField(default=0)),
                ('tc_time', models.PositiveIntegerField(default=0)),
                ('approved', models.BooleanField(default=False)),
                ('instrument', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sciapplications.Instrument')),
                ('science_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sciapplications.ScienceApplication')),
                ('semester', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Semester')),
            ],
            options={
                'ordering': ('semester', 'instrument__display'),
            },
        ),
        migrations.AddField(
            model_name='coinvestigator',
            name='science_application',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sciapplications.ScienceApplication'),
        ),
        migrations.AddField(
            model_name='call',
            name='instruments',
            field=models.ManyToManyField(to='sciapplications.Instrument'),
        ),
        migrations.AddField(
            model_name='call',
            name='semester',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Semester'),
        ),
    ]
