# Generated by Django 2.1.7 on 2019-03-19 18:13

from django.conf import settings
import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('proposals', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AcquisitionConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mode', models.CharField(default='OFF', help_text='AcquisitionConfig mode to use for the observations', max_length=50)),
                ('extra_params', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Extra AcquisitionConfig parameters', verbose_name='extra parameters')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('instrument_type', models.CharField(help_text='The instrument type used for the observations under this Configuration', max_length=255)),
                ('type', models.CharField(choices=[('EXPOSE', 'EXPOSE'), ('SKY_FLAT', 'SKY_FLAT'), ('STANDARD', 'STANDARD'), ('ARC', 'ARC'), ('LAMP_FLAT', 'LAMP_FLAT'), ('SPECTRUM', 'SPECTRUM'), ('AUTO_FOCUS', 'AUTO_FOCUS'), ('TRIPLE', 'TRIPLE'), ('NRES_TEST', 'NRES_TEST'), ('NRES_SPECTRUM', 'NRES_SPECTRUM'), ('NRES_EXPOSE', 'NRES_EXPOSE'), ('ENGINEERING', 'ENGINEERING'), ('SCRIPT', 'SCRIPT')], help_text='The type of exposures for the observations under this Configuration', max_length=50)),
                ('extra_params', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Extra Configuration parameters', verbose_name='extra parameters')),
                ('priority', models.IntegerField(default=500, help_text='The order that the Configurations within a Request will be observed. Configurations with priorities that are lower numbers are executed first.')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='Constraints',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('max_airmass', models.FloatField(default=1.6, help_text='Maximum acceptable airmass. At zenith, the airmass equals 1 and increases with zenith distance. Assumes a plane-parallel atmosphere. You can read about the considerations of setting the airmass limit <a href="https://lco.global/documentation/airmass-limit/">here</a>.', validators=[django.core.validators.MinValueValidator(1.0), django.core.validators.MaxValueValidator(25.0)], verbose_name='maximum airmass')),
                ('min_lunar_distance', models.FloatField(default=30.0, help_text='Minimum acceptable angular separation between the target and the moon in decimal degrees', validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(180.0)], verbose_name='minimum lunar distance')),
                ('max_lunar_phase', models.FloatField(blank=True, help_text='Maximum acceptable lunar phase', null=True, verbose_name='Maximum lunar phase')),
                ('max_seeing', models.FloatField(blank=True, help_text='Maximum acceptable seeing', null=True, verbose_name='maximum seeing')),
                ('min_transparency', models.FloatField(blank=True, help_text='Minimum acceptable transparency', null=True, verbose_name='minimum transparency')),
                ('extra_params', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Extra Constraints parameters', verbose_name='extra parameters')),
                ('configuration', models.OneToOneField(help_text='The Configuration to which these Constraints belong', on_delete=django.db.models.deletion.CASCADE, to='requestgroups.Configuration')),
            ],
            options={
                'verbose_name_plural': 'Constraints',
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='DraftRequestGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50)),
                ('content', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('proposal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Proposal')),
            ],
            options={
                'ordering': ['-modified'],
            },
        ),
        migrations.CreateModel(
            name='GuidingConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('state', models.CharField(choices=[('OPTIONAL', 'OPTIONAL'), ('ON', 'ON'), ('OFF', 'OFF')], default='OPTIONAL', help_text='GuidingConfig state to use for the observations', max_length=50)),
                ('mode', models.CharField(blank=True, default='', help_text='Guiding mode to use for the observations', max_length=50)),
                ('optical_elements', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Optical Element specification for this GuidingConfig')),
                ('exposure_time', models.FloatField(default=0.01, help_text='Guiding exposure time', validators=[django.core.validators.MinValueValidator(0.01)])),
                ('extra_params', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Extra GuidingConfig parameters', verbose_name='extra parameters')),
                ('configuration', models.OneToOneField(help_text='The Configuration to which this GuidingConfig belongs', on_delete=django.db.models.deletion.CASCADE, related_name='guiding_config', to='requestgroups.Configuration')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='InstrumentConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('optical_elements', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Specification of optical elements used for this InstrumentConfig')),
                ('mode', models.CharField(blank=True, default='', help_text='The mode of this InstrumentConfig', max_length=50)),
                ('exposure_time', models.FloatField(help_text='Exposure time in seconds. A tool to aid in deciding on an exposure time is located <a href="https://lco.global/files/etc/exposure_time_calculator.html">here</a>.', validators=[django.core.validators.MinValueValidator(0.01)])),
                ('exposure_count', models.PositiveIntegerField(help_text='The number of exposures to take. This field must be set to a value greater than 0, but optionally you can add a boolean fill_window field to the Configuration upon submission with a value of true. If this is set, the exposure_count will be set to the number of exposures (including overheads) that will fit in the observing window.', validators=[django.core.validators.MinValueValidator(1)])),
                ('bin_x', models.PositiveSmallIntegerField(blank=True, default=1, help_text='Binning in the x dimension, defaults to the instrument default', verbose_name='y binning')),
                ('bin_y', models.PositiveSmallIntegerField(blank=True, default=1, help_text='Binning in the y dimension, defaults to the instrument default', verbose_name='x binning')),
                ('rot_mode', models.CharField(blank=True, default='', help_text='(Spectrograph only) How the slit is positioned on the sky. If set to VFLOAT, atmospheric dispersion is along the slit.', max_length=50, verbose_name='rotation mode')),
                ('extra_params', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Extra InstrumentConfig parameters', verbose_name='extra parameters')),
                ('configuration', models.ForeignKey(help_text='The Configuration to which this InstrumentConfig belongs', on_delete=django.db.models.deletion.CASCADE, related_name='instrument_configs', to='requestgroups.Configuration')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('telescope_class', models.CharField(help_text='The telescope class on which to observe the Request. The class describes the aperture size, e.g. 1m0 is a 1m telescope, and 0m4 is a 0.4m telescope.', max_length=20)),
                ('site', models.CharField(blank=True, default='', help_text='Three-letter site code indicating the site at which to observe the Request', max_length=20)),
                ('enclosure', models.CharField(blank=True, default='', help_text='Four-letter enclosure code indicating the enclosure from which to observe the Request', max_length=20)),
                ('telescope', models.CharField(blank=True, default='', help_text='Four-letter telescope code indicating the telescope on which to observe the Request', max_length=20)),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='RegionOfInterest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('x1', models.PositiveIntegerField(blank=True, help_text='Sub-frame x start pixel', null=True)),
                ('x2', models.PositiveIntegerField(blank=True, help_text='Sub-frame x end pixel', null=True)),
                ('y1', models.PositiveIntegerField(blank=True, help_text='Sub-frame y start pixel', null=True)),
                ('y2', models.PositiveIntegerField(blank=True, help_text='Sub-frame y end pixel', null=True)),
                ('instrument_config', models.ForeignKey(help_text='The InstrumentConfig to which this RegionOfInterest belongs', on_delete=django.db.models.deletion.CASCADE, related_name='rois', to='requestgroups.InstrumentConfig')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('observation_note', models.CharField(blank=True, default='', help_text='Text describing this Request', max_length=255)),
                ('state', models.CharField(choices=[('PENDING', 'PENDING'), ('COMPLETED', 'COMPLETED'), ('WINDOW_EXPIRED', 'WINDOW_EXPIRED'), ('CANCELED', 'CANCELED')], default='PENDING', help_text='Current state of this Request', max_length=40)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True, help_text='Time at which this Request last changed')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='Time at which the Request was created')),
                ('acceptability_threshold', models.FloatField(default=90.0, help_text='The percentage of this Request that must be completed to mark it as complete and avert rescheduling. The percentage should be set to the lowest value for which the amount of data is acceptable to meet the science goal of the Request. Defaults to 100 for FLOYDS observations and 90 for all other observations.', validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(100.0)])),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='RequestGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Descriptive name for this RequestGroup. This string will be placed in the FITS header as the GROUPID keyword value for all FITS frames originating from this RequestGroup.', max_length=50)),
                ('observation_type', models.CharField(choices=[('NORMAL', 'NORMAL'), ('RAPID_RESPONSE', 'RAPID_RESPONSE'), ('TIME_CRITICAL', 'TIME_CRITICAL'), ('DIRECT', 'DIRECT')], help_text='The type of observations under this RequestGroup. Requests submitted with RAPID_RESPONSE bypass normal scheduling and are executed immediately. Requests submitted with TIME_CRITICAL are scheduled normally but with a high priority. These modes are only available if the Proposal was granted special time. More information is located <a href="https://lco.global/documentation/special-scheduling-modes/">here</a>.', max_length=40)),
                ('operator', models.CharField(choices=[('SINGLE', 'SINGLE'), ('MANY', 'MANY')], help_text='Operator that describes how child Requests are scheduled. Use SINGLE if you have only one Request and MANY if you have more than one.', max_length=20)),
                ('ipp_value', models.FloatField(help_text='A multiplier to the base priority of the Proposal for this RequestGroup and all child Requests. A value > 1.0 will raise the priority and debit the Proposal ipp_time_available upon submission. If a Request does not complete, the time debited for that Request is returned. A value < 1.0 will lower the priority and credit the ipp_time_available of the Proposal up to the ipp_limit on the successful completion of a Request. The value is generally set to 1.05. More information can be found <a href="https://lco.global/files/User_Documentation/the_new_priority_factor.pdf">here</a>.', validators=[django.core.validators.MinValueValidator(0.5), django.core.validators.MaxValueValidator(2.0)])),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True, help_text='Time when this RequestGroup was created')),
                ('state', models.CharField(choices=[('PENDING', 'PENDING'), ('COMPLETED', 'COMPLETED'), ('WINDOW_EXPIRED', 'WINDOW_EXPIRED'), ('CANCELED', 'CANCELED')], default='PENDING', help_text='Current state of this RequestGroup', max_length=40)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True, help_text='Time when this RequestGroup was last changed')),
                ('proposal', models.ForeignKey(help_text='The Proposal under which the observations for this RequestGroup are made', on_delete=django.db.models.deletion.CASCADE, to='proposals.Proposal')),
                ('submitter', models.ForeignKey(help_text='The user that submitted this RequestGroup', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='Target',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of this Target', max_length=50)),
                ('type', models.CharField(choices=[('SIDEREAL', 'SIDEREAL'), ('NON_SIDEREAL', 'NON_SIDEREAL'), ('STATIC', 'STATIC'), ('SATELLITE', 'SATELLITE')], help_text='The type of this Target', max_length=255)),
                ('roll', models.FloatField(blank=True, help_text='Roll of this Target', null=True)),
                ('pitch', models.FloatField(blank=True, help_text='Pitch of this Target', null=True)),
                ('hour_angle', models.FloatField(blank=True, help_text='Hour angle of this Target', null=True)),
                ('ra', models.FloatField(blank=True, help_text='Right ascension in decimal degrees', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(360.0)], verbose_name='right ascension')),
                ('dec', models.FloatField(blank=True, help_text='Declination in decimal degrees', null=True, validators=[django.core.validators.MinValueValidator(-90.0), django.core.validators.MaxValueValidator(90.0)], verbose_name='declination')),
                ('altitude', models.FloatField(blank=True, help_text='Altitude of this Target', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(90.0)])),
                ('azimuth', models.FloatField(blank=True, help_text='Azimuth of this Target', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(360.0)])),
                ('coordinate_system', models.CharField(blank=True, default='', help_text='Coordinate system to use for the Target. Defaults to ICRS.', max_length=255)),
                ('equinox', models.CharField(blank=True, default='', help_text='Equinox to use for the Target. Defaults to J2000.', max_length=20)),
                ('proper_motion_ra', models.FloatField(blank=True, help_text='Right ascension proper motion of the Target +/-33 mas/year. Defaults to 0.', null=True, validators=[django.core.validators.MaxValueValidator(20000)], verbose_name='right ascension proper motion')),
                ('proper_motion_dec', models.FloatField(blank=True, help_text='Declination proper motion of the Target +/-33 mas/year. Defaults to 0.', null=True, validators=[django.core.validators.MaxValueValidator(20000)], verbose_name='declination proper motion')),
                ('epoch', models.FloatField(blank=True, help_text='Epoch in Modified Julian Days (MJD). Defaults to 2000.', max_length=20, null=True, validators=[django.core.validators.MaxValueValidator(2100)])),
                ('parallax', models.FloatField(blank=True, help_text='Parallax of the Target ±0.45 mas, max 2000. Defaults to 0.', null=True, validators=[django.core.validators.MaxValueValidator(2000)])),
                ('diff_pitch_rate', models.FloatField(blank=True, help_text='Differential pitch rate (arcsec/s)', null=True, verbose_name='differential pitch rate')),
                ('diff_roll_rate', models.FloatField(blank=True, help_text='Differential roll rate (arcsec/s)', null=True, verbose_name='differential roll rate')),
                ('diff_epoch_rate', models.FloatField(blank=True, help_text='Reference time for non-sidereal motion (MJD)', null=True, verbose_name='differential epoch rate')),
                ('diff_pitch_acceleration', models.FloatField(blank=True, help_text='Differential pitch acceleration (arcsec/s^2)', null=True, verbose_name='differential pitch acceleration')),
                ('diff_roll_acceleration', models.FloatField(blank=True, help_text='Differential role acceleration (arcsec/s^2)', null=True, verbose_name='differential roll acceleration')),
                ('scheme', models.CharField(blank=True, choices=[('ASA_MAJOR_PLANET', 'ASA_MAJOR_PLANET'), ('ASA_MINOR_PLANET', 'ASA_MINOR_PLANET'), ('ASA_COMET', 'ASA_COMET'), ('JPL_MAJOR_PLANET', 'JPL_MAJOR_PLANET'), ('JPL_MINOR_PLANET', 'JPL_MINOR_PLANET'), ('MPC_MINOR_PLANET', 'MPC_MINOR_PLANET'), ('MPC_COMET', 'MPC_COMET')], default='', help_text='The Target scheme to use', max_length=50, verbose_name='orbital element scheme')),
                ('epochofel', models.FloatField(blank=True, help_text='The epoch of the orbital elements (MJD)', null=True, validators=[django.core.validators.MinValueValidator(10000), django.core.validators.MaxValueValidator(100000)], verbose_name='epoch of elements')),
                ('orbinc', models.FloatField(blank=True, help_text='Orbital inclination (angle in degrees)', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(180.0)], verbose_name='orbital inclination')),
                ('longascnode', models.FloatField(blank=True, help_text='Longitude of ascending node (angle in degrees)', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(360.0)], verbose_name='longitude of ascending node')),
                ('longofperih', models.FloatField(blank=True, help_text='Longitude of perihelion (angle in degrees)', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(360.0)], verbose_name='longitude of perihelion')),
                ('argofperih', models.FloatField(blank=True, help_text='Argument of perihelion (angle in degrees)', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(360.0)], verbose_name='argument of perihelion')),
                ('meandist', models.FloatField(blank=True, help_text='Mean distance (AU)', null=True, verbose_name='mean distance')),
                ('perihdist', models.FloatField(blank=True, help_text='Perihelion distance (AU)', null=True, verbose_name='perihelion distance')),
                ('eccentricity', models.FloatField(blank=True, help_text='Eccentricity of the orbit', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(0.99)])),
                ('meanlong', models.FloatField(blank=True, help_text='Mean longitude (angle in degrees)', null=True, verbose_name='mean longitude')),
                ('meananom', models.FloatField(blank=True, help_text='Mean anomaly (angle in degrees)', null=True, validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(360.0)], verbose_name='mean anomaly')),
                ('dailymot', models.FloatField(blank=True, help_text='Daily motion (angle in degrees)', null=True, verbose_name='daily motion')),
                ('epochofperih', models.FloatField(blank=True, help_text='Epoch of perihelion (MJD)', null=True, validators=[django.core.validators.MinValueValidator(10000), django.core.validators.MaxValueValidator(100000)], verbose_name='epoch of perihelion')),
                ('extra_params', django.contrib.postgres.fields.jsonb.JSONField(default=dict, help_text='Extra Target parameters', verbose_name='extra parameters')),
                ('configuration', models.OneToOneField(help_text='The configuration to which this Target belongs', on_delete=django.db.models.deletion.CASCADE, to='requestgroups.Configuration')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='Window',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(db_index=True, help_text='The time when this observing Window starts')),
                ('end', models.DateTimeField(db_index=True, help_text='The time when this observing Window ends')),
                ('request', models.ForeignKey(help_text='The Request to which this Window applies', on_delete=django.db.models.deletion.CASCADE, related_name='windows', to='requestgroups.Request')),
            ],
            options={
                'ordering': ('id',),
            },
        ),
        migrations.AddField(
            model_name='request',
            name='request_group',
            field=models.ForeignKey(help_text='The RequestGroup to which this Request belongs', on_delete=django.db.models.deletion.CASCADE, related_name='requests', to='requestgroups.RequestGroup'),
        ),
        migrations.AddField(
            model_name='location',
            name='request',
            field=models.OneToOneField(help_text='The Request to which this Location applies', on_delete=django.db.models.deletion.CASCADE, to='requestgroups.Request'),
        ),
        migrations.AddField(
            model_name='configuration',
            name='request',
            field=models.ForeignKey(help_text='The Request to which this Configuration belongs', on_delete=django.db.models.deletion.CASCADE, related_name='configurations', to='requestgroups.Request'),
        ),
        migrations.AddField(
            model_name='acquisitionconfig',
            name='configuration',
            field=models.OneToOneField(help_text='The Configuration to which this AcquisitionConfig belongs', on_delete=django.db.models.deletion.CASCADE, related_name='acquisition_config', to='requestgroups.Configuration'),
        ),
        migrations.AlterUniqueTogether(
            name='draftrequestgroup',
            unique_together={('author', 'proposal', 'title')},
        ),
    ]
