# Generated by Django 2.1.7 on 2019-03-19 18:13

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(choices=[('PI', 'Pricipal Investigator'), ('CI', 'Co-Investigator')], max_length=5)),
                ('time_limit', models.IntegerField(default=-1)),
            ],
        ),
        migrations.CreateModel(
            name='Proposal',
            fields=[
                ('id', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('active', models.BooleanField(default=True)),
                ('title', models.CharField(blank=True, default='', max_length=255)),
                ('abstract', models.TextField(blank=True, default='')),
                ('tac_priority', models.PositiveIntegerField(default=0)),
                ('tac_rank', models.PositiveIntegerField(default=0)),
                ('public', models.BooleanField(default=False)),
                ('non_science', models.BooleanField(default=False)),
                ('direct_submission', models.BooleanField(default=False)),
                ('notes', models.TextField(blank=True, default='', help_text='Add notes here. Not visible to users.')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='ProposalInvite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(choices=[('PI', 'Pricipal Investigator'), ('CI', 'Co-Investigator')], max_length=5)),
                ('email', models.EmailField(max_length=254)),
                ('sent', models.DateTimeField(null=True)),
                ('used', models.DateTimeField(null=True)),
                ('proposal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Proposal')),
            ],
        ),
        migrations.CreateModel(
            name='ProposalNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('proposal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Proposal')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ScienceCollaborationAllocation',
            fields=[
                ('id', models.CharField(max_length=20, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, default='', max_length=255)),
                ('one_meter_alloc', models.PositiveIntegerField(blank=True, default=0)),
                ('two_meter_alloc', models.PositiveIntegerField(blank=True, default=0)),
                ('four_meter_alloc', models.PositiveIntegerField(blank=True, default=0, verbose_name='0.4 Meter Alloc')),
                ('admin', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Semester',
            fields=[
                ('id', models.CharField(max_length=20, primary_key=True, serialize=False)),
                ('start', models.DateTimeField()),
                ('end', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='TimeAllocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ipp_limit', models.FloatField(default=0)),
                ('ipp_time_available', models.FloatField(default=0)),
                ('std_allocation', models.FloatField(default=0)),
                ('std_time_used', models.FloatField(default=0)),
                ('rr_allocation', models.FloatField(default=0)),
                ('rr_time_used', models.FloatField(default=0)),
                ('tc_allocation', models.FloatField(default=0)),
                ('tc_time_used', models.FloatField(default=0)),
                ('instrument_type', models.CharField(max_length=200)),
                ('proposal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Proposal')),
                ('semester', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Semester')),
            ],
            options={
                'ordering': ('-semester__id',),
            },
        ),
        migrations.AddField(
            model_name='semester',
            name='proposals',
            field=models.ManyToManyField(through='proposals.TimeAllocation', to='proposals.Proposal'),
        ),
        migrations.AddField(
            model_name='proposal',
            name='sca',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.ScienceCollaborationAllocation'),
        ),
        migrations.AddField(
            model_name='proposal',
            name='users',
            field=models.ManyToManyField(through='proposals.Membership', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='membership',
            name='proposal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='proposals.Proposal'),
        ),
        migrations.AddField(
            model_name='membership',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='proposalnotification',
            unique_together={('proposal', 'user')},
        ),
        migrations.AlterUniqueTogether(
            name='membership',
            unique_together={('user', 'proposal')},
        ),
    ]
