# Generated by Django 2.1.7 on 2019-03-19 18:13

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('requestgroups', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ConfigurationStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('instrument_name', models.CharField(help_text='The specific instrument used to observe the corresponding Configuration', max_length=255)),
                ('guide_camera_name', models.CharField(blank=True, default='', help_text='The specific autoguider camera name to observe in the corresponding Configuration', max_length=255)),
                ('state', models.CharField(choices=[('PENDING', 'PENDING'), ('ATTEMPTED', 'ATTEMPTED'), ('COMPLETED', 'COMPLETED'), ('FAILED', 'FAILED')], default='PENDING', help_text='Current state of this Configuration Status', max_length=40)),
                ('modified', models.DateTimeField(auto_now=True, help_text='Time when this Configuration Status was last changed')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='Time when this Configuration Status was created')),
                ('configuration', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='configuration_status', to='requestgroups.Configuration')),
            ],
            options={
                'verbose_name_plural': 'Configuration statuses',
            },
        ),
        migrations.CreateModel(
            name='Observation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('site', models.CharField(db_index=True, help_text='3 character site code', max_length=10)),
                ('enclosure', models.CharField(help_text='4 character enclosure code', max_length=10)),
                ('telescope', models.CharField(help_text='4 character telescope code', max_length=10)),
                ('start', models.DateTimeField(db_index=True, help_text='Start time of observation')),
                ('end', models.DateTimeField(help_text='End time of observation')),
                ('modified', models.DateTimeField(auto_now=True, db_index=True, help_text='Time when this Observation was last changed')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='Time when this Observation was created')),
                ('state', models.CharField(choices=[('PENDING', 'PENDING'), ('IN_PROGRESS', 'IN_PROGRESS'), ('COMPLETED', 'COMPLETED'), ('CANCELED', 'CANCELED'), ('ABORTED', 'ABORTED'), ('FAILED', 'FAILED')], db_index=True, default='PENDING', help_text='Current State of this Observation', max_length=40)),
                ('request', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='requestgroups.Request')),
            ],
        ),
        migrations.CreateModel(
            name='Summary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(db_index=True, help_text='Actual start time of configuration')),
                ('end', models.DateTimeField(help_text='Actual end time of configuration')),
                ('modified', models.DateTimeField(auto_now=True, help_text='Time when this Event was last changed')),
                ('created', models.DateTimeField(auto_now_add=True, help_text='Time when this Event was created')),
                ('state', models.CharField(help_text='The overall state of the set of events', max_length=50)),
                ('reason', models.CharField(blank=True, default='', help_text='If state is not COMPLETED, this contains the failure reason', max_length=200)),
                ('time_completed', models.FloatField(help_text='The seconds of exposure time completed for this configuration')),
                ('events', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, help_text='Raw set of telescope events during this observation, in json format')),
                ('configuration_status', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='summary', to='observations.ConfigurationStatus')),
            ],
            options={
                'verbose_name_plural': 'Summaries',
            },
        ),
        migrations.AddField(
            model_name='configurationstatus',
            name='observation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='configuration_statuses', to='observations.Observation'),
        ),
        migrations.AlterUniqueTogether(
            name='configurationstatus',
            unique_together={('configuration', 'observation')},
        ),
    ]
