# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the terms described in the LICENSE file in
# the root directory of this source tree.

from .config import PGVectorConfig


async def get_adapter_impl(config: PGVectorConfig, _deps):
    from .pgvector import PGVectorMemoryAdapter

    impl = PGVectorMemoryAdapter(config)
    await impl.initialize()
    return impl
