# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the terms described in the LICENSE file in
# the root directory of this source tree.

from .config import DatabricksImplConfig
from .databricks import DatabricksInferenceAdapter


async def get_adapter_impl(config: DatabricksImplConfig, _deps):
    assert isinstance(
        config, DatabricksImplConfig
    ), f"Unexpected config type: {type(config)}"
    impl = DatabricksInferenceAdapter(config)
    await impl.initialize()
    return impl
