ELEMENTS_DATA = [
{   "name": "hydrogen",
    "symbol": "H",
    "atomic_number": 1,
    "atomic_mass": 1.008,
    "electrons_per_shell": (1,),
    "state": "gas",
    "group": 1,
    "period": 1,
    "melting_point_k": 13.99,
    "boiling_point_k": 20.271,
    "density": 8.988e-05,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Henry Cavendish",
    "discovery_year": 1766},

{   "name": "helium",
    "symbol": "He",
    "atomic_number": 2,
    "atomic_mass": 4.0026,
    "electrons_per_shell": (2,),
    "state": "gas",
    "group": 18,
    "period": 1,
    "melting_point_k": 0.95,
    "boiling_point_k": 4.222,
    "density": 0.0001786,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Pierre Janssen, Norman Lockyer",
    "discovery_year": 1868},

{   "name": "lithium",
    "symbol": "Li",
    "atomic_number": 3,
    "atomic_mass": 6.94,
    "electrons_per_shell": (2, 1),
    "state": "solid",
    "group": 1,
    "period": 2,
    "melting_point_k": 453.65,
    "boiling_point_k": 1603,
    "density": 0.534,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Johan August Arfwedson",
    "discovery_year": 1817},

{   "name": "beryllium",
    "symbol": "Be",
    "atomic_number": 4,
    "atomic_mass": 9.0122,
    "electrons_per_shell": (2, 2),
    "state": "solid",
    "group": 2,
    "period": 2,
    "melting_point_k": 1560,
    "boiling_point_k": 2742,
    "density": 1.85,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Louis Nicolas Vauquelin",
    "discovery_year": 1798},

{   "name": "boron",
    "symbol": "B",
    "atomic_number": 5,
    "atomic_mass": 10.81,
    "electrons_per_shell": (2, 3),
    "state": "solid",
    "group": 13,
    "period": 2,
    "melting_point_k": 2349,
    "boiling_point_k": 4200,
    "density": 2.34,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Joseph Louis Gay-Lussac, Louis Jacques Thénard",
    "discovery_year": 1808},

{   "name": "carbon",
    "symbol": "C",
    "atomic_number": 6,
    "atomic_mass": 12.011,
    "electrons_per_shell": (2, 4),
    "state": "solid",
    "group": 14,
    "period": 2,
    "melting_point_k": 3823,
    "boiling_point_k": 5100,
    "density": 2.27,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Antoine Lavoisier",
    "discovery_year": 1789},

{   "name": "nitrogen",
    "symbol": "N",
    "atomic_number": 7,
    "atomic_mass": 14.007,
    "electrons_per_shell": (2, 5),
    "state": "gas",
    "group": 15,
    "period": 2,
    "melting_point_k": 63.23,
    "boiling_point_k": 77.355,
    "density": 0.00125,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Daniel Rutherford",
    "discovery_year": 1772},

{   "name": "oxygen",
    "symbol": "O",
    "atomic_number": 8,
    "atomic_mass": 15.999,
    "electrons_per_shell": (2, 6),
    "state": "gas",
    "group": 16,
    "period": 2,
    "melting_point_k": 54.36,
    "boiling_point_k": 90.188,
    "density": 0.001429,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Wilhelm Scheele",
    "discovery_year": 1771},

{   "name": "fluorine",
    "symbol": "F",
    "atomic_number": 9,
    "atomic_mass": 18.998,
    "electrons_per_shell": (2, 7),
    "state": "gas",
    "group": 17,
    "period": 2,
    "melting_point_k": 53.48,
    "boiling_point_k": 85.03,
    "density": 0.001696,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "André-Marie Ampère",
    "discovery_year": 1810},

{   "name": "neon",
    "symbol": "Ne",
    "atomic_number": 10,
    "atomic_mass": 20.18,
    "electrons_per_shell": (2, 8),
    "state": "gas",
    "group": 18,
    "period": 2,
    "melting_point_k": 24.56,
    "boiling_point_k": 27.104,
    "density": 0.0009002,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Ramsay, Morris Travers",
    "discovery_year": 1898},

{   "name": "sodium",
    "symbol": "Na",
    "atomic_number": 11,
    "atomic_mass": 22.99,
    "electrons_per_shell": (2, 8, 1),
    "state": "solid",
    "group": 1,
    "period": 3,
    "melting_point_k": 370.944,
    "boiling_point_k": 1156.09,
    "density": 0.968,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Humphry Davy",
    "discovery_year": 1807},

{   "name": "magnesium",
    "symbol": "Mg",
    "atomic_number": 12,
    "atomic_mass": 24.305,
    "electrons_per_shell": (2, 8, 2),
    "state": "solid",
    "group": 2,
    "period": 3,
    "melting_point_k": 923,
    "boiling_point_k": 1363,
    "density": 1.738,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Joseph Black",
    "discovery_year": 1755},

{   "name": "aluminium",
    "symbol": "Al",
    "atomic_number": 13,
    "atomic_mass": 26.982,
    "electrons_per_shell": (2, 8, 3),
    "state": "solid",
    "group": 13,
    "period": 3,
    "melting_point_k": 933.47,
    "boiling_point_k": 2743,
    "density": 2.7,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Hans Christian Ørsted",
    "discovery_year": 1824},

{   "name": "silicon",
    "symbol": "Si",
    "atomic_number": 14,
    "atomic_mass": 28.085,
    "electrons_per_shell": (2, 8, 4),
    "state": "solid",
    "group": 14,
    "period": 3,
    "melting_point_k": 1414,
    "boiling_point_k": 3538,
    "density": 2.329,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Jöns Jacob Berzelius",
    "discovery_year": 1823},

{   "name": "phosphorus",
    "symbol": "P",
    "atomic_number": 15,
    "atomic_mass": 30.974,
    "electrons_per_shell": (2, 8, 5),
    "state": "solid",
    "group": 15,
    "period": 3,
    "melting_point_k": 317.3,
    "boiling_point_k": 553.7,
    "density": 1.823,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Hennig Brand",
    "discovery_year": 1669},

{   "name": "sulfur",
    "symbol": "S",
    "atomic_number": 16,
    "atomic_mass": 32.06,
    "electrons_per_shell": (2, 8, 6),
    "state": "solid",
    "group": 16,
    "period": 3,
    "melting_point_k": 388.36,
    "boiling_point_k": 717.8,
    "density": 2.07,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Antoine Lavoisier",
    "discovery_year": 1777},

{   "name": "chlorine",
    "symbol": "Cl",
    "atomic_number": 17,
    "atomic_mass": 35.45,
    "electrons_per_shell": (2, 8, 7),
    "state": "gas",
    "group": 17,
    "period": 3,
    "melting_point_k": 171.6,
    "boiling_point_k": 239.11,
    "density": 0.0032,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Wilhelm Scheele",
    "discovery_year": 1774},

{   "name": "argon",
    "symbol": "Ar",
    "atomic_number": 18,
    "atomic_mass": 39.95,
    "electrons_per_shell": (2, 8, 8),
    "state": "gas",
    "group": 18,
    "period": 3,
    "melting_point_k": 83.81,
    "boiling_point_k": 87.302,
    "density": 0.001784,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Lord Rayleigh, William Ramsay",
    "discovery_year": 1894},

{   "name": "potassium",
    "symbol": "K",
    "atomic_number": 19,
    "atomic_mass": 39.098,
    "electrons_per_shell": (2, 8, 8, 1),
    "state": "solid",
    "group": 1,
    "period": 4,
    "melting_point_k": 336.7,
    "boiling_point_k": 1032,
    "density": 0.89,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Humphry Davy",
    "discovery_year": 1807},

{   "name": "calcium",
    "symbol": "Ca",
    "atomic_number": 20,
    "atomic_mass": 40.078,
    "electrons_per_shell": (2, 8, 8, 2),
    "state": "solid",
    "group": 2,
    "period": 4,
    "melting_point_k": 1115,
    "boiling_point_k": 1757,
    "density": 1.55,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Humphry Davy",
    "discovery_year": 1808},

{   "name": "scandium",
    "symbol": "Sc",
    "atomic_number": 21,
    "atomic_mass": 44.956,
    "electrons_per_shell": (2, 8, 9, 2),
    "state": "solid",
    "group": 3,
    "period": 4,
    "melting_point_k": 1814,
    "boiling_point_k": 3109,
    "density": 2.985,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Lars Fredrik Nilson",
    "discovery_year": 1879},

{   "name": "titanium",
    "symbol": "Ti",
    "atomic_number": 22,
    "atomic_mass": 47.867,
    "electrons_per_shell": (2, 8, 10, 2),
    "state": "solid",
    "group": 4,
    "period": 4,
    "melting_point_k": 1941,
    "boiling_point_k": 3560,
    "density": 4.506,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Gregor",
    "discovery_year": 1791},

{   "name": "vanadium",
    "symbol": "V",
    "atomic_number": 23,
    "atomic_mass": 50.942,
    "electrons_per_shell": (2, 8, 11, 2),
    "state": "solid",
    "group": 5,
    "period": 4,
    "melting_point_k": 2183,
    "boiling_point_k": 3680,
    "density": 6.11,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Nils Gabriel Sefström",
    "discovery_year": 1830},

{   "name": "chromium",
    "symbol": "Cr",
    "atomic_number": 24,
    "atomic_mass": 51.996,
    "electrons_per_shell": (2, 8, 13, 1),
    "state": "solid",
    "group": 6,
    "period": 4,
    "melting_point_k": 2180,
    "boiling_point_k": 2944,
    "density": 7.15,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Louis Nicolas Vauquelin",
    "discovery_year": 1794},

{   "name": "manganese",
    "symbol": "Mn",
    "atomic_number": 25,
    "atomic_mass": 54.938,
    "electrons_per_shell": (2, 8, 13, 2),
    "state": "solid",
    "group": 7,
    "period": 4,
    "melting_point_k": 1519,
    "boiling_point_k": 2334,
    "density": 7.21,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Wilhelm Scheele",
    "discovery_year": 1774},

{   "name": "iron",
    "symbol": "Fe",
    "atomic_number": 26,
    "atomic_mass": 55.845,
    "electrons_per_shell": (2, 8, 14, 2),
    "state": "solid",
    "group": 8,
    "period": 4,
    "melting_point_k": 1811,
    "boiling_point_k": 3134,
    "density": 7.874,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": None,
    "discovery_year": None},

{   "name": "cobalt",
    "symbol": "Co",
    "atomic_number": 27,
    "atomic_mass": 58.933,
    "electrons_per_shell": (2, 8, 15, 2),
    "state": "solid",
    "group": 9,
    "period": 4,
    "melting_point_k": 1768,
    "boiling_point_k": 3200,
    "density": 8.9,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Georg Brandt",
    "discovery_year": 1735},

{   "name": "nickel",
    "symbol": "Ni",
    "atomic_number": 28,
    "atomic_mass": 58.693,
    "electrons_per_shell": (2, 8, 16, 2),
    "state": "solid",
    "group": 10,
    "period": 4,
    "melting_point_k": 1728,
    "boiling_point_k": 3003,
    "density": 8.908,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Axel Fredrik Cronstedt",
    "discovery_year": 1751},

{   "name": "copper",
    "symbol": "Cu",
    "atomic_number": 29,
    "atomic_mass": 63.546,
    "electrons_per_shell": (2, 8, 18, 1),
    "state": "solid",
    "group": 11,
    "period": 4,
    "melting_point_k": 1357.77,
    "boiling_point_k": 2835,
    "density": 8.96,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Middle East",
    "discovery_year": -9000},

{   "name": "zinc",
    "symbol": "Zn",
    "atomic_number": 30,
    "atomic_mass": 65.38,
    "electrons_per_shell": (2, 8, 18, 2),
    "state": "solid",
    "group": 12,
    "period": 4,
    "melting_point_k": 692.68,
    "boiling_point_k": 1180,
    "density": 7.14,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Andreas Sigismund Marggraf",
    "discovery_year": 1746},

{   "name": "gallium",
    "symbol": "Ga",
    "atomic_number": 31,
    "atomic_mass": 69.723,
    "electrons_per_shell": (2, 8, 18, 3),
    "state": "solid",
    "group": 13,
    "period": 4,
    "melting_point_k": 302.9146,
    "boiling_point_k": 2673,
    "density": 5.91,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Lecoq de Boisbaudran",
    "discovery_year": 1875},

{   "name": "germanium",
    "symbol": "Ge",
    "atomic_number": 32,
    "atomic_mass": 72.63,
    "electrons_per_shell": (2, 8, 18, 4),
    "state": "solid",
    "group": 14,
    "period": 4,
    "melting_point_k": 1211.4,
    "boiling_point_k": 3106,
    "density": 5.323,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Clemens Winkler",
    "discovery_year": 1886},

{   "name": "arsenic",
    "symbol": "As",
    "atomic_number": 33,
    "atomic_mass": 74.922,
    "electrons_per_shell": (2, 8, 18, 5),
    "state": "solid",
    "group": 15,
    "period": 4,
    "melting_point_k": 1090,
    "boiling_point_k": 887,
    "density": 5.727,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Albertus Magnus",
    "discovery_year": 1250},

{   "name": "selenium",
    "symbol": "Se",
    "atomic_number": 34,
    "atomic_mass": 78.971,
    "electrons_per_shell": (2, 8, 18, 6),
    "state": "solid",
    "group": 16,
    "period": 4,
    "melting_point_k": 494,
    "boiling_point_k": 958,
    "density": 4.81,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Jöns Jakob Berzelius",
    "discovery_year": 1817},

{   "name": "bromine",
    "symbol": "Br",
    "atomic_number": 35,
    "atomic_mass": 79.904,
    "electrons_per_shell": (2, 8, 18, 7),
    "state": "liquid",
    "group": 17,
    "period": 4,
    "melting_point_k": 265.8,
    "boiling_point_k": 332,
    "density": 3.1028,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Antoine Jérôme Balard",
    "discovery_year": 1825},

{   "name": "krypton",
    "symbol": "Kr",
    "atomic_number": 36,
    "atomic_mass": 83.798,
    "electrons_per_shell": (2, 8, 18, 8),
    "state": "gas",
    "group": 18,
    "period": 4,
    "melting_point_k": 115.78,
    "boiling_point_k": 119.93,
    "density": 0.003749,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Ramsay, Morris Travers",
    "discovery_year": 1898},

{   "name": "rubidium",
    "symbol": "Rb",
    "atomic_number": 37,
    "atomic_mass": 85.468,
    "electrons_per_shell": (2, 8, 18, 8, 1),
    "state": "solid",
    "group": 1,
    "period": 5,
    "melting_point_k": 312.45,
    "boiling_point_k": 961,
    "density": 1.532,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Robert Bunsen, Gustav Kirchhoff",
    "discovery_year": 1861},

{   "name": "strontium",
    "symbol": "Sr",
    "atomic_number": 38,
    "atomic_mass": 87.62,
    "electrons_per_shell": (2, 8, 18, 8, 2),
    "state": "solid",
    "group": 2,
    "period": 5,
    "melting_point_k": 1050,
    "boiling_point_k": 1650,
    "density": 2.64,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Cruickshank",
    "discovery_year": 1787},

{   "name": "yttrium",
    "symbol": "Y",
    "atomic_number": 39,
    "atomic_mass": 88.906,
    "electrons_per_shell": (2, 8, 18, 9, 2),
    "state": "solid",
    "group": 3,
    "period": 5,
    "melting_point_k": 1799,
    "boiling_point_k": 3203,
    "density": 4.472,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Johan Gadolin",
    "discovery_year": 1794},

{   "name": "zirconium",
    "symbol": "Zr",
    "atomic_number": 40,
    "atomic_mass": 91.224,
    "electrons_per_shell": (2, 8, 18, 10, 2),
    "state": "solid",
    "group": 4,
    "period": 5,
    "melting_point_k": 2125,
    "boiling_point_k": 4650,
    "density": 6.52,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Martin Heinrich Klaproth",
    "discovery_year": 1789},

{   "name": "niobium",
    "symbol": "Nb",
    "atomic_number": 41,
    "atomic_mass": 92.906,
    "electrons_per_shell": (2, 8, 18, 12, 1),
    "state": "solid",
    "group": 5,
    "period": 5,
    "melting_point_k": 2750,
    "boiling_point_k": 5017,
    "density": 8.57,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Charles Hatchett",
    "discovery_year": 1801},

{   "name": "molybdenum",
    "symbol": "Mo",
    "atomic_number": 42,
    "atomic_mass": 95.95,
    "electrons_per_shell": (2, 8, 18, 13, 1),
    "state": "solid",
    "group": 6,
    "period": 5,
    "melting_point_k": 2896,
    "boiling_point_k": 4912,
    "density": 10.28,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Wilhelm Scheele",
    "discovery_year": 1778},

{   "name": "technetium",
    "symbol": "Tc",
    "atomic_number": 43,
    "atomic_mass": 98,
    "electrons_per_shell": (2, 8, 18, 13, 2),
    "state": "solid",
    "group": 7,
    "period": 5,
    "melting_point_k": 2430,
    "boiling_point_k": 4538,
    "density": 11,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Emilio Segrè, Carlo Perrier",
    "discovery_year": 1937},

{   "name": "ruthenium",
    "symbol": "Ru",
    "atomic_number": 44,
    "atomic_mass": 101.07,
    "electrons_per_shell": (2, 8, 18, 15, 1),
    "state": "solid",
    "group": 8,
    "period": 5,
    "melting_point_k": 2607,
    "boiling_point_k": 4423,
    "density": 12.45,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Karl Ernst Claus",
    "discovery_year": 1844},

{   "name": "rhodium",
    "symbol": "Rh",
    "atomic_number": 45,
    "atomic_mass": 102.91,
    "electrons_per_shell": (2, 8, 18, 16, 1),
    "state": "solid",
    "group": 9,
    "period": 5,
    "melting_point_k": 2237,
    "boiling_point_k": 3968,
    "density": 12.41,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Hyde Wollaston",
    "discovery_year": 1804},

{   "name": "palladium",
    "symbol": "Pd",
    "atomic_number": 46,
    "atomic_mass": 106.42,
    "electrons_per_shell": (2, 8, 18, 18),
    "state": "solid",
    "group": 10,
    "period": 5,
    "melting_point_k": 1828.05,
    "boiling_point_k": 3236,
    "density": 12.023,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Hyde Wollaston",
    "discovery_year": 1802},

{   "name": "silver",
    "symbol": "Ag",
    "atomic_number": 47,
    "atomic_mass": 107.87,
    "electrons_per_shell": (2, 8, 18, 18, 1),
    "state": "solid",
    "group": 11,
    "period": 5,
    "melting_point_k": 1234.93,
    "boiling_point_k": 2435,
    "density": 10.49,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": None,
    "discovery_year": None},

{   "name": "cadmium",
    "symbol": "Cd",
    "atomic_number": 48,
    "atomic_mass": 112.41,
    "electrons_per_shell": (2, 8, 18, 18, 2),
    "state": "solid",
    "group": 12,
    "period": 5,
    "melting_point_k": 594.22,
    "boiling_point_k": 1040,
    "density": 8.65,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Karl Samuel Leberecht Hermann, Friedrich Stromeyer",
    "discovery_year": 1817},

{   "name": "indium",
    "symbol": "In",
    "atomic_number": 49,
    "atomic_mass": 114.82,
    "electrons_per_shell": (2, 8, 18, 18, 3),
    "state": "solid",
    "group": 13,
    "period": 5,
    "melting_point_k": 429.7485,
    "boiling_point_k": 2345,
    "density": 7.31,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Ferdinand Reich, Hieronymous Theodor Richter",
    "discovery_year": 1863},

{   "name": "tin",
    "symbol": "Sn",
    "atomic_number": 50,
    "atomic_mass": 118.71,
    "electrons_per_shell": (2, 8, 18, 18, 4),
    "state": "solid",
    "group": 14,
    "period": 5,
    "melting_point_k": 505.08,
    "boiling_point_k": 2875,
    "density": 7.265,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": None,
    "discovery_year": None},

{   "name": "antimony",
    "symbol": "Sb",
    "atomic_number": 51,
    "atomic_mass": 121.76,
    "electrons_per_shell": (2, 8, 18, 18, 5),
    "state": "solid",
    "group": 15,
    "period": 5,
    "melting_point_k": 903.78,
    "boiling_point_k": 1908,
    "density": 6.697,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": None,
    "discovery_year": None},

{   "name": "tellurium",
    "symbol": "Te",
    "atomic_number": 52,
    "atomic_mass": 127.6,
    "electrons_per_shell": (2, 8, 18, 18, 6),
    "state": "solid",
    "group": 16,
    "period": 5,
    "melting_point_k": 722.66,
    "boiling_point_k": 1261,
    "density": 6.24,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Franz-Joseph Müller von Reichenstein",
    "discovery_year": 1782},

{   "name": "iodine",
    "symbol": "I",
    "atomic_number": 53,
    "atomic_mass": 126.9,
    "electrons_per_shell": (2, 8, 18, 18, 7),
    "state": "solid",
    "group": 17,
    "period": 5,
    "melting_point_k": 386.85,
    "boiling_point_k": 457.4,
    "density": 4.933,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Bernard Courtois",
    "discovery_year": 1811},

{   "name": "xenon",
    "symbol": "Xe",
    "atomic_number": 54,
    "atomic_mass": 131.29,
    "electrons_per_shell": (2, 8, 18, 18, 8),
    "state": "gas",
    "group": 18,
    "period": 5,
    "melting_point_k": 161.4,
    "boiling_point_k": 165.051,
    "density": 0.005894,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Ramsay, Morris Travers",
    "discovery_year": 1898},

{   "name": "caesium",
    "symbol": "Cs",
    "atomic_number": 55,
    "atomic_mass": 132.91,
    "electrons_per_shell": (2, 8, 18, 18, 8, 1),
    "state": "solid",
    "group": 1,
    "period": 6,
    "melting_point_k": 301.7,
    "boiling_point_k": 944,
    "density": 1.93,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Robert Bunsen, Gustav Kirchhoff",
    "discovery_year": 1860},

{   "name": "barium",
    "symbol": "Ba",
    "atomic_number": 56,
    "atomic_mass": 137.33,
    "electrons_per_shell": (2, 8, 18, 18, 8, 2),
    "state": "solid",
    "group": 2,
    "period": 6,
    "melting_point_k": 1000,
    "boiling_point_k": 2118,
    "density": 3.51,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Wilhelm Scheele",
    "discovery_year": 1772},

{   "name": "lanthanum",
    "symbol": "La",
    "atomic_number": 57,
    "atomic_mass": 138.91,
    "electrons_per_shell": (2, 8, 18, 18, 9, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1193,
    "boiling_point_k": 3737,
    "density": 6.162,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Gustaf Mosander",
    "discovery_year": 1838},

{   "name": "cerium",
    "symbol": "Ce",
    "atomic_number": 58,
    "atomic_mass": 140.12,
    "electrons_per_shell": (2, 8, 18, 19, 9, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1068,
    "boiling_point_k": 3716,
    "density": 6.77,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Martin Heinrich Klaproth, Jöns Jakob Berzelius, Wilhelm "
                    "Hisinger",
    "discovery_year": 1803},

{   "name": "praseodymium",
    "symbol": "Pr",
    "atomic_number": 59,
    "atomic_mass": 140.91,
    "electrons_per_shell": (2, 8, 18, 21, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1208,
    "boiling_point_k": 3403,
    "density": 6.77,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Auer von Welsbach",
    "discovery_year": 1885},

{   "name": "neodymium",
    "symbol": "Nd",
    "atomic_number": 60,
    "atomic_mass": 144.24,
    "electrons_per_shell": (2, 8, 18, 22, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1297,
    "boiling_point_k": 3347,
    "density": 7.01,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Auer von Welsbach",
    "discovery_year": 1885},

{   "name": "promethium",
    "symbol": "Pm",
    "atomic_number": 61,
    "atomic_mass": 145,
    "electrons_per_shell": (2, 8, 18, 23, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1315,
    "boiling_point_k": 3273,
    "density": 7.26,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Charles D. Coryell, Jacob A. Marinsky, Lawrence E. "
                    "Glendenin",
    "discovery_year": 1945},

{   "name": "samarium",
    "symbol": "Sm",
    "atomic_number": 62,
    "atomic_mass": 150.36,
    "electrons_per_shell": (2, 8, 18, 24, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1345,
    "boiling_point_k": 2173,
    "density": 7.52,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Lecoq de Boisbaudran",
    "discovery_year": 1879},

{   "name": "europium",
    "symbol": "Eu",
    "atomic_number": 63,
    "atomic_mass": 151.96,
    "electrons_per_shell": (2, 8, 18, 25, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1099,
    "boiling_point_k": 1802,
    "density": 5.244,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Eugène-Anatole Demarçay",
    "discovery_year": 1896},

{   "name": "gadolinium",
    "symbol": "Gd",
    "atomic_number": 64,
    "atomic_mass": 157.25,
    "electrons_per_shell": (2, 8, 18, 25, 9, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1585,
    "boiling_point_k": 3273,
    "density": 7.9,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Jean Charles Galissard de Marignac",
    "discovery_year": 1880},

{   "name": "terbium",
    "symbol": "Tb",
    "atomic_number": 65,
    "atomic_mass": 158.93,
    "electrons_per_shell": (2, 8, 18, 27, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1629,
    "boiling_point_k": 3396,
    "density": 8.23,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Gustaf Mosander",
    "discovery_year": 1843},

{   "name": "dysprosium",
    "symbol": "Dy",
    "atomic_number": 66,
    "atomic_mass": 162.5,
    "electrons_per_shell": (2, 8, 18, 28, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1680,
    "boiling_point_k": 2840,
    "density": 8.54,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Lecoq de Boisbaudran",
    "discovery_year": 1886},

{   "name": "holmium",
    "symbol": "Ho",
    "atomic_number": 67,
    "atomic_mass": 164.93,
    "electrons_per_shell": (2, 8, 18, 29, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1734,
    "boiling_point_k": 2873,
    "density": 8.79,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Jacques-Louis Soret, Marc Delafontaine, Per Teodor Cleve",
    "discovery_year": 1878},

{   "name": "erbium",
    "symbol": "Er",
    "atomic_number": 68,
    "atomic_mass": 167.26,
    "electrons_per_shell": (2, 8, 18, 30, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1802,
    "boiling_point_k": 3141,
    "density": 9.066,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Gustaf Mosander",
    "discovery_year": 1843},

{   "name": "thulium",
    "symbol": "Tm",
    "atomic_number": 69,
    "atomic_mass": 168.93,
    "electrons_per_shell": (2, 8, 18, 31, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1818,
    "boiling_point_k": 2223,
    "density": 9.32,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Per Teodor Cleve",
    "discovery_year": 1879},

{   "name": "ytterbium",
    "symbol": "Yb",
    "atomic_number": 70,
    "atomic_mass": 173.05,
    "electrons_per_shell": (2, 8, 18, 32, 8, 2),
    "state": "solid",
    "group": None,
    "period": 6,
    "melting_point_k": 1097,
    "boiling_point_k": 1469,
    "density": 6.9,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Jean Charles Galissard de Marignac",
    "discovery_year": 1878},

{   "name": "lutetium",
    "symbol": "Lu",
    "atomic_number": 71,
    "atomic_mass": 174.97,
    "electrons_per_shell": (2, 8, 18, 32, 9, 2),
    "state": "solid",
    "group": 3,
    "period": 6,
    "melting_point_k": 1925,
    "boiling_point_k": 3675,
    "density": 9.841,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Carl Auer von Welsbach, Georges Urbain",
    "discovery_year": 1906},

{   "name": "hafnium",
    "symbol": "Hf",
    "atomic_number": 72,
    "atomic_mass": 178.49,
    "electrons_per_shell": (2, 8, 18, 32, 10, 2),
    "state": "solid",
    "group": 4,
    "period": 6,
    "melting_point_k": 2506,
    "boiling_point_k": 4876,
    "density": 13.31,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Dirk Coster, George de Hevesy",
    "discovery_year": 1922},

{   "name": "tantalum",
    "symbol": "Ta",
    "atomic_number": 73,
    "atomic_mass": 180.95,
    "electrons_per_shell": (2, 8, 18, 32, 11, 2),
    "state": "solid",
    "group": 5,
    "period": 6,
    "melting_point_k": 3290,
    "boiling_point_k": 5731,
    "density": 16.69,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Anders Gustaf Ekeberg",
    "discovery_year": 1802},

{   "name": "tungsten",
    "symbol": "W",
    "atomic_number": 74,
    "atomic_mass": 183.84,
    "electrons_per_shell": (2, 8, 18, 32, 12, 2),
    "state": "solid",
    "group": 6,
    "period": 6,
    "melting_point_k": 3695,
    "boiling_point_k": 6203,
    "density": 19.25,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Juan José Elhuyar, Fausto Elhuyar",
    "discovery_year": 1783},

{   "name": "rhenium",
    "symbol": "Re",
    "atomic_number": 75,
    "atomic_mass": 186.21,
    "electrons_per_shell": (2, 8, 18, 32, 13, 2),
    "state": "solid",
    "group": 7,
    "period": 6,
    "melting_point_k": 3459,
    "boiling_point_k": 5903,
    "density": 21.02,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Walter Noddack, Ida Noddack, Otto Berg",
    "discovery_year": 1925},

{   "name": "osmium",
    "symbol": "Os",
    "atomic_number": 76,
    "atomic_mass": 190.23,
    "electrons_per_shell": (2, 8, 18, 32, 14, 2),
    "state": "solid",
    "group": 8,
    "period": 6,
    "melting_point_k": 3306,
    "boiling_point_k": 5285,
    "density": 22.59,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Smithson Tennant",
    "discovery_year": 1803},

{   "name": "iridium",
    "symbol": "Ir",
    "atomic_number": 77,
    "atomic_mass": 192.22,
    "electrons_per_shell": (2, 8, 18, 32, 15, 2),
    "state": "solid",
    "group": 9,
    "period": 6,
    "melting_point_k": 2719,
    "boiling_point_k": 4403,
    "density": 22.56,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Smithson Tennant",
    "discovery_year": 1803},

{   "name": "platinum",
    "symbol": "Pt",
    "atomic_number": 78,
    "atomic_mass": 195.08,
    "electrons_per_shell": (2, 8, 18, 32, 17, 1),
    "state": "solid",
    "group": 10,
    "period": 6,
    "melting_point_k": 2041.4,
    "boiling_point_k": 4098,
    "density": 21.45,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Antonio de Ulloa",
    "discovery_year": 1735},

{   "name": "gold",
    "symbol": "Au",
    "atomic_number": 79,
    "atomic_mass": 196.97,
    "electrons_per_shell": (2, 8, 18, 32, 18, 1),
    "state": "solid",
    "group": 11,
    "period": 6,
    "melting_point_k": 1337.33,
    "boiling_point_k": 3243,
    "density": 19.3,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Middle East",
    "discovery_year": None},

{   "name": "mercury",
    "symbol": "Hg",
    "atomic_number": 80,
    "atomic_mass": 200.59,
    "electrons_per_shell": (2, 8, 18, 32, 18, 2),
    "state": "liquid",
    "group": 12,
    "period": 6,
    "melting_point_k": 234.321,
    "boiling_point_k": 629.88,
    "density": 13.534,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": None,
    "discovery_year": None},

{   "name": "thallium",
    "symbol": "Tl",
    "atomic_number": 81,
    "atomic_mass": 204.38,
    "electrons_per_shell": (2, 8, 18, 32, 18, 3),
    "state": "solid",
    "group": 13,
    "period": 6,
    "melting_point_k": 577,
    "boiling_point_k": 1746,
    "density": 11.85,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "William Crookes",
    "discovery_year": 1861},

{   "name": "lead",
    "symbol": "Pb",
    "atomic_number": 82,
    "atomic_mass": 207.2,
    "electrons_per_shell": (2, 8, 18, 32, 18, 4),
    "state": "solid",
    "group": 14,
    "period": 6,
    "melting_point_k": 600.61,
    "boiling_point_k": 2022,
    "density": 11.34,
    "natural": True,
    "has_stable_isotope": True,
    "discovery": "Middle East",
    "discovery_year": None},

{   "name": "bismuth",
    "symbol": "Bi",
    "atomic_number": 83,
    "atomic_mass": 208.98,
    "electrons_per_shell": (2, 8, 18, 32, 18, 5),
    "state": "solid",
    "group": 15,
    "period": 6,
    "melting_point_k": 544.7,
    "boiling_point_k": 1837,
    "density": 9.78,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Claude François Geoffroy",
    "discovery_year": 1753},

{   "name": "polonium",
    "symbol": "Po",
    "atomic_number": 84,
    "atomic_mass": 209,
    "electrons_per_shell": (2, 8, 18, 32, 18, 6),
    "state": "solid",
    "group": 16,
    "period": 6,
    "melting_point_k": 527,
    "boiling_point_k": 1235,
    "density": 9.196,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Marie Curie, Pierre Curie",
    "discovery_year": 1898},

{   "name": "astatine",
    "symbol": "At",
    "atomic_number": 85,
    "atomic_mass": 210,
    "electrons_per_shell": (2, 8, 18, 32, 18, 7),
    "state": None,
    "group": 17,
    "period": 6,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Dale R. Corson, Kenneth R. Mackenzie, Emilio Segre",
    "discovery_year": 1940},

{   "name": "radon",
    "symbol": "Rn",
    "atomic_number": 86,
    "atomic_mass": 222,
    "electrons_per_shell": (2, 8, 18, 32, 18, 8),
    "state": "gas",
    "group": 18,
    "period": 6,
    "melting_point_k": 202,
    "boiling_point_k": 211.5,
    "density": 0.00973,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Ernest Rutherford, Robert B. Owens",
    "discovery_year": 1899},

{   "name": "francium",
    "symbol": "Fr",
    "atomic_number": 87,
    "atomic_mass": 223,
    "electrons_per_shell": (2, 8, 18, 32, 18, 8, 1),
    "state": "solid",
    "group": 1,
    "period": 7,
    "melting_point_k": 300,
    "boiling_point_k": 950,
    "density": None,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Marguerite Perey",
    "discovery_year": 1939},

{   "name": "radium",
    "symbol": "Ra",
    "atomic_number": 88,
    "atomic_mass": 226,
    "electrons_per_shell": (2, 8, 18, 32, 18, 8, 2),
    "state": "solid",
    "group": 2,
    "period": 7,
    "melting_point_k": 973,
    "boiling_point_k": 2010,
    "density": 5.5,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Marie Curie, Pierre Curie",
    "discovery_year": 1898},

{   "name": "actinium",
    "symbol": "Ac",
    "atomic_number": 89,
    "atomic_mass": 227,
    "electrons_per_shell": (2, 8, 18, 32, 18, 9, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1323,
    "boiling_point_k": 3473,
    "density": 10,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Friedrich Oskar Giesel",
    "discovery_year": 1902},

{   "name": "thorium",
    "symbol": "Th",
    "atomic_number": 90,
    "atomic_mass": 232.04,
    "electrons_per_shell": (2, 8, 18, 32, 18, 10, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 2023,
    "boiling_point_k": 5061,
    "density": 11.7,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Jöns Jakob Berzelius",
    "discovery_year": 1829},

{   "name": "protactinium",
    "symbol": "Pa",
    "atomic_number": 91,
    "atomic_mass": 231.04,
    "electrons_per_shell": (2, 8, 18, 32, 20, 9, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1841,
    "boiling_point_k": 4300,
    "density": 15.37,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Kasimir Fajans, Oswald Helmuth Göhring",
    "discovery_year": 1913},

{   "name": "uranium",
    "symbol": "U",
    "atomic_number": 92,
    "atomic_mass": 238.03,
    "electrons_per_shell": (2, 8, 18, 32, 21, 9, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1405.3,
    "boiling_point_k": 4404,
    "density": 19.1,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Martin Heinrich Klaproth",
    "discovery_year": 1789},

{   "name": "neptunium",
    "symbol": "Np",
    "atomic_number": 93,
    "atomic_mass": 237,
    "electrons_per_shell": (2, 8, 18, 32, 22, 9, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 912,
    "boiling_point_k": None,
    "density": 20.45,
    "natural": True,
    "has_stable_isotope": False,
    "discovery": "Edwin McMillan, Philip H. Abelson",
    "discovery_year": 1940},

{   "name": "plutonium",
    "symbol": "Pu",
    "atomic_number": 94,
    "atomic_mass": 244,
    "electrons_per_shell": (2, 8, 18, 32, 24, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 912.5,
    "boiling_point_k": 3505,
    "density": 19.85,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Glenn T. Seaborg, Arthur Wahl, Joseph W. Kennedy, Edwin "
                    "McMillan",
    "discovery_year": 1940},

{   "name": "americium",
    "symbol": "Am",
    "atomic_number": 95,
    "atomic_mass": 243,
    "electrons_per_shell": (2, 8, 18, 32, 25, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1449,
    "boiling_point_k": None,
    "density": 12,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Glenn T. Seaborg, Ralph A. James, Leon O. Morgan, Albert "
                    "Ghiorso",
    "discovery_year": 1944},

{   "name": "curium",
    "symbol": "Cm",
    "atomic_number": 96,
    "atomic_mass": 247,
    "electrons_per_shell": (2, 8, 18, 32, 25, 9, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1613,
    "boiling_point_k": 3383,
    "density": 13.51,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Glenn T. Seaborg, Ralph A. James, Albert Ghiorso",
    "discovery_year": 1944},

{   "name": "berkelium",
    "symbol": "Bk",
    "atomic_number": 97,
    "atomic_mass": 247,
    "electrons_per_shell": (2, 8, 18, 32, 27, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1259,
    "boiling_point_k": None,
    "density": 14.78,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory",
    "discovery_year": 1949},

{   "name": "californium",
    "symbol": "Cf",
    "atomic_number": 98,
    "atomic_mass": 251,
    "electrons_per_shell": (2, 8, 18, 32, 28, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1173,
    "boiling_point_k": None,
    "density": 15.1,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory",
    "discovery_year": 1950},

{   "name": "einsteinium",
    "symbol": "Es",
    "atomic_number": 99,
    "atomic_mass": 252,
    "electrons_per_shell": (2, 8, 18, 32, 29, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1133,
    "boiling_point_k": None,
    "density": 8.84,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory",
    "discovery_year": 1952},

{   "name": "fermium",
    "symbol": "Fm",
    "atomic_number": 100,
    "atomic_mass": 257,
    "electrons_per_shell": (2, 8, 18, 32, 30, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1800,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory",
    "discovery_year": 1952},

{   "name": "mendelevium",
    "symbol": "Md",
    "atomic_number": 101,
    "atomic_mass": 258,
    "electrons_per_shell": (2, 8, 18, 32, 31, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1100,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory",
    "discovery_year": 1955},

{   "name": "nobelium",
    "symbol": "No",
    "atomic_number": 102,
    "atomic_mass": 259,
    "electrons_per_shell": (2, 8, 18, 32, 32, 8, 2),
    "state": "solid",
    "group": None,
    "period": 7,
    "melting_point_k": 1100,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research",
    "discovery_year": 1966},

{   "name": "lawrencium",
    "symbol": "Lr",
    "atomic_number": 103,
    "atomic_mass": 266,
    "electrons_per_shell": (2, 8, 18, 32, 32, 8, 3),
    "state": "solid",
    "group": 3,
    "period": 7,
    "melting_point_k": 1900,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory, Joint Institute "
                    "for Nuclear Research",
    "discovery_year": 1961},

{   "name": "rutherfordium",
    "symbol": "Rf",
    "atomic_number": 104,
    "atomic_mass": 267,
    "electrons_per_shell": (2, 8, 18, 32, 32, 10, 2),
    "state": "solid",
    "group": 4,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research",
    "discovery_year": 1964},

{   "name": "dubnium",
    "symbol": "Db",
    "atomic_number": 105,
    "atomic_mass": 268,
    "electrons_per_shell": (2, 8, 18, 32, 32, 11, 2),
    "state": "solid",
    "group": 5,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory, Joint Institute "
                    "for Nuclear Research",
    "discovery_year": 1970},

{   "name": "seaborgium",
    "symbol": "Sg",
    "atomic_number": 106,
    "atomic_mass": 269,
    "electrons_per_shell": (2, 8, 18, 32, 32, 12, 2),
    "state": "solid",
    "group": 6,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Lawrence Berkeley National Laboratory",
    "discovery_year": 1974},

{   "name": "bohrium",
    "symbol": "Bh",
    "atomic_number": 107,
    "atomic_mass": 270,
    "electrons_per_shell": (2, 8, 18, 32, 32, 13, 2),
    "state": "solid",
    "group": 7,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Gesellschaft für Schwerionenforschung",
    "discovery_year": 1981},

{   "name": "hassium",
    "symbol": "Hs",
    "atomic_number": 108,
    "atomic_mass": 269,
    "electrons_per_shell": (2, 8, 18, 32, 32, 14, 2),
    "state": "solid",
    "group": 8,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Gesellschaft für Schwerionenforschung",
    "discovery_year": 1984},

{   "name": "meitnerium",
    "symbol": "Mt",
    "atomic_number": 109,
    "atomic_mass": 278,
    "electrons_per_shell": (2, 8, 18, 32, 32, 15, 2),
    "state": "solid",
    "group": 9,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Gesellschaft für Schwerionenforschung",
    "discovery_year": 1982},

{   "name": "darmstadtium",
    "symbol": "Ds",
    "atomic_number": 110,
    "atomic_mass": 281,
    "electrons_per_shell": (2, 8, 18, 32, 32, 16, 2),
    "state": "solid",
    "group": 10,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Gesellschaft für Schwerionenforschung",
    "discovery_year": 1994},

{   "name": "roentgenium",
    "symbol": "Rg",
    "atomic_number": 111,
    "atomic_mass": 282,
    "electrons_per_shell": (2, 8, 18, 32, 32, 17, 2),
    "state": "solid",
    "group": 11,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Gesellschaft für Schwerionenforschung",
    "discovery_year": 1994},

{   "name": "copernicium",
    "symbol": "Cn",
    "atomic_number": 112,
    "atomic_mass": 285,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 2),
    "state": None,
    "group": 12,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Gesellschaft für Schwerionenforschung",
    "discovery_year": 1996},

{   "name": "nihonium",
    "symbol": "Nh",
    "atomic_number": 113,
    "atomic_mass": 286,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 3),
    "state": "solid",
    "group": 13,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Riken",
    "discovery_year": 2004},

{   "name": "flerovium",
    "symbol": "Fl",
    "atomic_number": 114,
    "atomic_mass": 289,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 4),
    "state": None,
    "group": 14,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research, Lawrence Livermore "
                    "National Laboratory",
    "discovery_year": 1998},

{   "name": "moscovium",
    "symbol": "Mc",
    "atomic_number": 115,
    "atomic_mass": 290,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 5),
    "state": "solid",
    "group": 15,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research, Lawrence Livermore "
                    "National Laboratory",
    "discovery_year": 2003},

{   "name": "livermorium",
    "symbol": "Lv",
    "atomic_number": 116,
    "atomic_mass": 293,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 6),
    "state": "solid",
    "group": 16,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research, Lawrence Livermore "
                    "National Laboratory",
    "discovery_year": 2000},

{   "name": "tennessine",
    "symbol": "Ts",
    "atomic_number": 117,
    "atomic_mass": 294,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 7),
    "state": "solid",
    "group": 17,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research, Lawrence Livermore "
                    "National Laboratory, Vanderbilt University, Oak Ridge "
                    "National Laboratory",
    "discovery_year": 2009},
    
{   "name": "oganesson",
    "symbol": "Og",
    "atomic_number": 118,
    "atomic_mass": 294,
    "electrons_per_shell": (2, 8, 18, 32, 32, 18, 8),
    "state": "solid",
    "group": 18,
    "period": 7,
    "melting_point_k": None,
    "boiling_point_k": None,
    "density": None,
    "natural": False,
    "has_stable_isotope": False,
    "discovery": "Joint Institute for Nuclear Research, Lawrence Livermore "
                    "National Laboratory",
    "discovery_year": 2002}]