The SkyPy Code of Conduct
=========================

## 1. Introduction

The SkyPy Board is committed to creating a friendly and respectful place for research and scientific discussion. All SkyPy Members are expected to show respect and courtesy to others both inside and outside the team.

By being a Member of the SkyPy Project, Members accept to abide by The SkyPy Code of Conduct and accept the procedures by which Code of Conduct incidents are resolved. Any form of behaviour to exclude, intimidate, or harass is a violation of the Code of Conduct.

All Members are required to conform to the Code of Conduct. This Code of Conduct applies to all spaces managed by the Team including, but not limited to, workshops, email lists, and online forums such as GitHub, Slack, and Twitter. The Board may also choose to consider cases that occur outside the Team spaces.

If you believe someone is violating the Code of Conduct, we ask that you report it to the Board who will take the appropriate action to address the situation.

The Board is responsible for enforcing the Code of Conduct.

## 2. The Code of Conduct

The Board is dedicated to providing a welcoming and supportive environment for all people, regardless of background or identity. As such, we do not tolerate behaviour that is disrespectful or that excludes, intimidates, or harasses  others. We do not tolerate discrimination or harassment based on characteristics that include, but are not limited to, gender identity and expression, sexual orientation, disability, physical appearance, body shape, citizenship, nationality, ethnic or social origin, pregnancy, familial status, veteran status, genetic information, religion or belief (or lack thereof), membership of a national minority, property, age, education, socio-economic status, technical choices, and experience level.

Workshop hosts are expected to assist with the enforcement of the Code of Conduct. Project Members are required to accept the procedures by which the Board resolves any Code of Conduct incidents, which may include storage and processing of their personal information. The Board reserves the right to also investigate possible cases where the Code of Conduct has been violated by Members outside the Project spaces. The Board may decide that the case should be treated as having happened inside a Team space and to take action against individuals in line with the Code of Conduct.

## 2.1 Expected behaviour

All team Members are expected to show respect and courtesy to others. All interactions should be professional regardless of platform: either online, by telephone or in-person. To foster a positive and professional learning environment, we encourage the following kinds of behaviours in all Project spaces and all interactions about the Project:

- Use welcoming and inclusive language
- Be respectful of different viewpoints and experiences
- Gracefully accept constructive criticism
- Focus on what is best for the community
- Show courtesy and respect towards other community members

Also, please see the [Four Social Rules](https://www.recurse.com/manual#sub-sec-social-rules) for further recommendations.

## 2.2 Unacceptable behaviour

Examples of unacceptable behaviour by participants in any Project space include:

- Written or verbal comments which have the effect of excluding people on the basis of membership of any specific group
 Causing someone to fear for their safety, such as through stalking, following, or intimidation
- Violent threats or language directed against another person
- The display of sexual or violent images
- Unwelcome sexual attention
- Nonconsensual or unwelcome physical contact
- Sustained disruption of talks, events or communications
- Insults or put-downs
- Sexist, racist, homophobic, transphobic, ableist, or exclusionary jokes
- Excessive swearing
- Incitement to violence, suicide, or self-harm
- Continuing to initiate interaction (including photography or recording) with someone after being asked to stop
- Publication of private communication without consent

## 3 Complaints procedures

If you feel uncomfortable, don’t wait until it gets worse. [This guide](https://www.edcc.edu/counseling/documents/Conflict.pdf) may help provide ways to broach the issues with the SkyPy Board and/or other Members. Please also see articles on Abuse of Power e.g. [48 Ways Managers Abuse Their Power and Destroy Employee Engagement](https://www.linkedin.com/pulse/48-ways-managers-abuse-power-destroy-employee-hanna/).

There are three mechanisms for dealing with complaints:

1. Seek advice from the Ombudsperson,
2. Seek advice from the Lead of the Coordination Team,
3. File a complaint directly with all or some of the Board.

If there is any concern about a conflict of interest of any Board member then you may choose which member(s) of the Board to contact. By default the whole Board will discuss the complaint including writing notes on key points in a private SkyPy slack channel visible only to the current members of the Board. Therefore, if you foresee a potential conflict of interest with one (or more) members of the Board, or if would prefer your complaint to remain verbal (not recorded in any way other than in individual current Board members’ memories) then please note this when you register your complaint. When the Board membership changes the discussion of previous complaints will not automatically be shared with new Board members, and will only be shared with new Board members with the consent of the complainee(s).

It is acceptable to contact a member of the Board to say that you would like to have a phone call without giving the reasons for the call, and to ask for the entire contents of the conversation to remain confidential. The only situation in which the Board member would violate your wishes to keep the conversation confidential is if they perceive your safety to be at risk e.g. if you seemed suicidal they would try to contact a local responsible person which may include the emergency services.

Members of the Board and their contact details:

- Brian Nord - Ombudsperson - nord@fnal.gov
- Sarah Bridle - Chair of the Board - pa@sarahbridle.net
- Adam Amara - adam.amara@port.ac.uk

If you feel uncomfortable, talk to someone you trust. If you feel afraid of telling someone you trust, then this is generally a sign that there is a serious problem and you need to get help. Remember, it isn’t always possible to resolve problems on your own. Unfortunately, the spectrum of human nature includes some extremely difficult people who are capable of making your life a misery. If you find yourself in this situation, you have no reason to feel ashamed, or that you should be able to solve the problem on your own.

Your Board is here to help you and will take seriously any violations of the Code of Conduct and take steps to resolve the situation in a timely way.

## 3.1 Violations of the Code of Conduct

If the Board deems that a Member has violated the Code of Conduct then it will first consider whether the offender should be ejected from the Project (i.e. lose their Member status). If not, a note describing the violation will be added to the offending Member’s profile page - which is visible inside the Project. The Board will then review this violation in the context of any previous violations and complaints (including verbal complaints that are not recorded on the offender’s profile page), and may then decide to eject the offender from the Project.

## 3.2 Ejection from the Project

If the Board decides to eject someone from the Project, they will inform the ejected person at the same time as notifying all Members, and remove access to all Project resources, including github, slack and google docs.

The Board understands that taking action against an aggressor could itself cause problems for the victim. The Board will consider this when deciding how to act, and will consult with the victim(s) if this is a concern.

## 4. Process for updating the Code of Conduct

The Code of Conduct is a living document, which is the responsibility of the Board. The Code of Conduct lives on the SkyPy GitHub repository and this is the place where suggestions are welcomed on how it might be updated and improved. Proposed revisions will be considered by the Board. Before they are put into practice they will be emailed to the SkyPy team with a period of 2 weeks for feedback. If no objections are raised, the new Code of Conduct will replace the old one. If there are complaints, the Board will review the issues raised and decide whether (i) to continue with the updated version of the CoC, (ii) keep the old version or (iii) begin the process of drafting a new version.

## Credits

This Code of Conduct borrows heavily from the Carpentries Code of Conduct.

## License

This Code of Conduct is licensed under a Creative Commons Attribution 4.0 International License. We encourage other communities related to ours to use or adapt this code as they see fit. Feedback is welcome.

## Update Logs

[update logs will be placed here in future revisions]
