# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class TeamSyncGroupMapping(pulumi.CustomResource):
    etag: pulumi.Output[str]
    groups: pulumi.Output[list]
    """
    An Array of GitHub Identity Provider Groups (or empty []).  Each `group` block consists of the fields documented below.
    ___

      * `groupDescription` (`str`) - The description of the IdP group.
      * `groupId` (`str`) - The ID of the IdP group.
      * `groupName` (`str`) - The name of the IdP group. 
    """
    team_slug: pulumi.Output[str]
    """
    Slug of the team
    """
    def __init__(__self__, resource_name, opts=None, groups=None, team_slug=None, __props__=None, __name__=None, __opts__=None):
        """
        This resource allows you to create and manage Identity Provider (IdP) group connections within your GitHub teams.
        You must have team synchronization enabled for organizations owned by enterprise accounts.

        To learn more about team synchronization between IdPs and Github, please refer to:
        https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/synchronizing-teams-between-your-identity-provider-and-github

        ## Example Usage



        ```python
        import pulumi
        import pulumi_github as github

        example_groups = github.get_organization_team_sync_groups()
        example_group_mapping = github.TeamSyncGroupMapping("exampleGroupMapping",
            team_slug="example",
            dynamic=[{
                "forEach": [g for g in example_groups.groups if g["groupName"] == "some_team_group"],
                "content": [{
                    "groupId": group["value"]["group_id"],
                    "groupName": group["value"]["group_name"],
                    "groupDescription": group["value"]["group_description"],
                }],
            }])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] groups: An Array of GitHub Identity Provider Groups (or empty []).  Each `group` block consists of the fields documented below.
               ___
        :param pulumi.Input[str] team_slug: Slug of the team

        The **groups** object supports the following:

          * `groupDescription` (`pulumi.Input[str]`) - The description of the IdP group.
          * `groupId` (`pulumi.Input[str]`) - The ID of the IdP group.
          * `groupName` (`pulumi.Input[str]`) - The name of the IdP group. 
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['groups'] = groups
            if team_slug is None:
                raise TypeError("Missing required property 'team_slug'")
            __props__['team_slug'] = team_slug
            __props__['etag'] = None
        super(TeamSyncGroupMapping, __self__).__init__(
            'github:index/teamSyncGroupMapping:TeamSyncGroupMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, etag=None, groups=None, team_slug=None):
        """
        Get an existing TeamSyncGroupMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] groups: An Array of GitHub Identity Provider Groups (or empty []).  Each `group` block consists of the fields documented below.
               ___
        :param pulumi.Input[str] team_slug: Slug of the team

        The **groups** object supports the following:

          * `groupDescription` (`pulumi.Input[str]`) - The description of the IdP group.
          * `groupId` (`pulumi.Input[str]`) - The ID of the IdP group.
          * `groupName` (`pulumi.Input[str]`) - The name of the IdP group. 
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["etag"] = etag
        __props__["groups"] = groups
        __props__["team_slug"] = team_slug
        return TeamSyncGroupMapping(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

