# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class RepositoryCollaborator(pulumi.CustomResource):
    invitation_id: pulumi.Output[str]
    """
    ID of the invitation to be used in `.UserInvitationAccepter`
    """
    permission: pulumi.Output[str]
    """
    The permission of the outside collaborator for the repository.
    Must be one of `pull`, `push`, `maintain`, `triage` or `admin`. Defaults to `push`.
    """
    repository: pulumi.Output[str]
    """
    The GitHub repository
    """
    username: pulumi.Output[str]
    """
    The user to add to the repository as a collaborator.
    """
    def __init__(__self__, resource_name, opts=None, permission=None, repository=None, username=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a GitHub repository collaborator resource.

        This resource allows you to add/remove collaborators from repositories in your
        organization. Collaborators can have explicit (and differing levels of) read,
        write, or administrator access to specific repositories in your organization,
        without giving the user full organization membership.

        When applied, an invitation will be sent to the user to become a collaborator
        on a repository. When destroyed, either the invitation will be cancelled or the
        collaborator will be removed from the repository.

        Further documentation on GitHub collaborators:

        - [Adding outside collaborators to repositories in your organization](https://help.github.com/articles/adding-outside-collaborators-to-repositories-in-your-organization/)
        - [Converting an organization member to an outside collaborator](https://help.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)

        ## Example Usage



        ```python
        import pulumi
        import pulumi_github as github

        # Add a collaborator to a repository
        a_repo_collaborator = github.RepositoryCollaborator("aRepoCollaborator",
            permission="admin",
            repository="our-cool-repo",
            username="SomeUser")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] permission: The permission of the outside collaborator for the repository.
               Must be one of `pull`, `push`, `maintain`, `triage` or `admin`. Defaults to `push`.
        :param pulumi.Input[str] repository: The GitHub repository
        :param pulumi.Input[str] username: The user to add to the repository as a collaborator.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['permission'] = permission
            if repository is None:
                raise TypeError("Missing required property 'repository'")
            __props__['repository'] = repository
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['invitation_id'] = None
        super(RepositoryCollaborator, __self__).__init__(
            'github:index/repositoryCollaborator:RepositoryCollaborator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, invitation_id=None, permission=None, repository=None, username=None):
        """
        Get an existing RepositoryCollaborator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] invitation_id: ID of the invitation to be used in `.UserInvitationAccepter`
        :param pulumi.Input[str] permission: The permission of the outside collaborator for the repository.
               Must be one of `pull`, `push`, `maintain`, `triage` or `admin`. Defaults to `push`.
        :param pulumi.Input[str] repository: The GitHub repository
        :param pulumi.Input[str] username: The user to add to the repository as a collaborator.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["invitation_id"] = invitation_id
        __props__["permission"] = permission
        __props__["repository"] = repository
        __props__["username"] = username
        return RepositoryCollaborator(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

