# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Repository(pulumi.CustomResource):
    allow_merge_commit: pulumi.Output[bool]
    """
    Set to `false` to disable merge commits on the repository.
    """
    allow_rebase_merge: pulumi.Output[bool]
    """
    Set to `false` to disable rebase merges on the repository.
    """
    allow_squash_merge: pulumi.Output[bool]
    """
    Set to `false` to disable squash merges on the repository.
    """
    archived: pulumi.Output[bool]
    """
    Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
    """
    auto_init: pulumi.Output[bool]
    """
    Set to `true` to produce an initial commit in the repository.
    """
    default_branch: pulumi.Output[str]
    """
    The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
    and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
    initial repository creation and create the target branch inside of the repository prior to setting this attribute.
    """
    delete_branch_on_merge: pulumi.Output[bool]
    """
    Automatically delete head branch after a pull request is merged. Defaults to `false`.
    """
    description: pulumi.Output[str]
    """
    A description of the repository.
    """
    etag: pulumi.Output[str]
    full_name: pulumi.Output[str]
    """
    A string of the form "orgname/reponame".
    """
    git_clone_url: pulumi.Output[str]
    """
    URL that can be provided to `git clone` to clone the repository anonymously via the git protocol.
    """
    gitignore_template: pulumi.Output[str]
    """
    Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
    """
    has_downloads: pulumi.Output[bool]
    """
    Set to `true` to enable the (deprecated) downloads features on the repository.
    """
    has_issues: pulumi.Output[bool]
    """
    Set to `true` to enable the GitHub Issues features
    on the repository.
    """
    has_projects: pulumi.Output[bool]
    """
    Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
    """
    has_wiki: pulumi.Output[bool]
    """
    Set to `true` to enable the GitHub Wiki features on
    the repository.
    """
    homepage_url: pulumi.Output[str]
    """
    URL of a page describing the project.
    """
    html_url: pulumi.Output[str]
    """
    URL to the repository on the web.
    """
    http_clone_url: pulumi.Output[str]
    """
    URL that can be provided to `git clone` to clone the repository via HTTPS.
    """
    is_template: pulumi.Output[bool]
    """
    Set to `true` to tell GitHub that this is a template repository.
    """
    license_template: pulumi.Output[str]
    """
    Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
    """
    name: pulumi.Output[str]
    """
    The name of the repository.
    """
    node_id: pulumi.Output[str]
    private: pulumi.Output[bool]
    """
    Set to `true` to create a private repository.
    Repositories are created as public (e.g. open source) by default.
    """
    ssh_clone_url: pulumi.Output[str]
    """
    URL that can be provided to `git clone` to clone the repository via SSH.
    """
    svn_url: pulumi.Output[str]
    """
    URL that can be provided to `svn checkout` to check out the repository via GitHub's Subversion protocol emulation.
    """
    template: pulumi.Output[dict]
    """
    Use a template repository to create this resource. See Template Repositories below for details.

      * `owner` (`str`)
      * `repository` (`str`)
    """
    topics: pulumi.Output[list]
    """
    The list of topics of the repository.
    """
    def __init__(__self__, resource_name, opts=None, allow_merge_commit=None, allow_rebase_merge=None, allow_squash_merge=None, archived=None, auto_init=None, default_branch=None, delete_branch_on_merge=None, description=None, gitignore_template=None, has_downloads=None, has_issues=None, has_projects=None, has_wiki=None, homepage_url=None, is_template=None, license_template=None, name=None, private=None, template=None, topics=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Repository resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_merge_commit: Set to `false` to disable merge commits on the repository.
        :param pulumi.Input[bool] allow_rebase_merge: Set to `false` to disable rebase merges on the repository.
        :param pulumi.Input[bool] allow_squash_merge: Set to `false` to disable squash merges on the repository.
        :param pulumi.Input[bool] archived: Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        :param pulumi.Input[bool] auto_init: Set to `true` to produce an initial commit in the repository.
        :param pulumi.Input[str] default_branch: The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
               and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
               initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        :param pulumi.Input[bool] delete_branch_on_merge: Automatically delete head branch after a pull request is merged. Defaults to `false`.
        :param pulumi.Input[str] description: A description of the repository.
        :param pulumi.Input[str] gitignore_template: Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        :param pulumi.Input[bool] has_downloads: Set to `true` to enable the (deprecated) downloads features on the repository.
        :param pulumi.Input[bool] has_issues: Set to `true` to enable the GitHub Issues features
               on the repository.
        :param pulumi.Input[bool] has_projects: Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        :param pulumi.Input[bool] has_wiki: Set to `true` to enable the GitHub Wiki features on
               the repository.
        :param pulumi.Input[str] homepage_url: URL of a page describing the project.
        :param pulumi.Input[bool] is_template: Set to `true` to tell GitHub that this is a template repository.
        :param pulumi.Input[str] license_template: Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[bool] private: Set to `true` to create a private repository.
               Repositories are created as public (e.g. open source) by default.
        :param pulumi.Input[dict] template: Use a template repository to create this resource. See Template Repositories below for details.
        :param pulumi.Input[list] topics: The list of topics of the repository.

        The **template** object supports the following:

          * `owner` (`pulumi.Input[str]`)
          * `repository` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['allow_merge_commit'] = allow_merge_commit
            __props__['allow_rebase_merge'] = allow_rebase_merge
            __props__['allow_squash_merge'] = allow_squash_merge
            __props__['archived'] = archived
            __props__['auto_init'] = auto_init
            __props__['default_branch'] = default_branch
            __props__['delete_branch_on_merge'] = delete_branch_on_merge
            __props__['description'] = description
            __props__['gitignore_template'] = gitignore_template
            __props__['has_downloads'] = has_downloads
            __props__['has_issues'] = has_issues
            __props__['has_projects'] = has_projects
            __props__['has_wiki'] = has_wiki
            __props__['homepage_url'] = homepage_url
            __props__['is_template'] = is_template
            __props__['license_template'] = license_template
            __props__['name'] = name
            __props__['private'] = private
            __props__['template'] = template
            __props__['topics'] = topics
            __props__['etag'] = None
            __props__['full_name'] = None
            __props__['git_clone_url'] = None
            __props__['html_url'] = None
            __props__['http_clone_url'] = None
            __props__['node_id'] = None
            __props__['ssh_clone_url'] = None
            __props__['svn_url'] = None
        super(Repository, __self__).__init__(
            'github:index/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, allow_merge_commit=None, allow_rebase_merge=None, allow_squash_merge=None, archived=None, auto_init=None, default_branch=None, delete_branch_on_merge=None, description=None, etag=None, full_name=None, git_clone_url=None, gitignore_template=None, has_downloads=None, has_issues=None, has_projects=None, has_wiki=None, homepage_url=None, html_url=None, http_clone_url=None, is_template=None, license_template=None, name=None, node_id=None, private=None, ssh_clone_url=None, svn_url=None, template=None, topics=None):
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_merge_commit: Set to `false` to disable merge commits on the repository.
        :param pulumi.Input[bool] allow_rebase_merge: Set to `false` to disable rebase merges on the repository.
        :param pulumi.Input[bool] allow_squash_merge: Set to `false` to disable squash merges on the repository.
        :param pulumi.Input[bool] archived: Specifies if the repository should be archived. Defaults to `false`. **NOTE** Currently, the API does not support unarchiving.
        :param pulumi.Input[bool] auto_init: Set to `true` to produce an initial commit in the repository.
        :param pulumi.Input[str] default_branch: The name of the default branch of the repository. **NOTE:** This can only be set after a repository has already been created,
               and after a correct reference has been created for the target branch inside the repository. This means a user will have to omit this parameter from the
               initial repository creation and create the target branch inside of the repository prior to setting this attribute.
        :param pulumi.Input[bool] delete_branch_on_merge: Automatically delete head branch after a pull request is merged. Defaults to `false`.
        :param pulumi.Input[str] description: A description of the repository.
        :param pulumi.Input[str] full_name: A string of the form "orgname/reponame".
        :param pulumi.Input[str] git_clone_url: URL that can be provided to `git clone` to clone the repository anonymously via the git protocol.
        :param pulumi.Input[str] gitignore_template: Use the [name of the template](https://github.com/github/gitignore) without the extension. For example, "Haskell".
        :param pulumi.Input[bool] has_downloads: Set to `true` to enable the (deprecated) downloads features on the repository.
        :param pulumi.Input[bool] has_issues: Set to `true` to enable the GitHub Issues features
               on the repository.
        :param pulumi.Input[bool] has_projects: Set to `true` to enable the GitHub Projects features on the repository. Per the GitHub [documentation](https://developer.github.com/v3/repos/#create) when in an organization that has disabled repository projects it will default to `false` and will otherwise default to `true`. If you specify `true` when it has been disabled it will return an error.
        :param pulumi.Input[bool] has_wiki: Set to `true` to enable the GitHub Wiki features on
               the repository.
        :param pulumi.Input[str] homepage_url: URL of a page describing the project.
        :param pulumi.Input[str] html_url: URL to the repository on the web.
        :param pulumi.Input[str] http_clone_url: URL that can be provided to `git clone` to clone the repository via HTTPS.
        :param pulumi.Input[bool] is_template: Set to `true` to tell GitHub that this is a template repository.
        :param pulumi.Input[str] license_template: Use the [name of the template](https://github.com/github/choosealicense.com/tree/gh-pages/_licenses) without the extension. For example, "mit" or "mpl-2.0".
        :param pulumi.Input[str] name: The name of the repository.
        :param pulumi.Input[bool] private: Set to `true` to create a private repository.
               Repositories are created as public (e.g. open source) by default.
        :param pulumi.Input[str] ssh_clone_url: URL that can be provided to `git clone` to clone the repository via SSH.
        :param pulumi.Input[str] svn_url: URL that can be provided to `svn checkout` to check out the repository via GitHub's Subversion protocol emulation.
        :param pulumi.Input[dict] template: Use a template repository to create this resource. See Template Repositories below for details.
        :param pulumi.Input[list] topics: The list of topics of the repository.

        The **template** object supports the following:

          * `owner` (`pulumi.Input[str]`)
          * `repository` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["allow_merge_commit"] = allow_merge_commit
        __props__["allow_rebase_merge"] = allow_rebase_merge
        __props__["allow_squash_merge"] = allow_squash_merge
        __props__["archived"] = archived
        __props__["auto_init"] = auto_init
        __props__["default_branch"] = default_branch
        __props__["delete_branch_on_merge"] = delete_branch_on_merge
        __props__["description"] = description
        __props__["etag"] = etag
        __props__["full_name"] = full_name
        __props__["git_clone_url"] = git_clone_url
        __props__["gitignore_template"] = gitignore_template
        __props__["has_downloads"] = has_downloads
        __props__["has_issues"] = has_issues
        __props__["has_projects"] = has_projects
        __props__["has_wiki"] = has_wiki
        __props__["homepage_url"] = homepage_url
        __props__["html_url"] = html_url
        __props__["http_clone_url"] = http_clone_url
        __props__["is_template"] = is_template
        __props__["license_template"] = license_template
        __props__["name"] = name
        __props__["node_id"] = node_id
        __props__["private"] = private
        __props__["ssh_clone_url"] = ssh_clone_url
        __props__["svn_url"] = svn_url
        __props__["template"] = template
        __props__["topics"] = topics
        return Repository(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

