# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetReleaseResult:
    """
    A collection of values returned by getRelease.
    """
    def __init__(__self__, asserts_url=None, body=None, created_at=None, draft=None, html_url=None, id=None, name=None, owner=None, prerelease=None, published_at=None, release_id=None, release_tag=None, repository=None, retrieve_by=None, tarball_url=None, target_commitish=None, upload_url=None, url=None, zipball_url=None):
        if asserts_url and not isinstance(asserts_url, str):
            raise TypeError("Expected argument 'asserts_url' to be a str")
        __self__.asserts_url = asserts_url
        """
        URL of any associated assets with the release
        """
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        __self__.body = body
        """
        Contents of the description (body) of a release
        """
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        __self__.created_at = created_at
        """
        Date of release creation
        """
        if draft and not isinstance(draft, bool):
            raise TypeError("Expected argument 'draft' to be a bool")
        __self__.draft = draft
        """
        (`Boolean`) indicates whether the release is a draft
        """
        if html_url and not isinstance(html_url, str):
            raise TypeError("Expected argument 'html_url' to be a str")
        __self__.html_url = html_url
        """
        URL directing to detailed information on the release
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        """
        Name of release
        """
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        __self__.owner = owner
        if prerelease and not isinstance(prerelease, bool):
            raise TypeError("Expected argument 'prerelease' to be a bool")
        __self__.prerelease = prerelease
        """
        (`Boolean`) indicates whether the release is a prerelease
        """
        if published_at and not isinstance(published_at, str):
            raise TypeError("Expected argument 'published_at' to be a str")
        __self__.published_at = published_at
        """
        Date of release publishing
        """
        if release_id and not isinstance(release_id, float):
            raise TypeError("Expected argument 'release_id' to be a float")
        __self__.release_id = release_id
        """
        ID of release
        """
        if release_tag and not isinstance(release_tag, str):
            raise TypeError("Expected argument 'release_tag' to be a str")
        __self__.release_tag = release_tag
        """
        Tag of release
        """
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        __self__.repository = repository
        if retrieve_by and not isinstance(retrieve_by, str):
            raise TypeError("Expected argument 'retrieve_by' to be a str")
        __self__.retrieve_by = retrieve_by
        if tarball_url and not isinstance(tarball_url, str):
            raise TypeError("Expected argument 'tarball_url' to be a str")
        __self__.tarball_url = tarball_url
        """
        Download URL of a specific release in `tar.gz` format
        """
        if target_commitish and not isinstance(target_commitish, str):
            raise TypeError("Expected argument 'target_commitish' to be a str")
        __self__.target_commitish = target_commitish
        """
        Commitish value that determines where the Git release is created from
        """
        if upload_url and not isinstance(upload_url, str):
            raise TypeError("Expected argument 'upload_url' to be a str")
        __self__.upload_url = upload_url
        """
        URL that can be used to upload Assets to the release
        """
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        __self__.url = url
        """
        Base URL of the release
        """
        if zipball_url and not isinstance(zipball_url, str):
            raise TypeError("Expected argument 'zipball_url' to be a str")
        __self__.zipball_url = zipball_url
        """
        Download URL of a specific release in `zip` format
        """
class AwaitableGetReleaseResult(GetReleaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReleaseResult(
            asserts_url=self.asserts_url,
            body=self.body,
            created_at=self.created_at,
            draft=self.draft,
            html_url=self.html_url,
            id=self.id,
            name=self.name,
            owner=self.owner,
            prerelease=self.prerelease,
            published_at=self.published_at,
            release_id=self.release_id,
            release_tag=self.release_tag,
            repository=self.repository,
            retrieve_by=self.retrieve_by,
            tarball_url=self.tarball_url,
            target_commitish=self.target_commitish,
            upload_url=self.upload_url,
            url=self.url,
            zipball_url=self.zipball_url)

def get_release(owner=None,release_id=None,release_tag=None,repository=None,retrieve_by=None,opts=None):
    """
    Use this data source to retrieve information about a GitHub release in a specific repository.

    ## Example Usage



    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_release(owner="example-owner",
        repository="example-repository",
        retrieve_by="latest")
    ```



    :param str owner: Owner of the repository.
    :param float release_id: ID of the release to retrieve. Must be specified when `retrieve_by` = `id`.
    :param str release_tag: Tag of the release to retrieve. Must be specified when `retrieve_by` = `tag`.
    :param str repository: Name of the repository to retrieve the release from.
    :param str retrieve_by: Describes how to fetch the release. Valid values are `id`, `tag`, `latest`.
    """
    __args__ = dict()


    __args__['owner'] = owner
    __args__['releaseId'] = release_id
    __args__['releaseTag'] = release_tag
    __args__['repository'] = repository
    __args__['retrieveBy'] = retrieve_by
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('github:index/getRelease:getRelease', __args__, opts=opts).value

    return AwaitableGetReleaseResult(
        asserts_url=__ret__.get('assertsUrl'),
        body=__ret__.get('body'),
        created_at=__ret__.get('createdAt'),
        draft=__ret__.get('draft'),
        html_url=__ret__.get('htmlUrl'),
        id=__ret__.get('id'),
        name=__ret__.get('name'),
        owner=__ret__.get('owner'),
        prerelease=__ret__.get('prerelease'),
        published_at=__ret__.get('publishedAt'),
        release_id=__ret__.get('releaseId'),
        release_tag=__ret__.get('releaseTag'),
        repository=__ret__.get('repository'),
        retrieve_by=__ret__.get('retrieveBy'),
        tarball_url=__ret__.get('tarballUrl'),
        target_commitish=__ret__.get('targetCommitish'),
        upload_url=__ret__.get('uploadUrl'),
        url=__ret__.get('url'),
        zipball_url=__ret__.get('zipballUrl'))
