# Justpy Tutorial demo calendar_test 
# FullCalendar Example       
#      
# generated by write_as_demo  at 2022-11-13T18:41:26.821135+00:00 
# 
# see https://justpy.io/tutorial/advanced_components#fullcalendar-example
import justpy as jp


class FullCalendar(jp.JustpyBaseComponent):
    vue_type = 'fullcalendar'

    def __init__(self, **kwargs):
        self.options = jp.Dict()
        self.classes = ''
        self.style = ''
        self.show = True
        self.event_propagation = True
        self.pages = {}
        kwargs['temp'] = False  # Force an id to be assigned
        super().__init__(**kwargs)
        self.allowed_events = ['eventClick', 'eventDrop']
        if type(self.options) != jp.Dict:
            self.options = jp.Dict(self.options)
        self.initialize(**kwargs)

    def add_to_page(self, wp: jp.WebPage):
        wp.add_component(self)

    def react(self, data):
        pass

    async def run_method(self, command, websocket):
        await websocket.send_json({'type': 'run_method', 'data': command, 'id': self.id})
        # So the page itself does not update, return True not None
        return True

    def convert_object_to_dict(self):
        d = {}
        d['vue_type'] = self.vue_type
        d['id'] = self.id
        d['show'] = self.show
        d['classes'] = self.classes
        d['style'] = self.style
        d['event_propagation'] = self.event_propagation
        d['events'] = self.events
        d['options'] = self.options
        return d


calendar_options = {
    'plugins': ['dayGrid', 'interaction'],
    'editable': True,
    'header': {'left': '',
               'center': 'title',
               'right': 'today prev,next'},
    'defaultDate': '2020-05-15',
    'events': [
        {
            'title': 'This is an event',
            'start': '2020-05-02',
            'end': '2020-05-12',
            'color': 'red',
            'editable': True
        },
        {
            'title': 'event with a URL',
            'url': 'https://www.google.com/',
            'start': '2020-05-03'
        }
    ]
}
# https://fullcalendar.io/docs/plugin-index
head_html = """
<link rel="stylesheet" href="https://unpkg.com/@fullcalendar/core@4.4.0/main.min.css">
<link rel="stylesheet" href="https://unpkg.com/@fullcalendar/daygrid@4.4.0/main.min.css">
<script src="https://unpkg.com/@fullcalendar/core@4.4.0/main.min.js"></script>
<script src="https://unpkg.com/@fullcalendar/daygrid@4.4.0/main.min.js"></script>
<script src="https://unpkg.com/@fullcalendar/interaction@4.4.0/main.min.js"></script>
"""

async def add_event(self, msg):
    print(msg)
    self.calendar.options['events'].append({'title': 'Very new event', 'start': '2020-05-02', 'end': '2020-05-05', 'color': 'green', 'editable': True})

def event_click(self, msg):
    print(msg)

def event_drop(self, msg):
    print(msg)
    print(msg.all_events)
    self.options['events'] = msg.all_events

def calendar_test():
    wp = jp.QuasarPage()
    wp.head_html = head_html
    calendar = FullCalendar(a=wp, classes='q-ma-lg', style='width: 700px;')
    calendar.options = calendar_options
    calendar.on('eventClick', event_click)
    calendar.on('eventDrop', event_drop)
    b = jp.QBtn(label='Add Event', a=wp, classes='q-ma-lg', click=add_event)
    b.calendar = calendar
    return wp


# initialize the demo
from examples.basedemo import Demo
Demo("calendar_test", calendar_test)
