# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TokenExchangeRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'client_id': 'str',
        'code': 'str',
        'grant_type': 'str',
        'redirect_uri': 'str',
        'client_secret': 'str',
        'code_verifier': 'str'
    }

    attribute_map = {
        'client_id': 'client_id',
        'code': 'code',
        'grant_type': 'grant_type',
        'redirect_uri': 'redirect_uri',
        'client_secret': 'client_secret',
        'code_verifier': 'code_verifier'
    }

    def __init__(self, client_id=None, code=None, grant_type=None, redirect_uri=None, client_secret=None, code_verifier=None):  # noqa: E501
        """TokenExchangeRequest - a model defined in Swagger"""  # noqa: E501
        self._client_id = None
        self._code = None
        self._grant_type = None
        self._redirect_uri = None
        self._client_secret = None
        self._code_verifier = None
        self.discriminator = None
        if client_id is not None:
            self.client_id = client_id
        if code is not None:
            self.code = code
        if grant_type is not None:
            self.grant_type = grant_type
        if redirect_uri is not None:
            self.redirect_uri = redirect_uri
        if client_secret is not None:
            self.client_secret = client_secret
        if code_verifier is not None:
            self.code_verifier = code_verifier

    @property
    def client_id(self):
        """Gets the client_id of this TokenExchangeRequest.  # noqa: E501


        :return: The client_id of this TokenExchangeRequest.  # noqa: E501
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this TokenExchangeRequest.


        :param client_id: The client_id of this TokenExchangeRequest.  # noqa: E501
        :type: str
        """

        self._client_id = client_id

    @property
    def code(self):
        """Gets the code of this TokenExchangeRequest.  # noqa: E501


        :return: The code of this TokenExchangeRequest.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this TokenExchangeRequest.


        :param code: The code of this TokenExchangeRequest.  # noqa: E501
        :type: str
        """

        self._code = code

    @property
    def grant_type(self):
        """Gets the grant_type of this TokenExchangeRequest.  # noqa: E501


        :return: The grant_type of this TokenExchangeRequest.  # noqa: E501
        :rtype: str
        """
        return self._grant_type

    @grant_type.setter
    def grant_type(self, grant_type):
        """Sets the grant_type of this TokenExchangeRequest.


        :param grant_type: The grant_type of this TokenExchangeRequest.  # noqa: E501
        :type: str
        """

        self._grant_type = grant_type

    @property
    def redirect_uri(self):
        """Gets the redirect_uri of this TokenExchangeRequest.  # noqa: E501


        :return: The redirect_uri of this TokenExchangeRequest.  # noqa: E501
        :rtype: str
        """
        return self._redirect_uri

    @redirect_uri.setter
    def redirect_uri(self, redirect_uri):
        """Sets the redirect_uri of this TokenExchangeRequest.


        :param redirect_uri: The redirect_uri of this TokenExchangeRequest.  # noqa: E501
        :type: str
        """

        self._redirect_uri = redirect_uri

    @property
    def client_secret(self):
        """Gets the client_secret of this TokenExchangeRequest.  # noqa: E501


        :return: The client_secret of this TokenExchangeRequest.  # noqa: E501
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """Sets the client_secret of this TokenExchangeRequest.


        :param client_secret: The client_secret of this TokenExchangeRequest.  # noqa: E501
        :type: str
        """

        self._client_secret = client_secret

    @property
    def code_verifier(self):
        """Gets the code_verifier of this TokenExchangeRequest.  # noqa: E501


        :return: The code_verifier of this TokenExchangeRequest.  # noqa: E501
        :rtype: str
        """
        return self._code_verifier

    @code_verifier.setter
    def code_verifier(self, code_verifier):
        """Sets the code_verifier of this TokenExchangeRequest.


        :param code_verifier: The code_verifier of this TokenExchangeRequest.  # noqa: E501
        :type: str
        """

        self._code_verifier = code_verifier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TokenExchangeRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TokenExchangeRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
