# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RelationshipKey(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'property_name': 'str',
        'data_type': 'str',
        'required': 'bool',
        'cardinality': 'float',
        'validation': 'Validation',
        'unique': 'bool',
        'options': 'list[object]',
        'default_value': 'str',
        'metatype_relationship_id': 'str',
        'id': 'str',
        'archived': 'bool',
        'created_at': 'str',
        'modified_at': 'str',
        'created_by': 'str',
        'modified_by': 'str'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'property_name': 'property_name',
        'data_type': 'data_type',
        'required': 'required',
        'cardinality': 'cardinality',
        'validation': 'validation',
        'unique': 'unique',
        'options': 'options',
        'default_value': 'defaultValue',
        'metatype_relationship_id': 'metatype_relationship_id',
        'id': 'id',
        'archived': 'archived',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'created_by': 'created_by',
        'modified_by': 'modified_by'
    }

    def __init__(self, name=None, description=None, property_name=None, data_type=None, required=None, cardinality=None, validation=None, unique=None, options=None, default_value=None, metatype_relationship_id=None, id=None, archived=None, created_at=None, modified_at=None, created_by=None, modified_by=None):  # noqa: E501
        """RelationshipKey - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._description = None
        self._property_name = None
        self._data_type = None
        self._required = None
        self._cardinality = None
        self._validation = None
        self._unique = None
        self._options = None
        self._default_value = None
        self._metatype_relationship_id = None
        self._id = None
        self._archived = None
        self._created_at = None
        self._modified_at = None
        self._created_by = None
        self._modified_by = None
        self.discriminator = None
        self.name = name
        self.description = description
        self.property_name = property_name
        self.data_type = data_type
        self.required = required
        self.cardinality = cardinality
        self.validation = validation
        self.unique = unique
        if options is not None:
            self.options = options
        if default_value is not None:
            self.default_value = default_value
        self.metatype_relationship_id = metatype_relationship_id
        self.id = id
        self.archived = archived
        self.created_at = created_at
        self.modified_at = modified_at
        self.created_by = created_by
        self.modified_by = modified_by

    @property
    def name(self):
        """Gets the name of this RelationshipKey.  # noqa: E501


        :return: The name of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RelationshipKey.


        :param name: The name of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this RelationshipKey.  # noqa: E501


        :return: The description of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this RelationshipKey.


        :param description: The description of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def property_name(self):
        """Gets the property_name of this RelationshipKey.  # noqa: E501


        :return: The property_name of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._property_name

    @property_name.setter
    def property_name(self, property_name):
        """Sets the property_name of this RelationshipKey.


        :param property_name: The property_name of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if property_name is None:
            raise ValueError("Invalid value for `property_name`, must not be `None`")  # noqa: E501

        self._property_name = property_name

    @property
    def data_type(self):
        """Gets the data_type of this RelationshipKey.  # noqa: E501


        :return: The data_type of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """Sets the data_type of this RelationshipKey.


        :param data_type: The data_type of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if data_type is None:
            raise ValueError("Invalid value for `data_type`, must not be `None`")  # noqa: E501

        self._data_type = data_type

    @property
    def required(self):
        """Gets the required of this RelationshipKey.  # noqa: E501


        :return: The required of this RelationshipKey.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this RelationshipKey.


        :param required: The required of this RelationshipKey.  # noqa: E501
        :type: bool
        """
        if required is None:
            raise ValueError("Invalid value for `required`, must not be `None`")  # noqa: E501

        self._required = required

    @property
    def cardinality(self):
        """Gets the cardinality of this RelationshipKey.  # noqa: E501


        :return: The cardinality of this RelationshipKey.  # noqa: E501
        :rtype: float
        """
        return self._cardinality

    @cardinality.setter
    def cardinality(self, cardinality):
        """Sets the cardinality of this RelationshipKey.


        :param cardinality: The cardinality of this RelationshipKey.  # noqa: E501
        :type: float
        """
        if cardinality is None:
            raise ValueError("Invalid value for `cardinality`, must not be `None`")  # noqa: E501

        self._cardinality = cardinality

    @property
    def validation(self):
        """Gets the validation of this RelationshipKey.  # noqa: E501


        :return: The validation of this RelationshipKey.  # noqa: E501
        :rtype: Validation
        """
        return self._validation

    @validation.setter
    def validation(self, validation):
        """Sets the validation of this RelationshipKey.


        :param validation: The validation of this RelationshipKey.  # noqa: E501
        :type: Validation
        """
        if validation is None:
            raise ValueError("Invalid value for `validation`, must not be `None`")  # noqa: E501

        self._validation = validation

    @property
    def unique(self):
        """Gets the unique of this RelationshipKey.  # noqa: E501


        :return: The unique of this RelationshipKey.  # noqa: E501
        :rtype: bool
        """
        return self._unique

    @unique.setter
    def unique(self, unique):
        """Sets the unique of this RelationshipKey.


        :param unique: The unique of this RelationshipKey.  # noqa: E501
        :type: bool
        """
        if unique is None:
            raise ValueError("Invalid value for `unique`, must not be `None`")  # noqa: E501

        self._unique = unique

    @property
    def options(self):
        """Gets the options of this RelationshipKey.  # noqa: E501


        :return: The options of this RelationshipKey.  # noqa: E501
        :rtype: list[object]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this RelationshipKey.


        :param options: The options of this RelationshipKey.  # noqa: E501
        :type: list[object]
        """

        self._options = options

    @property
    def default_value(self):
        """Gets the default_value of this RelationshipKey.  # noqa: E501


        :return: The default_value of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this RelationshipKey.


        :param default_value: The default_value of this RelationshipKey.  # noqa: E501
        :type: str
        """

        self._default_value = default_value

    @property
    def metatype_relationship_id(self):
        """Gets the metatype_relationship_id of this RelationshipKey.  # noqa: E501


        :return: The metatype_relationship_id of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._metatype_relationship_id

    @metatype_relationship_id.setter
    def metatype_relationship_id(self, metatype_relationship_id):
        """Sets the metatype_relationship_id of this RelationshipKey.


        :param metatype_relationship_id: The metatype_relationship_id of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if metatype_relationship_id is None:
            raise ValueError("Invalid value for `metatype_relationship_id`, must not be `None`")  # noqa: E501

        self._metatype_relationship_id = metatype_relationship_id

    @property
    def id(self):
        """Gets the id of this RelationshipKey.  # noqa: E501


        :return: The id of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this RelationshipKey.


        :param id: The id of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def archived(self):
        """Gets the archived of this RelationshipKey.  # noqa: E501


        :return: The archived of this RelationshipKey.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this RelationshipKey.


        :param archived: The archived of this RelationshipKey.  # noqa: E501
        :type: bool
        """
        if archived is None:
            raise ValueError("Invalid value for `archived`, must not be `None`")  # noqa: E501

        self._archived = archived

    @property
    def created_at(self):
        """Gets the created_at of this RelationshipKey.  # noqa: E501


        :return: The created_at of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this RelationshipKey.


        :param created_at: The created_at of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this RelationshipKey.  # noqa: E501


        :return: The modified_at of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this RelationshipKey.


        :param modified_at: The modified_at of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if modified_at is None:
            raise ValueError("Invalid value for `modified_at`, must not be `None`")  # noqa: E501

        self._modified_at = modified_at

    @property
    def created_by(self):
        """Gets the created_by of this RelationshipKey.  # noqa: E501


        :return: The created_by of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this RelationshipKey.


        :param created_by: The created_by of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")  # noqa: E501

        self._created_by = created_by

    @property
    def modified_by(self):
        """Gets the modified_by of this RelationshipKey.  # noqa: E501


        :return: The modified_by of this RelationshipKey.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this RelationshipKey.


        :param modified_by: The modified_by of this RelationshipKey.  # noqa: E501
        :type: str
        """
        if modified_by is None:
            raise ValueError("Invalid value for `modified_by`, must not be `None`")  # noqa: E501

        self._modified_by = modified_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RelationshipKey, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RelationshipKey):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
